package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RawIPSetFluent<A extends RawIPSetFluent<A>> extends BaseFluent<A>{
  public RawIPSetFluent() {
  }
  
  public RawIPSetFluent(RawIPSet instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CidrAndPortBuilder> cidrAndPorts = new ArrayList<CidrAndPortBuilder>();
  private List<String> cidrs = new ArrayList<String>();
  private String ipsetType;
  private String name;
  private List<String> setNames = new ArrayList<String>();
  private String source;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RawIPSet instance) {
    instance = (instance != null ? instance : new RawIPSet());
    if (instance != null) {
          this.withCidrAndPorts(instance.getCidrAndPorts());
          this.withCidrs(instance.getCidrs());
          this.withIpsetType(instance.getIpsetType());
          this.withName(instance.getName());
          this.withSetNames(instance.getSetNames());
          this.withSource(instance.getSource());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCidrAndPorts(int index,CidrAndPort item) {
    if (this.cidrAndPorts == null) {this.cidrAndPorts = new ArrayList<CidrAndPortBuilder>();}
    CidrAndPortBuilder builder = new CidrAndPortBuilder(item);
    if (index < 0 || index >= cidrAndPorts.size()) {
        _visitables.get("cidrAndPorts").add(builder);
        cidrAndPorts.add(builder);
    } else {
        _visitables.get("cidrAndPorts").add(builder);
        cidrAndPorts.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToCidrAndPorts(int index,CidrAndPort item) {
    if (this.cidrAndPorts == null) {this.cidrAndPorts = new ArrayList<CidrAndPortBuilder>();}
    CidrAndPortBuilder builder = new CidrAndPortBuilder(item);
    if (index < 0 || index >= cidrAndPorts.size()) {
        _visitables.get("cidrAndPorts").add(builder);
        cidrAndPorts.add(builder);
    } else {
        _visitables.get("cidrAndPorts").add(builder);
        cidrAndPorts.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToCidrAndPorts(io.fabric8.chaosmesh.v1alpha1.CidrAndPort... items) {
    if (this.cidrAndPorts == null) {this.cidrAndPorts = new ArrayList<CidrAndPortBuilder>();}
    for (CidrAndPort item : items) {CidrAndPortBuilder builder = new CidrAndPortBuilder(item);_visitables.get("cidrAndPorts").add(builder);this.cidrAndPorts.add(builder);} return (A)this;
  }
  
  public A addAllToCidrAndPorts(Collection<CidrAndPort> items) {
    if (this.cidrAndPorts == null) {this.cidrAndPorts = new ArrayList<CidrAndPortBuilder>();}
    for (CidrAndPort item : items) {CidrAndPortBuilder builder = new CidrAndPortBuilder(item);_visitables.get("cidrAndPorts").add(builder);this.cidrAndPorts.add(builder);} return (A)this;
  }
  
  public A removeFromCidrAndPorts(io.fabric8.chaosmesh.v1alpha1.CidrAndPort... items) {
    if (this.cidrAndPorts == null) return (A)this;
    for (CidrAndPort item : items) {CidrAndPortBuilder builder = new CidrAndPortBuilder(item);_visitables.get("cidrAndPorts").remove(builder); this.cidrAndPorts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCidrAndPorts(Collection<CidrAndPort> items) {
    if (this.cidrAndPorts == null) return (A)this;
    for (CidrAndPort item : items) {CidrAndPortBuilder builder = new CidrAndPortBuilder(item);_visitables.get("cidrAndPorts").remove(builder); this.cidrAndPorts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCidrAndPorts(Predicate<CidrAndPortBuilder> predicate) {
    if (cidrAndPorts == null) return (A) this;
    final Iterator<CidrAndPortBuilder> each = cidrAndPorts.iterator();
    final List visitables = _visitables.get("cidrAndPorts");
    while (each.hasNext()) {
      CidrAndPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CidrAndPort> buildCidrAndPorts() {
    return this.cidrAndPorts != null ? build(cidrAndPorts) : null;
  }
  
  public CidrAndPort buildCidrAndPort(int index) {
    return this.cidrAndPorts.get(index).build();
  }
  
  public CidrAndPort buildFirstCidrAndPort() {
    return this.cidrAndPorts.get(0).build();
  }
  
  public CidrAndPort buildLastCidrAndPort() {
    return this.cidrAndPorts.get(cidrAndPorts.size() - 1).build();
  }
  
  public CidrAndPort buildMatchingCidrAndPort(Predicate<CidrAndPortBuilder> predicate) {
      for (CidrAndPortBuilder item : cidrAndPorts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCidrAndPort(Predicate<CidrAndPortBuilder> predicate) {
      for (CidrAndPortBuilder item : cidrAndPorts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCidrAndPorts(List<CidrAndPort> cidrAndPorts) {
    if (this.cidrAndPorts != null) {
      this._visitables.get("cidrAndPorts").clear();
    }
    if (cidrAndPorts != null) {
        this.cidrAndPorts = new ArrayList();
        for (CidrAndPort item : cidrAndPorts) {
          this.addToCidrAndPorts(item);
        }
    } else {
      this.cidrAndPorts = null;
    }
    return (A) this;
  }
  
  public A withCidrAndPorts(io.fabric8.chaosmesh.v1alpha1.CidrAndPort... cidrAndPorts) {
    if (this.cidrAndPorts != null) {
        this.cidrAndPorts.clear();
        _visitables.remove("cidrAndPorts");
    }
    if (cidrAndPorts != null) {
      for (CidrAndPort item : cidrAndPorts) {
        this.addToCidrAndPorts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCidrAndPorts() {
    return this.cidrAndPorts != null && !this.cidrAndPorts.isEmpty();
  }
  
  public A addNewCidrAndPort(String cidr,Integer port) {
    return (A)addToCidrAndPorts(new CidrAndPort(cidr, port));
  }
  
  public CidrAndPortsNested<A> addNewCidrAndPort() {
    return new CidrAndPortsNested(-1, null);
  }
  
  public CidrAndPortsNested<A> addNewCidrAndPortLike(CidrAndPort item) {
    return new CidrAndPortsNested(-1, item);
  }
  
  public CidrAndPortsNested<A> setNewCidrAndPortLike(int index,CidrAndPort item) {
    return new CidrAndPortsNested(index, item);
  }
  
  public CidrAndPortsNested<A> editCidrAndPort(int index) {
    if (cidrAndPorts.size() <= index) throw new RuntimeException("Can't edit cidrAndPorts. Index exceeds size.");
    return setNewCidrAndPortLike(index, buildCidrAndPort(index));
  }
  
  public CidrAndPortsNested<A> editFirstCidrAndPort() {
    if (cidrAndPorts.size() == 0) throw new RuntimeException("Can't edit first cidrAndPorts. The list is empty.");
    return setNewCidrAndPortLike(0, buildCidrAndPort(0));
  }
  
  public CidrAndPortsNested<A> editLastCidrAndPort() {
    int index = cidrAndPorts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last cidrAndPorts. The list is empty.");
    return setNewCidrAndPortLike(index, buildCidrAndPort(index));
  }
  
  public CidrAndPortsNested<A> editMatchingCidrAndPort(Predicate<CidrAndPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<cidrAndPorts.size();i++) { 
    if (predicate.test(cidrAndPorts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching cidrAndPorts. No match found.");
    return setNewCidrAndPortLike(index, buildCidrAndPort(index));
  }
  
  public A addToCidrs(int index,String item) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    this.cidrs.add(index, item);
    return (A)this;
  }
  
  public A setToCidrs(int index,String item) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    this.cidrs.set(index, item); return (A)this;
  }
  
  public A addToCidrs(java.lang.String... items) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    for (String item : items) {this.cidrs.add(item);} return (A)this;
  }
  
  public A addAllToCidrs(Collection<String> items) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    for (String item : items) {this.cidrs.add(item);} return (A)this;
  }
  
  public A removeFromCidrs(java.lang.String... items) {
    if (this.cidrs == null) return (A)this;
    for (String item : items) { this.cidrs.remove(item);} return (A)this;
  }
  
  public A removeAllFromCidrs(Collection<String> items) {
    if (this.cidrs == null) return (A)this;
    for (String item : items) { this.cidrs.remove(item);} return (A)this;
  }
  
  public List<String> getCidrs() {
    return this.cidrs;
  }
  
  public String getCidr(int index) {
    return this.cidrs.get(index);
  }
  
  public String getFirstCidr() {
    return this.cidrs.get(0);
  }
  
  public String getLastCidr() {
    return this.cidrs.get(cidrs.size() - 1);
  }
  
  public String getMatchingCidr(Predicate<String> predicate) {
      for (String item : cidrs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCidr(Predicate<String> predicate) {
      for (String item : cidrs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCidrs(List<String> cidrs) {
    if (cidrs != null) {
        this.cidrs = new ArrayList();
        for (String item : cidrs) {
          this.addToCidrs(item);
        }
    } else {
      this.cidrs = null;
    }
    return (A) this;
  }
  
  public A withCidrs(java.lang.String... cidrs) {
    if (this.cidrs != null) {
        this.cidrs.clear();
        _visitables.remove("cidrs");
    }
    if (cidrs != null) {
      for (String item : cidrs) {
        this.addToCidrs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCidrs() {
    return this.cidrs != null && !this.cidrs.isEmpty();
  }
  
  public String getIpsetType() {
    return this.ipsetType;
  }
  
  public A withIpsetType(String ipsetType) {
    this.ipsetType = ipsetType;
    return (A) this;
  }
  
  public boolean hasIpsetType() {
    return this.ipsetType != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToSetNames(int index,String item) {
    if (this.setNames == null) {this.setNames = new ArrayList<String>();}
    this.setNames.add(index, item);
    return (A)this;
  }
  
  public A setToSetNames(int index,String item) {
    if (this.setNames == null) {this.setNames = new ArrayList<String>();}
    this.setNames.set(index, item); return (A)this;
  }
  
  public A addToSetNames(java.lang.String... items) {
    if (this.setNames == null) {this.setNames = new ArrayList<String>();}
    for (String item : items) {this.setNames.add(item);} return (A)this;
  }
  
  public A addAllToSetNames(Collection<String> items) {
    if (this.setNames == null) {this.setNames = new ArrayList<String>();}
    for (String item : items) {this.setNames.add(item);} return (A)this;
  }
  
  public A removeFromSetNames(java.lang.String... items) {
    if (this.setNames == null) return (A)this;
    for (String item : items) { this.setNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromSetNames(Collection<String> items) {
    if (this.setNames == null) return (A)this;
    for (String item : items) { this.setNames.remove(item);} return (A)this;
  }
  
  public List<String> getSetNames() {
    return this.setNames;
  }
  
  public String getSetName(int index) {
    return this.setNames.get(index);
  }
  
  public String getFirstSetName() {
    return this.setNames.get(0);
  }
  
  public String getLastSetName() {
    return this.setNames.get(setNames.size() - 1);
  }
  
  public String getMatchingSetName(Predicate<String> predicate) {
      for (String item : setNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSetName(Predicate<String> predicate) {
      for (String item : setNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSetNames(List<String> setNames) {
    if (setNames != null) {
        this.setNames = new ArrayList();
        for (String item : setNames) {
          this.addToSetNames(item);
        }
    } else {
      this.setNames = null;
    }
    return (A) this;
  }
  
  public A withSetNames(java.lang.String... setNames) {
    if (this.setNames != null) {
        this.setNames.clear();
        _visitables.remove("setNames");
    }
    if (setNames != null) {
      for (String item : setNames) {
        this.addToSetNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSetNames() {
    return this.setNames != null && !this.setNames.isEmpty();
  }
  
  public String getSource() {
    return this.source;
  }
  
  public A withSource(String source) {
    this.source = source;
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RawIPSetFluent that = (RawIPSetFluent) o;
    if (!java.util.Objects.equals(cidrAndPorts, that.cidrAndPorts)) return false;
    if (!java.util.Objects.equals(cidrs, that.cidrs)) return false;
    if (!java.util.Objects.equals(ipsetType, that.ipsetType)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(setNames, that.setNames)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cidrAndPorts,  cidrs,  ipsetType,  name,  setNames,  source,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cidrAndPorts != null && !cidrAndPorts.isEmpty()) { sb.append("cidrAndPorts:"); sb.append(cidrAndPorts + ","); }
    if (cidrs != null && !cidrs.isEmpty()) { sb.append("cidrs:"); sb.append(cidrs + ","); }
    if (ipsetType != null) { sb.append("ipsetType:"); sb.append(ipsetType + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (setNames != null && !setNames.isEmpty()) { sb.append("setNames:"); sb.append(setNames + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CidrAndPortsNested<N> extends CidrAndPortFluent<CidrAndPortsNested<N>> implements Nested<N>{
    CidrAndPortsNested(int index,CidrAndPort item) {
      this.index = index;
      this.builder = new CidrAndPortBuilder(this, item);
    }
    CidrAndPortBuilder builder;
    int index;
    
    public N and() {
      return (N) RawIPSetFluent.this.setToCidrAndPorts(index,builder.build());
    }
    
    public N endCidrAndPort() {
      return and();
    }
    
  
  }

}