package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodHttpChaosSpecFluent<A extends PodHttpChaosSpecFluent<A>> extends BaseFluent<A>{
  public PodHttpChaosSpecFluent() {
  }
  
  public PodHttpChaosSpecFluent(PodHttpChaosSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PodHttpChaosRuleBuilder> rules = new ArrayList<PodHttpChaosRuleBuilder>();
  private PodHttpChaosTLSBuilder tls;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PodHttpChaosSpec instance) {
    instance = (instance != null ? instance : new PodHttpChaosSpec());
    if (instance != null) {
          this.withRules(instance.getRules());
          this.withTls(instance.getTls());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToRules(int index,PodHttpChaosRule item) {
    if (this.rules == null) {this.rules = new ArrayList<PodHttpChaosRuleBuilder>();}
    PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);
    if (index < 0 || index >= rules.size()) {
        _visitables.get("rules").add(builder);
        rules.add(builder);
    } else {
        _visitables.get("rules").add(builder);
        rules.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRules(int index,PodHttpChaosRule item) {
    if (this.rules == null) {this.rules = new ArrayList<PodHttpChaosRuleBuilder>();}
    PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);
    if (index < 0 || index >= rules.size()) {
        _visitables.get("rules").add(builder);
        rules.add(builder);
    } else {
        _visitables.get("rules").add(builder);
        rules.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRules(io.fabric8.chaosmesh.v1alpha1.PodHttpChaosRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<PodHttpChaosRuleBuilder>();}
    for (PodHttpChaosRule item : items) {PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A addAllToRules(Collection<PodHttpChaosRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<PodHttpChaosRuleBuilder>();}
    for (PodHttpChaosRule item : items) {PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.chaosmesh.v1alpha1.PodHttpChaosRule... items) {
    if (this.rules == null) return (A)this;
    for (PodHttpChaosRule item : items) {PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<PodHttpChaosRule> items) {
    if (this.rules == null) return (A)this;
    for (PodHttpChaosRule item : items) {PodHttpChaosRuleBuilder builder = new PodHttpChaosRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRules(Predicate<PodHttpChaosRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<PodHttpChaosRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      PodHttpChaosRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PodHttpChaosRule> buildRules() {
    return this.rules != null ? build(rules) : null;
  }
  
  public PodHttpChaosRule buildRule(int index) {
    return this.rules.get(index).build();
  }
  
  public PodHttpChaosRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  
  public PodHttpChaosRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  
  public PodHttpChaosRule buildMatchingRule(Predicate<PodHttpChaosRuleBuilder> predicate) {
      for (PodHttpChaosRuleBuilder item : rules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRule(Predicate<PodHttpChaosRuleBuilder> predicate) {
      for (PodHttpChaosRuleBuilder item : rules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRules(List<PodHttpChaosRule> rules) {
    if (this.rules != null) {
      this._visitables.get("rules").clear();
    }
    if (rules != null) {
        this.rules = new ArrayList();
        for (PodHttpChaosRule item : rules) {
          this.addToRules(item);
        }
    } else {
      this.rules = null;
    }
    return (A) this;
  }
  
  public A withRules(io.fabric8.chaosmesh.v1alpha1.PodHttpChaosRule... rules) {
    if (this.rules != null) {
        this.rules.clear();
        _visitables.remove("rules");
    }
    if (rules != null) {
      for (PodHttpChaosRule item : rules) {
        this.addToRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRules() {
    return this.rules != null && !this.rules.isEmpty();
  }
  
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  
  public RulesNested<A> addNewRuleLike(PodHttpChaosRule item) {
    return new RulesNested(-1, item);
  }
  
  public RulesNested<A> setNewRuleLike(int index,PodHttpChaosRule item) {
    return new RulesNested(index, item);
  }
  
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editMatchingRule(Predicate<PodHttpChaosRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public PodHttpChaosTLS buildTls() {
    return this.tls != null ? this.tls.build() : null;
  }
  
  public A withTls(PodHttpChaosTLS tls) {
    this._visitables.remove("tls");
    if (tls != null) {
        this.tls = new PodHttpChaosTLSBuilder(tls);
        this._visitables.get("tls").add(this.tls);
    } else {
        this.tls = null;
        this._visitables.get("tls").remove(this.tls);
    }
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public A withNewTls(String caName,String certName,String keyName,String secretName,String secretNamespace) {
    return (A)withTls(new PodHttpChaosTLS(caName, certName, keyName, secretName, secretNamespace));
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(PodHttpChaosTLS item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new PodHttpChaosTLSBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(PodHttpChaosTLS item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodHttpChaosSpecFluent that = (PodHttpChaosSpecFluent) o;
    if (!java.util.Objects.equals(rules, that.rules)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(rules,  tls,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RulesNested<N> extends PodHttpChaosRuleFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,PodHttpChaosRule item) {
      this.index = index;
      this.builder = new PodHttpChaosRuleBuilder(this, item);
    }
    PodHttpChaosRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) PodHttpChaosSpecFluent.this.setToRules(index,builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends PodHttpChaosTLSFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(PodHttpChaosTLS item) {
      this.builder = new PodHttpChaosTLSBuilder(this, item);
    }
    PodHttpChaosTLSBuilder builder;
    
    public N and() {
      return (N) PodHttpChaosSpecFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}