package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PhysicalMachineSelectorFluent<A extends PhysicalMachineSelectorFluent<A>> extends BaseFluent<A>{
  public PhysicalMachineSelectorFluent() {
  }
  
  public PhysicalMachineSelectorFluent(PhysicalMachineSelector instance) {
    this.copyInstance(instance);
  }
  private List<String> address = new ArrayList<String>();
  private String mode;
  private PhysicalMachineSelectorSpecBuilder selector;
  private String value;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PhysicalMachineSelector instance) {
    instance = (instance != null ? instance : new PhysicalMachineSelector());
    if (instance != null) {
          this.withAddress(instance.getAddress());
          this.withMode(instance.getMode());
          this.withSelector(instance.getSelector());
          this.withValue(instance.getValue());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.add(index, item);
    return (A)this;
  }
  
  public A setToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.set(index, item); return (A)this;
  }
  
  public A addToAddress(java.lang.String... items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A addAllToAddress(Collection<String> items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A removeFromAddress(java.lang.String... items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddress(Collection<String> items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public List<String> getAddress() {
    return this.address;
  }
  
  public String getAddress(int index) {
    return this.address.get(index);
  }
  
  public String getFirstAddress() {
    return this.address.get(0);
  }
  
  public String getLastAddress() {
    return this.address.get(address.size() - 1);
  }
  
  public String getMatchingAddress(Predicate<String> predicate) {
      for (String item : address) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<String> predicate) {
      for (String item : address) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddress(List<String> address) {
    if (address != null) {
        this.address = new ArrayList();
        for (String item : address) {
          this.addToAddress(item);
        }
    } else {
      this.address = null;
    }
    return (A) this;
  }
  
  public A withAddress(java.lang.String... address) {
    if (this.address != null) {
        this.address.clear();
        _visitables.remove("address");
    }
    if (address != null) {
      for (String item : address) {
        this.addToAddress(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddress() {
    return this.address != null && !this.address.isEmpty();
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public PhysicalMachineSelectorSpec buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(PhysicalMachineSelectorSpec selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new PhysicalMachineSelectorSpecBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PhysicalMachineSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PhysicalMachineSelectorFluent that = (PhysicalMachineSelectorFluent) o;
    if (!java.util.Objects.equals(address, that.address)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(address,  mode,  selector,  value,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null && !address.isEmpty()) { sb.append("address:"); sb.append(address + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends PhysicalMachineSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PhysicalMachineSelectorSpec item) {
      this.builder = new PhysicalMachineSelectorSpecBuilder(this, item);
    }
    PhysicalMachineSelectorSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineSelectorFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}