package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Long;
import java.lang.SuppressWarnings;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PhysicalMachineChaosSpecFluent<A extends PhysicalMachineChaosSpecFluent<A>> extends BaseFluent<A>{
  public PhysicalMachineChaosSpecFluent() {
  }
  
  public PhysicalMachineChaosSpecFluent(PhysicalMachineChaosSpec instance) {
    this.copyInstance(instance);
  }
  private String action;
  private List<String> address = new ArrayList<String>();
  private ClockSpecBuilder clock;
  private DiskFillSpecBuilder diskFill;
  private DiskPayloadSpecBuilder diskReadPayload;
  private DiskPayloadSpecBuilder diskWritePayload;
  private String duration;
  private FileAppendSpecBuilder fileAppend;
  private FileCreateSpecBuilder fileCreate;
  private FileDeleteSpecBuilder fileDelete;
  private FileModifyPrivilegeSpecBuilder fileModify;
  private FileRenameSpecBuilder fileRename;
  private FileReplaceSpecBuilder fileReplace;
  private HTTPAbortSpecBuilder httpAbort;
  private HTTPConfigSpecBuilder httpConfig;
  private HTTPDelaySpecBuilder httpDelay;
  private HTTPRequestSpecBuilder httpRequest;
  private JVMExceptionSpecBuilder jvmException;
  private JVMGCSpecBuilder jvmGc;
  private JVMLatencySpecBuilder jvmLatency;
  private PMJVMMySQLSpecBuilder jvmMysql;
  private JVMReturnSpecBuilder jvmReturn;
  private JVMRuleDataSpecBuilder jvmRuleData;
  private JVMStressSpecBuilder jvmStress;
  private KafkaFillSpecBuilder kafkaFill;
  private KafkaFloodSpecBuilder kafkaFlood;
  private KafkaIOSpecBuilder kafkaIo;
  private String mode;
  private NetworkBandwidthSpecBuilder networkBandwidth;
  private NetworkCorruptSpecBuilder networkCorrupt;
  private NetworkDelaySpecBuilder networkDelay;
  private NetworkDNSSpecBuilder networkDns;
  private NetworkDownSpecBuilder networkDown;
  private NetworkDuplicateSpecBuilder networkDuplicate;
  private NetworkFloodSpecBuilder networkFlood;
  private NetworkLossSpecBuilder networkLoss;
  private NetworkPartitionSpecBuilder networkPartition;
  private ProcessSpecBuilder process;
  private RedisCacheLimitSpecBuilder redisCacheLimit;
  private RedisExpirationSpecBuilder redisExpiration;
  private RedisPenetrationSpecBuilder redisPenetration;
  private RedisSentinelRestartSpecBuilder redisRestart;
  private RedisSentinelStopSpecBuilder redisStop;
  private String remoteCluster;
  private PhysicalMachineSelectorSpecBuilder selector;
  private StressCPUSpecBuilder stressCpu;
  private StressMemorySpecBuilder stressMem;
  private UserDefinedSpecBuilder userDefined;
  private String value;
  private VMSpecBuilder vm;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PhysicalMachineChaosSpec instance) {
    instance = (instance != null ? instance : new PhysicalMachineChaosSpec());
    if (instance != null) {
          this.withAction(instance.getAction());
          this.withAddress(instance.getAddress());
          this.withClock(instance.getClock());
          this.withDiskFill(instance.getDiskFill());
          this.withDiskReadPayload(instance.getDiskReadPayload());
          this.withDiskWritePayload(instance.getDiskWritePayload());
          this.withDuration(instance.getDuration());
          this.withFileAppend(instance.getFileAppend());
          this.withFileCreate(instance.getFileCreate());
          this.withFileDelete(instance.getFileDelete());
          this.withFileModify(instance.getFileModify());
          this.withFileRename(instance.getFileRename());
          this.withFileReplace(instance.getFileReplace());
          this.withHttpAbort(instance.getHttpAbort());
          this.withHttpConfig(instance.getHttpConfig());
          this.withHttpDelay(instance.getHttpDelay());
          this.withHttpRequest(instance.getHttpRequest());
          this.withJvmException(instance.getJvmException());
          this.withJvmGc(instance.getJvmGc());
          this.withJvmLatency(instance.getJvmLatency());
          this.withJvmMysql(instance.getJvmMysql());
          this.withJvmReturn(instance.getJvmReturn());
          this.withJvmRuleData(instance.getJvmRuleData());
          this.withJvmStress(instance.getJvmStress());
          this.withKafkaFill(instance.getKafkaFill());
          this.withKafkaFlood(instance.getKafkaFlood());
          this.withKafkaIo(instance.getKafkaIo());
          this.withMode(instance.getMode());
          this.withNetworkBandwidth(instance.getNetworkBandwidth());
          this.withNetworkCorrupt(instance.getNetworkCorrupt());
          this.withNetworkDelay(instance.getNetworkDelay());
          this.withNetworkDns(instance.getNetworkDns());
          this.withNetworkDown(instance.getNetworkDown());
          this.withNetworkDuplicate(instance.getNetworkDuplicate());
          this.withNetworkFlood(instance.getNetworkFlood());
          this.withNetworkLoss(instance.getNetworkLoss());
          this.withNetworkPartition(instance.getNetworkPartition());
          this.withProcess(instance.getProcess());
          this.withRedisCacheLimit(instance.getRedisCacheLimit());
          this.withRedisExpiration(instance.getRedisExpiration());
          this.withRedisPenetration(instance.getRedisPenetration());
          this.withRedisRestart(instance.getRedisRestart());
          this.withRedisStop(instance.getRedisStop());
          this.withRemoteCluster(instance.getRemoteCluster());
          this.withSelector(instance.getSelector());
          this.withStressCpu(instance.getStressCpu());
          this.withStressMem(instance.getStressMem());
          this.withUserDefined(instance.getUserDefined());
          this.withValue(instance.getValue());
          this.withVm(instance.getVm());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action = action;
    return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public A addToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.add(index, item);
    return (A)this;
  }
  
  public A setToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.set(index, item); return (A)this;
  }
  
  public A addToAddress(java.lang.String... items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A addAllToAddress(Collection<String> items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  
  public A removeFromAddress(java.lang.String... items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddress(Collection<String> items) {
    if (this.address == null) return (A)this;
    for (String item : items) { this.address.remove(item);} return (A)this;
  }
  
  public List<String> getAddress() {
    return this.address;
  }
  
  public String getAddress(int index) {
    return this.address.get(index);
  }
  
  public String getFirstAddress() {
    return this.address.get(0);
  }
  
  public String getLastAddress() {
    return this.address.get(address.size() - 1);
  }
  
  public String getMatchingAddress(Predicate<String> predicate) {
      for (String item : address) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<String> predicate) {
      for (String item : address) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddress(List<String> address) {
    if (address != null) {
        this.address = new ArrayList();
        for (String item : address) {
          this.addToAddress(item);
        }
    } else {
      this.address = null;
    }
    return (A) this;
  }
  
  public A withAddress(java.lang.String... address) {
    if (this.address != null) {
        this.address.clear();
        _visitables.remove("address");
    }
    if (address != null) {
      for (String item : address) {
        this.addToAddress(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddress() {
    return this.address != null && !this.address.isEmpty();
  }
  
  public ClockSpec buildClock() {
    return this.clock != null ? this.clock.build() : null;
  }
  
  public A withClock(ClockSpec clock) {
    this._visitables.remove("clock");
    if (clock != null) {
        this.clock = new ClockSpecBuilder(clock);
        this._visitables.get("clock").add(this.clock);
    } else {
        this.clock = null;
        this._visitables.get("clock").remove(this.clock);
    }
    return (A) this;
  }
  
  public boolean hasClock() {
    return this.clock != null;
  }
  
  public A withNewClock(String clockIdsSlice,Integer pid,String timeOffset) {
    return (A)withClock(new ClockSpec(clockIdsSlice, pid, timeOffset));
  }
  
  public ClockNested<A> withNewClock() {
    return new ClockNested(null);
  }
  
  public ClockNested<A> withNewClockLike(ClockSpec item) {
    return new ClockNested(item);
  }
  
  public ClockNested<A> editClock() {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(null));
  }
  
  public ClockNested<A> editOrNewClock() {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(new ClockSpecBuilder().build()));
  }
  
  public ClockNested<A> editOrNewClockLike(ClockSpec item) {
    return withNewClockLike(java.util.Optional.ofNullable(buildClock()).orElse(item));
  }
  
  public DiskFillSpec buildDiskFill() {
    return this.diskFill != null ? this.diskFill.build() : null;
  }
  
  public A withDiskFill(DiskFillSpec diskFill) {
    this._visitables.remove("diskFill");
    if (diskFill != null) {
        this.diskFill = new DiskFillSpecBuilder(diskFill);
        this._visitables.get("diskFill").add(this.diskFill);
    } else {
        this.diskFill = null;
        this._visitables.get("diskFill").remove(this.diskFill);
    }
    return (A) this;
  }
  
  public boolean hasDiskFill() {
    return this.diskFill != null;
  }
  
  public A withNewDiskFill(Boolean fillByFallocate,String path,String size) {
    return (A)withDiskFill(new DiskFillSpec(fillByFallocate, path, size));
  }
  
  public DiskFillNested<A> withNewDiskFill() {
    return new DiskFillNested(null);
  }
  
  public DiskFillNested<A> withNewDiskFillLike(DiskFillSpec item) {
    return new DiskFillNested(item);
  }
  
  public DiskFillNested<A> editDiskFill() {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(null));
  }
  
  public DiskFillNested<A> editOrNewDiskFill() {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(new DiskFillSpecBuilder().build()));
  }
  
  public DiskFillNested<A> editOrNewDiskFillLike(DiskFillSpec item) {
    return withNewDiskFillLike(java.util.Optional.ofNullable(buildDiskFill()).orElse(item));
  }
  
  public DiskPayloadSpec buildDiskReadPayload() {
    return this.diskReadPayload != null ? this.diskReadPayload.build() : null;
  }
  
  public A withDiskReadPayload(DiskPayloadSpec diskReadPayload) {
    this._visitables.remove("diskReadPayload");
    if (diskReadPayload != null) {
        this.diskReadPayload = new DiskPayloadSpecBuilder(diskReadPayload);
        this._visitables.get("diskReadPayload").add(this.diskReadPayload);
    } else {
        this.diskReadPayload = null;
        this._visitables.get("diskReadPayload").remove(this.diskReadPayload);
    }
    return (A) this;
  }
  
  public boolean hasDiskReadPayload() {
    return this.diskReadPayload != null;
  }
  
  public A withNewDiskReadPayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskReadPayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  
  public DiskReadPayloadNested<A> withNewDiskReadPayload() {
    return new DiskReadPayloadNested(null);
  }
  
  public DiskReadPayloadNested<A> withNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return new DiskReadPayloadNested(item);
  }
  
  public DiskReadPayloadNested<A> editDiskReadPayload() {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(null));
  }
  
  public DiskReadPayloadNested<A> editOrNewDiskReadPayload() {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(new DiskPayloadSpecBuilder().build()));
  }
  
  public DiskReadPayloadNested<A> editOrNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return withNewDiskReadPayloadLike(java.util.Optional.ofNullable(buildDiskReadPayload()).orElse(item));
  }
  
  public DiskPayloadSpec buildDiskWritePayload() {
    return this.diskWritePayload != null ? this.diskWritePayload.build() : null;
  }
  
  public A withDiskWritePayload(DiskPayloadSpec diskWritePayload) {
    this._visitables.remove("diskWritePayload");
    if (diskWritePayload != null) {
        this.diskWritePayload = new DiskPayloadSpecBuilder(diskWritePayload);
        this._visitables.get("diskWritePayload").add(this.diskWritePayload);
    } else {
        this.diskWritePayload = null;
        this._visitables.get("diskWritePayload").remove(this.diskWritePayload);
    }
    return (A) this;
  }
  
  public boolean hasDiskWritePayload() {
    return this.diskWritePayload != null;
  }
  
  public A withNewDiskWritePayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskWritePayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  
  public DiskWritePayloadNested<A> withNewDiskWritePayload() {
    return new DiskWritePayloadNested(null);
  }
  
  public DiskWritePayloadNested<A> withNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return new DiskWritePayloadNested(item);
  }
  
  public DiskWritePayloadNested<A> editDiskWritePayload() {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(null));
  }
  
  public DiskWritePayloadNested<A> editOrNewDiskWritePayload() {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(new DiskPayloadSpecBuilder().build()));
  }
  
  public DiskWritePayloadNested<A> editOrNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return withNewDiskWritePayloadLike(java.util.Optional.ofNullable(buildDiskWritePayload()).orElse(item));
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public FileAppendSpec buildFileAppend() {
    return this.fileAppend != null ? this.fileAppend.build() : null;
  }
  
  public A withFileAppend(FileAppendSpec fileAppend) {
    this._visitables.remove("fileAppend");
    if (fileAppend != null) {
        this.fileAppend = new FileAppendSpecBuilder(fileAppend);
        this._visitables.get("fileAppend").add(this.fileAppend);
    } else {
        this.fileAppend = null;
        this._visitables.get("fileAppend").remove(this.fileAppend);
    }
    return (A) this;
  }
  
  public boolean hasFileAppend() {
    return this.fileAppend != null;
  }
  
  public A withNewFileAppend(Integer count,String data,String fileName) {
    return (A)withFileAppend(new FileAppendSpec(count, data, fileName));
  }
  
  public FileAppendNested<A> withNewFileAppend() {
    return new FileAppendNested(null);
  }
  
  public FileAppendNested<A> withNewFileAppendLike(FileAppendSpec item) {
    return new FileAppendNested(item);
  }
  
  public FileAppendNested<A> editFileAppend() {
    return withNewFileAppendLike(java.util.Optional.ofNullable(buildFileAppend()).orElse(null));
  }
  
  public FileAppendNested<A> editOrNewFileAppend() {
    return withNewFileAppendLike(java.util.Optional.ofNullable(buildFileAppend()).orElse(new FileAppendSpecBuilder().build()));
  }
  
  public FileAppendNested<A> editOrNewFileAppendLike(FileAppendSpec item) {
    return withNewFileAppendLike(java.util.Optional.ofNullable(buildFileAppend()).orElse(item));
  }
  
  public FileCreateSpec buildFileCreate() {
    return this.fileCreate != null ? this.fileCreate.build() : null;
  }
  
  public A withFileCreate(FileCreateSpec fileCreate) {
    this._visitables.remove("fileCreate");
    if (fileCreate != null) {
        this.fileCreate = new FileCreateSpecBuilder(fileCreate);
        this._visitables.get("fileCreate").add(this.fileCreate);
    } else {
        this.fileCreate = null;
        this._visitables.get("fileCreate").remove(this.fileCreate);
    }
    return (A) this;
  }
  
  public boolean hasFileCreate() {
    return this.fileCreate != null;
  }
  
  public A withNewFileCreate(String dirName,String fileName) {
    return (A)withFileCreate(new FileCreateSpec(dirName, fileName));
  }
  
  public FileCreateNested<A> withNewFileCreate() {
    return new FileCreateNested(null);
  }
  
  public FileCreateNested<A> withNewFileCreateLike(FileCreateSpec item) {
    return new FileCreateNested(item);
  }
  
  public FileCreateNested<A> editFileCreate() {
    return withNewFileCreateLike(java.util.Optional.ofNullable(buildFileCreate()).orElse(null));
  }
  
  public FileCreateNested<A> editOrNewFileCreate() {
    return withNewFileCreateLike(java.util.Optional.ofNullable(buildFileCreate()).orElse(new FileCreateSpecBuilder().build()));
  }
  
  public FileCreateNested<A> editOrNewFileCreateLike(FileCreateSpec item) {
    return withNewFileCreateLike(java.util.Optional.ofNullable(buildFileCreate()).orElse(item));
  }
  
  public FileDeleteSpec buildFileDelete() {
    return this.fileDelete != null ? this.fileDelete.build() : null;
  }
  
  public A withFileDelete(FileDeleteSpec fileDelete) {
    this._visitables.remove("fileDelete");
    if (fileDelete != null) {
        this.fileDelete = new FileDeleteSpecBuilder(fileDelete);
        this._visitables.get("fileDelete").add(this.fileDelete);
    } else {
        this.fileDelete = null;
        this._visitables.get("fileDelete").remove(this.fileDelete);
    }
    return (A) this;
  }
  
  public boolean hasFileDelete() {
    return this.fileDelete != null;
  }
  
  public A withNewFileDelete(String dirName,String fileName) {
    return (A)withFileDelete(new FileDeleteSpec(dirName, fileName));
  }
  
  public FileDeleteNested<A> withNewFileDelete() {
    return new FileDeleteNested(null);
  }
  
  public FileDeleteNested<A> withNewFileDeleteLike(FileDeleteSpec item) {
    return new FileDeleteNested(item);
  }
  
  public FileDeleteNested<A> editFileDelete() {
    return withNewFileDeleteLike(java.util.Optional.ofNullable(buildFileDelete()).orElse(null));
  }
  
  public FileDeleteNested<A> editOrNewFileDelete() {
    return withNewFileDeleteLike(java.util.Optional.ofNullable(buildFileDelete()).orElse(new FileDeleteSpecBuilder().build()));
  }
  
  public FileDeleteNested<A> editOrNewFileDeleteLike(FileDeleteSpec item) {
    return withNewFileDeleteLike(java.util.Optional.ofNullable(buildFileDelete()).orElse(item));
  }
  
  public FileModifyPrivilegeSpec buildFileModify() {
    return this.fileModify != null ? this.fileModify.build() : null;
  }
  
  public A withFileModify(FileModifyPrivilegeSpec fileModify) {
    this._visitables.remove("fileModify");
    if (fileModify != null) {
        this.fileModify = new FileModifyPrivilegeSpecBuilder(fileModify);
        this._visitables.get("fileModify").add(this.fileModify);
    } else {
        this.fileModify = null;
        this._visitables.get("fileModify").remove(this.fileModify);
    }
    return (A) this;
  }
  
  public boolean hasFileModify() {
    return this.fileModify != null;
  }
  
  public A withNewFileModify(String fileName,Long privilege) {
    return (A)withFileModify(new FileModifyPrivilegeSpec(fileName, privilege));
  }
  
  public FileModifyNested<A> withNewFileModify() {
    return new FileModifyNested(null);
  }
  
  public FileModifyNested<A> withNewFileModifyLike(FileModifyPrivilegeSpec item) {
    return new FileModifyNested(item);
  }
  
  public FileModifyNested<A> editFileModify() {
    return withNewFileModifyLike(java.util.Optional.ofNullable(buildFileModify()).orElse(null));
  }
  
  public FileModifyNested<A> editOrNewFileModify() {
    return withNewFileModifyLike(java.util.Optional.ofNullable(buildFileModify()).orElse(new FileModifyPrivilegeSpecBuilder().build()));
  }
  
  public FileModifyNested<A> editOrNewFileModifyLike(FileModifyPrivilegeSpec item) {
    return withNewFileModifyLike(java.util.Optional.ofNullable(buildFileModify()).orElse(item));
  }
  
  public FileRenameSpec buildFileRename() {
    return this.fileRename != null ? this.fileRename.build() : null;
  }
  
  public A withFileRename(FileRenameSpec fileRename) {
    this._visitables.remove("fileRename");
    if (fileRename != null) {
        this.fileRename = new FileRenameSpecBuilder(fileRename);
        this._visitables.get("fileRename").add(this.fileRename);
    } else {
        this.fileRename = null;
        this._visitables.get("fileRename").remove(this.fileRename);
    }
    return (A) this;
  }
  
  public boolean hasFileRename() {
    return this.fileRename != null;
  }
  
  public A withNewFileRename(String destFile,String sourceFile) {
    return (A)withFileRename(new FileRenameSpec(destFile, sourceFile));
  }
  
  public FileRenameNested<A> withNewFileRename() {
    return new FileRenameNested(null);
  }
  
  public FileRenameNested<A> withNewFileRenameLike(FileRenameSpec item) {
    return new FileRenameNested(item);
  }
  
  public FileRenameNested<A> editFileRename() {
    return withNewFileRenameLike(java.util.Optional.ofNullable(buildFileRename()).orElse(null));
  }
  
  public FileRenameNested<A> editOrNewFileRename() {
    return withNewFileRenameLike(java.util.Optional.ofNullable(buildFileRename()).orElse(new FileRenameSpecBuilder().build()));
  }
  
  public FileRenameNested<A> editOrNewFileRenameLike(FileRenameSpec item) {
    return withNewFileRenameLike(java.util.Optional.ofNullable(buildFileRename()).orElse(item));
  }
  
  public FileReplaceSpec buildFileReplace() {
    return this.fileReplace != null ? this.fileReplace.build() : null;
  }
  
  public A withFileReplace(FileReplaceSpec fileReplace) {
    this._visitables.remove("fileReplace");
    if (fileReplace != null) {
        this.fileReplace = new FileReplaceSpecBuilder(fileReplace);
        this._visitables.get("fileReplace").add(this.fileReplace);
    } else {
        this.fileReplace = null;
        this._visitables.get("fileReplace").remove(this.fileReplace);
    }
    return (A) this;
  }
  
  public boolean hasFileReplace() {
    return this.fileReplace != null;
  }
  
  public A withNewFileReplace(String destString,String fileName,Integer line,String originString) {
    return (A)withFileReplace(new FileReplaceSpec(destString, fileName, line, originString));
  }
  
  public FileReplaceNested<A> withNewFileReplace() {
    return new FileReplaceNested(null);
  }
  
  public FileReplaceNested<A> withNewFileReplaceLike(FileReplaceSpec item) {
    return new FileReplaceNested(item);
  }
  
  public FileReplaceNested<A> editFileReplace() {
    return withNewFileReplaceLike(java.util.Optional.ofNullable(buildFileReplace()).orElse(null));
  }
  
  public FileReplaceNested<A> editOrNewFileReplace() {
    return withNewFileReplaceLike(java.util.Optional.ofNullable(buildFileReplace()).orElse(new FileReplaceSpecBuilder().build()));
  }
  
  public FileReplaceNested<A> editOrNewFileReplaceLike(FileReplaceSpec item) {
    return withNewFileReplaceLike(java.util.Optional.ofNullable(buildFileReplace()).orElse(item));
  }
  
  public HTTPAbortSpec buildHttpAbort() {
    return this.httpAbort != null ? this.httpAbort.build() : null;
  }
  
  public A withHttpAbort(HTTPAbortSpec httpAbort) {
    this._visitables.remove("httpAbort");
    if (httpAbort != null) {
        this.httpAbort = new HTTPAbortSpecBuilder(httpAbort);
        this._visitables.get("httpAbort").add(this.httpAbort);
    } else {
        this.httpAbort = null;
        this._visitables.get("httpAbort").remove(this.httpAbort);
    }
    return (A) this;
  }
  
  public boolean hasHttpAbort() {
    return this.httpAbort != null;
  }
  
  public HttpAbortNested<A> withNewHttpAbort() {
    return new HttpAbortNested(null);
  }
  
  public HttpAbortNested<A> withNewHttpAbortLike(HTTPAbortSpec item) {
    return new HttpAbortNested(item);
  }
  
  public HttpAbortNested<A> editHttpAbort() {
    return withNewHttpAbortLike(java.util.Optional.ofNullable(buildHttpAbort()).orElse(null));
  }
  
  public HttpAbortNested<A> editOrNewHttpAbort() {
    return withNewHttpAbortLike(java.util.Optional.ofNullable(buildHttpAbort()).orElse(new HTTPAbortSpecBuilder().build()));
  }
  
  public HttpAbortNested<A> editOrNewHttpAbortLike(HTTPAbortSpec item) {
    return withNewHttpAbortLike(java.util.Optional.ofNullable(buildHttpAbort()).orElse(item));
  }
  
  public HTTPConfigSpec buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfigSpec httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigSpecBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public A withNewHttpConfig(String filePath) {
    return (A)withHttpConfig(new HTTPConfigSpec(filePath));
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfigSpec item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigSpecBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfigSpec item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public HTTPDelaySpec buildHttpDelay() {
    return this.httpDelay != null ? this.httpDelay.build() : null;
  }
  
  public A withHttpDelay(HTTPDelaySpec httpDelay) {
    this._visitables.remove("httpDelay");
    if (httpDelay != null) {
        this.httpDelay = new HTTPDelaySpecBuilder(httpDelay);
        this._visitables.get("httpDelay").add(this.httpDelay);
    } else {
        this.httpDelay = null;
        this._visitables.get("httpDelay").remove(this.httpDelay);
    }
    return (A) this;
  }
  
  public boolean hasHttpDelay() {
    return this.httpDelay != null;
  }
  
  public HttpDelayNested<A> withNewHttpDelay() {
    return new HttpDelayNested(null);
  }
  
  public HttpDelayNested<A> withNewHttpDelayLike(HTTPDelaySpec item) {
    return new HttpDelayNested(item);
  }
  
  public HttpDelayNested<A> editHttpDelay() {
    return withNewHttpDelayLike(java.util.Optional.ofNullable(buildHttpDelay()).orElse(null));
  }
  
  public HttpDelayNested<A> editOrNewHttpDelay() {
    return withNewHttpDelayLike(java.util.Optional.ofNullable(buildHttpDelay()).orElse(new HTTPDelaySpecBuilder().build()));
  }
  
  public HttpDelayNested<A> editOrNewHttpDelayLike(HTTPDelaySpec item) {
    return withNewHttpDelayLike(java.util.Optional.ofNullable(buildHttpDelay()).orElse(item));
  }
  
  public HTTPRequestSpec buildHttpRequest() {
    return this.httpRequest != null ? this.httpRequest.build() : null;
  }
  
  public A withHttpRequest(HTTPRequestSpec httpRequest) {
    this._visitables.remove("httpRequest");
    if (httpRequest != null) {
        this.httpRequest = new HTTPRequestSpecBuilder(httpRequest);
        this._visitables.get("httpRequest").add(this.httpRequest);
    } else {
        this.httpRequest = null;
        this._visitables.get("httpRequest").remove(this.httpRequest);
    }
    return (A) this;
  }
  
  public boolean hasHttpRequest() {
    return this.httpRequest != null;
  }
  
  public A withNewHttpRequest(Integer count,Boolean enableConnPool,String url) {
    return (A)withHttpRequest(new HTTPRequestSpec(count, enableConnPool, url));
  }
  
  public HttpRequestNested<A> withNewHttpRequest() {
    return new HttpRequestNested(null);
  }
  
  public HttpRequestNested<A> withNewHttpRequestLike(HTTPRequestSpec item) {
    return new HttpRequestNested(item);
  }
  
  public HttpRequestNested<A> editHttpRequest() {
    return withNewHttpRequestLike(java.util.Optional.ofNullable(buildHttpRequest()).orElse(null));
  }
  
  public HttpRequestNested<A> editOrNewHttpRequest() {
    return withNewHttpRequestLike(java.util.Optional.ofNullable(buildHttpRequest()).orElse(new HTTPRequestSpecBuilder().build()));
  }
  
  public HttpRequestNested<A> editOrNewHttpRequestLike(HTTPRequestSpec item) {
    return withNewHttpRequestLike(java.util.Optional.ofNullable(buildHttpRequest()).orElse(item));
  }
  
  public JVMExceptionSpec buildJvmException() {
    return this.jvmException != null ? this.jvmException.build() : null;
  }
  
  public A withJvmException(JVMExceptionSpec jvmException) {
    this._visitables.remove("jvmException");
    if (jvmException != null) {
        this.jvmException = new JVMExceptionSpecBuilder(jvmException);
        this._visitables.get("jvmException").add(this.jvmException);
    } else {
        this.jvmException = null;
        this._visitables.get("jvmException").remove(this.jvmException);
    }
    return (A) this;
  }
  
  public boolean hasJvmException() {
    return this.jvmException != null;
  }
  
  public A withNewJvmException(String className,String exception,String method,Integer pid,Integer port) {
    return (A)withJvmException(new JVMExceptionSpec(className, exception, method, pid, port));
  }
  
  public JvmExceptionNested<A> withNewJvmException() {
    return new JvmExceptionNested(null);
  }
  
  public JvmExceptionNested<A> withNewJvmExceptionLike(JVMExceptionSpec item) {
    return new JvmExceptionNested(item);
  }
  
  public JvmExceptionNested<A> editJvmException() {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(null));
  }
  
  public JvmExceptionNested<A> editOrNewJvmException() {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(new JVMExceptionSpecBuilder().build()));
  }
  
  public JvmExceptionNested<A> editOrNewJvmExceptionLike(JVMExceptionSpec item) {
    return withNewJvmExceptionLike(java.util.Optional.ofNullable(buildJvmException()).orElse(item));
  }
  
  public JVMGCSpec buildJvmGc() {
    return this.jvmGc != null ? this.jvmGc.build() : null;
  }
  
  public A withJvmGc(JVMGCSpec jvmGc) {
    this._visitables.remove("jvmGc");
    if (jvmGc != null) {
        this.jvmGc = new JVMGCSpecBuilder(jvmGc);
        this._visitables.get("jvmGc").add(this.jvmGc);
    } else {
        this.jvmGc = null;
        this._visitables.get("jvmGc").remove(this.jvmGc);
    }
    return (A) this;
  }
  
  public boolean hasJvmGc() {
    return this.jvmGc != null;
  }
  
  public A withNewJvmGc(Integer pid,Integer port) {
    return (A)withJvmGc(new JVMGCSpec(pid, port));
  }
  
  public JvmGcNested<A> withNewJvmGc() {
    return new JvmGcNested(null);
  }
  
  public JvmGcNested<A> withNewJvmGcLike(JVMGCSpec item) {
    return new JvmGcNested(item);
  }
  
  public JvmGcNested<A> editJvmGc() {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(null));
  }
  
  public JvmGcNested<A> editOrNewJvmGc() {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(new JVMGCSpecBuilder().build()));
  }
  
  public JvmGcNested<A> editOrNewJvmGcLike(JVMGCSpec item) {
    return withNewJvmGcLike(java.util.Optional.ofNullable(buildJvmGc()).orElse(item));
  }
  
  public JVMLatencySpec buildJvmLatency() {
    return this.jvmLatency != null ? this.jvmLatency.build() : null;
  }
  
  public A withJvmLatency(JVMLatencySpec jvmLatency) {
    this._visitables.remove("jvmLatency");
    if (jvmLatency != null) {
        this.jvmLatency = new JVMLatencySpecBuilder(jvmLatency);
        this._visitables.get("jvmLatency").add(this.jvmLatency);
    } else {
        this.jvmLatency = null;
        this._visitables.get("jvmLatency").remove(this.jvmLatency);
    }
    return (A) this;
  }
  
  public boolean hasJvmLatency() {
    return this.jvmLatency != null;
  }
  
  public A withNewJvmLatency(String className,Integer latency,String method,Integer pid,Integer port) {
    return (A)withJvmLatency(new JVMLatencySpec(className, latency, method, pid, port));
  }
  
  public JvmLatencyNested<A> withNewJvmLatency() {
    return new JvmLatencyNested(null);
  }
  
  public JvmLatencyNested<A> withNewJvmLatencyLike(JVMLatencySpec item) {
    return new JvmLatencyNested(item);
  }
  
  public JvmLatencyNested<A> editJvmLatency() {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(null));
  }
  
  public JvmLatencyNested<A> editOrNewJvmLatency() {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(new JVMLatencySpecBuilder().build()));
  }
  
  public JvmLatencyNested<A> editOrNewJvmLatencyLike(JVMLatencySpec item) {
    return withNewJvmLatencyLike(java.util.Optional.ofNullable(buildJvmLatency()).orElse(item));
  }
  
  public PMJVMMySQLSpec buildJvmMysql() {
    return this.jvmMysql != null ? this.jvmMysql.build() : null;
  }
  
  public A withJvmMysql(PMJVMMySQLSpec jvmMysql) {
    this._visitables.remove("jvmMysql");
    if (jvmMysql != null) {
        this.jvmMysql = new PMJVMMySQLSpecBuilder(jvmMysql);
        this._visitables.get("jvmMysql").add(this.jvmMysql);
    } else {
        this.jvmMysql = null;
        this._visitables.get("jvmMysql").remove(this.jvmMysql);
    }
    return (A) this;
  }
  
  public boolean hasJvmMysql() {
    return this.jvmMysql != null;
  }
  
  public JvmMysqlNested<A> withNewJvmMysql() {
    return new JvmMysqlNested(null);
  }
  
  public JvmMysqlNested<A> withNewJvmMysqlLike(PMJVMMySQLSpec item) {
    return new JvmMysqlNested(item);
  }
  
  public JvmMysqlNested<A> editJvmMysql() {
    return withNewJvmMysqlLike(java.util.Optional.ofNullable(buildJvmMysql()).orElse(null));
  }
  
  public JvmMysqlNested<A> editOrNewJvmMysql() {
    return withNewJvmMysqlLike(java.util.Optional.ofNullable(buildJvmMysql()).orElse(new PMJVMMySQLSpecBuilder().build()));
  }
  
  public JvmMysqlNested<A> editOrNewJvmMysqlLike(PMJVMMySQLSpec item) {
    return withNewJvmMysqlLike(java.util.Optional.ofNullable(buildJvmMysql()).orElse(item));
  }
  
  public JVMReturnSpec buildJvmReturn() {
    return this.jvmReturn != null ? this.jvmReturn.build() : null;
  }
  
  public A withJvmReturn(JVMReturnSpec jvmReturn) {
    this._visitables.remove("jvmReturn");
    if (jvmReturn != null) {
        this.jvmReturn = new JVMReturnSpecBuilder(jvmReturn);
        this._visitables.get("jvmReturn").add(this.jvmReturn);
    } else {
        this.jvmReturn = null;
        this._visitables.get("jvmReturn").remove(this.jvmReturn);
    }
    return (A) this;
  }
  
  public boolean hasJvmReturn() {
    return this.jvmReturn != null;
  }
  
  public A withNewJvmReturn(String className,String method,Integer pid,Integer port,String value) {
    return (A)withJvmReturn(new JVMReturnSpec(className, method, pid, port, value));
  }
  
  public JvmReturnNested<A> withNewJvmReturn() {
    return new JvmReturnNested(null);
  }
  
  public JvmReturnNested<A> withNewJvmReturnLike(JVMReturnSpec item) {
    return new JvmReturnNested(item);
  }
  
  public JvmReturnNested<A> editJvmReturn() {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(null));
  }
  
  public JvmReturnNested<A> editOrNewJvmReturn() {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(new JVMReturnSpecBuilder().build()));
  }
  
  public JvmReturnNested<A> editOrNewJvmReturnLike(JVMReturnSpec item) {
    return withNewJvmReturnLike(java.util.Optional.ofNullable(buildJvmReturn()).orElse(item));
  }
  
  public JVMRuleDataSpec buildJvmRuleData() {
    return this.jvmRuleData != null ? this.jvmRuleData.build() : null;
  }
  
  public A withJvmRuleData(JVMRuleDataSpec jvmRuleData) {
    this._visitables.remove("jvmRuleData");
    if (jvmRuleData != null) {
        this.jvmRuleData = new JVMRuleDataSpecBuilder(jvmRuleData);
        this._visitables.get("jvmRuleData").add(this.jvmRuleData);
    } else {
        this.jvmRuleData = null;
        this._visitables.get("jvmRuleData").remove(this.jvmRuleData);
    }
    return (A) this;
  }
  
  public boolean hasJvmRuleData() {
    return this.jvmRuleData != null;
  }
  
  public A withNewJvmRuleData(Integer pid,Integer port,String ruleData) {
    return (A)withJvmRuleData(new JVMRuleDataSpec(pid, port, ruleData));
  }
  
  public JvmRuleDataNested<A> withNewJvmRuleData() {
    return new JvmRuleDataNested(null);
  }
  
  public JvmRuleDataNested<A> withNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return new JvmRuleDataNested(item);
  }
  
  public JvmRuleDataNested<A> editJvmRuleData() {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(null));
  }
  
  public JvmRuleDataNested<A> editOrNewJvmRuleData() {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(new JVMRuleDataSpecBuilder().build()));
  }
  
  public JvmRuleDataNested<A> editOrNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return withNewJvmRuleDataLike(java.util.Optional.ofNullable(buildJvmRuleData()).orElse(item));
  }
  
  public JVMStressSpec buildJvmStress() {
    return this.jvmStress != null ? this.jvmStress.build() : null;
  }
  
  public A withJvmStress(JVMStressSpec jvmStress) {
    this._visitables.remove("jvmStress");
    if (jvmStress != null) {
        this.jvmStress = new JVMStressSpecBuilder(jvmStress);
        this._visitables.get("jvmStress").add(this.jvmStress);
    } else {
        this.jvmStress = null;
        this._visitables.get("jvmStress").remove(this.jvmStress);
    }
    return (A) this;
  }
  
  public boolean hasJvmStress() {
    return this.jvmStress != null;
  }
  
  public A withNewJvmStress(Integer cpuCount,String memType,Integer pid,Integer port) {
    return (A)withJvmStress(new JVMStressSpec(cpuCount, memType, pid, port));
  }
  
  public JvmStressNested<A> withNewJvmStress() {
    return new JvmStressNested(null);
  }
  
  public JvmStressNested<A> withNewJvmStressLike(JVMStressSpec item) {
    return new JvmStressNested(item);
  }
  
  public JvmStressNested<A> editJvmStress() {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(null));
  }
  
  public JvmStressNested<A> editOrNewJvmStress() {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(new JVMStressSpecBuilder().build()));
  }
  
  public JvmStressNested<A> editOrNewJvmStressLike(JVMStressSpec item) {
    return withNewJvmStressLike(java.util.Optional.ofNullable(buildJvmStress()).orElse(item));
  }
  
  public KafkaFillSpec buildKafkaFill() {
    return this.kafkaFill != null ? this.kafkaFill.build() : null;
  }
  
  public A withKafkaFill(KafkaFillSpec kafkaFill) {
    this._visitables.remove("kafkaFill");
    if (kafkaFill != null) {
        this.kafkaFill = new KafkaFillSpecBuilder(kafkaFill);
        this._visitables.get("kafkaFill").add(this.kafkaFill);
    } else {
        this.kafkaFill = null;
        this._visitables.get("kafkaFill").remove(this.kafkaFill);
    }
    return (A) this;
  }
  
  public boolean hasKafkaFill() {
    return this.kafkaFill != null;
  }
  
  public KafkaFillNested<A> withNewKafkaFill() {
    return new KafkaFillNested(null);
  }
  
  public KafkaFillNested<A> withNewKafkaFillLike(KafkaFillSpec item) {
    return new KafkaFillNested(item);
  }
  
  public KafkaFillNested<A> editKafkaFill() {
    return withNewKafkaFillLike(java.util.Optional.ofNullable(buildKafkaFill()).orElse(null));
  }
  
  public KafkaFillNested<A> editOrNewKafkaFill() {
    return withNewKafkaFillLike(java.util.Optional.ofNullable(buildKafkaFill()).orElse(new KafkaFillSpecBuilder().build()));
  }
  
  public KafkaFillNested<A> editOrNewKafkaFillLike(KafkaFillSpec item) {
    return withNewKafkaFillLike(java.util.Optional.ofNullable(buildKafkaFill()).orElse(item));
  }
  
  public KafkaFloodSpec buildKafkaFlood() {
    return this.kafkaFlood != null ? this.kafkaFlood.build() : null;
  }
  
  public A withKafkaFlood(KafkaFloodSpec kafkaFlood) {
    this._visitables.remove("kafkaFlood");
    if (kafkaFlood != null) {
        this.kafkaFlood = new KafkaFloodSpecBuilder(kafkaFlood);
        this._visitables.get("kafkaFlood").add(this.kafkaFlood);
    } else {
        this.kafkaFlood = null;
        this._visitables.get("kafkaFlood").remove(this.kafkaFlood);
    }
    return (A) this;
  }
  
  public boolean hasKafkaFlood() {
    return this.kafkaFlood != null;
  }
  
  public KafkaFloodNested<A> withNewKafkaFlood() {
    return new KafkaFloodNested(null);
  }
  
  public KafkaFloodNested<A> withNewKafkaFloodLike(KafkaFloodSpec item) {
    return new KafkaFloodNested(item);
  }
  
  public KafkaFloodNested<A> editKafkaFlood() {
    return withNewKafkaFloodLike(java.util.Optional.ofNullable(buildKafkaFlood()).orElse(null));
  }
  
  public KafkaFloodNested<A> editOrNewKafkaFlood() {
    return withNewKafkaFloodLike(java.util.Optional.ofNullable(buildKafkaFlood()).orElse(new KafkaFloodSpecBuilder().build()));
  }
  
  public KafkaFloodNested<A> editOrNewKafkaFloodLike(KafkaFloodSpec item) {
    return withNewKafkaFloodLike(java.util.Optional.ofNullable(buildKafkaFlood()).orElse(item));
  }
  
  public KafkaIOSpec buildKafkaIo() {
    return this.kafkaIo != null ? this.kafkaIo.build() : null;
  }
  
  public A withKafkaIo(KafkaIOSpec kafkaIo) {
    this._visitables.remove("kafkaIo");
    if (kafkaIo != null) {
        this.kafkaIo = new KafkaIOSpecBuilder(kafkaIo);
        this._visitables.get("kafkaIo").add(this.kafkaIo);
    } else {
        this.kafkaIo = null;
        this._visitables.get("kafkaIo").remove(this.kafkaIo);
    }
    return (A) this;
  }
  
  public boolean hasKafkaIo() {
    return this.kafkaIo != null;
  }
  
  public A withNewKafkaIo(String configFile,Boolean nonReadable,Boolean nonWritable,String topic) {
    return (A)withKafkaIo(new KafkaIOSpec(configFile, nonReadable, nonWritable, topic));
  }
  
  public KafkaIoNested<A> withNewKafkaIo() {
    return new KafkaIoNested(null);
  }
  
  public KafkaIoNested<A> withNewKafkaIoLike(KafkaIOSpec item) {
    return new KafkaIoNested(item);
  }
  
  public KafkaIoNested<A> editKafkaIo() {
    return withNewKafkaIoLike(java.util.Optional.ofNullable(buildKafkaIo()).orElse(null));
  }
  
  public KafkaIoNested<A> editOrNewKafkaIo() {
    return withNewKafkaIoLike(java.util.Optional.ofNullable(buildKafkaIo()).orElse(new KafkaIOSpecBuilder().build()));
  }
  
  public KafkaIoNested<A> editOrNewKafkaIoLike(KafkaIOSpec item) {
    return withNewKafkaIoLike(java.util.Optional.ofNullable(buildKafkaIo()).orElse(item));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public NetworkBandwidthSpec buildNetworkBandwidth() {
    return this.networkBandwidth != null ? this.networkBandwidth.build() : null;
  }
  
  public A withNetworkBandwidth(NetworkBandwidthSpec networkBandwidth) {
    this._visitables.remove("networkBandwidth");
    if (networkBandwidth != null) {
        this.networkBandwidth = new NetworkBandwidthSpecBuilder(networkBandwidth);
        this._visitables.get("networkBandwidth").add(this.networkBandwidth);
    } else {
        this.networkBandwidth = null;
        this._visitables.get("networkBandwidth").remove(this.networkBandwidth);
    }
    return (A) this;
  }
  
  public boolean hasNetworkBandwidth() {
    return this.networkBandwidth != null;
  }
  
  public NetworkBandwidthNested<A> withNewNetworkBandwidth() {
    return new NetworkBandwidthNested(null);
  }
  
  public NetworkBandwidthNested<A> withNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return new NetworkBandwidthNested(item);
  }
  
  public NetworkBandwidthNested<A> editNetworkBandwidth() {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(null));
  }
  
  public NetworkBandwidthNested<A> editOrNewNetworkBandwidth() {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(new NetworkBandwidthSpecBuilder().build()));
  }
  
  public NetworkBandwidthNested<A> editOrNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return withNewNetworkBandwidthLike(java.util.Optional.ofNullable(buildNetworkBandwidth()).orElse(item));
  }
  
  public NetworkCorruptSpec buildNetworkCorrupt() {
    return this.networkCorrupt != null ? this.networkCorrupt.build() : null;
  }
  
  public A withNetworkCorrupt(NetworkCorruptSpec networkCorrupt) {
    this._visitables.remove("networkCorrupt");
    if (networkCorrupt != null) {
        this.networkCorrupt = new NetworkCorruptSpecBuilder(networkCorrupt);
        this._visitables.get("networkCorrupt").add(this.networkCorrupt);
    } else {
        this.networkCorrupt = null;
        this._visitables.get("networkCorrupt").remove(this.networkCorrupt);
    }
    return (A) this;
  }
  
  public boolean hasNetworkCorrupt() {
    return this.networkCorrupt != null;
  }
  
  public NetworkCorruptNested<A> withNewNetworkCorrupt() {
    return new NetworkCorruptNested(null);
  }
  
  public NetworkCorruptNested<A> withNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return new NetworkCorruptNested(item);
  }
  
  public NetworkCorruptNested<A> editNetworkCorrupt() {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(null));
  }
  
  public NetworkCorruptNested<A> editOrNewNetworkCorrupt() {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(new NetworkCorruptSpecBuilder().build()));
  }
  
  public NetworkCorruptNested<A> editOrNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return withNewNetworkCorruptLike(java.util.Optional.ofNullable(buildNetworkCorrupt()).orElse(item));
  }
  
  public NetworkDelaySpec buildNetworkDelay() {
    return this.networkDelay != null ? this.networkDelay.build() : null;
  }
  
  public A withNetworkDelay(NetworkDelaySpec networkDelay) {
    this._visitables.remove("networkDelay");
    if (networkDelay != null) {
        this.networkDelay = new NetworkDelaySpecBuilder(networkDelay);
        this._visitables.get("networkDelay").add(this.networkDelay);
    } else {
        this.networkDelay = null;
        this._visitables.get("networkDelay").remove(this.networkDelay);
    }
    return (A) this;
  }
  
  public boolean hasNetworkDelay() {
    return this.networkDelay != null;
  }
  
  public NetworkDelayNested<A> withNewNetworkDelay() {
    return new NetworkDelayNested(null);
  }
  
  public NetworkDelayNested<A> withNewNetworkDelayLike(NetworkDelaySpec item) {
    return new NetworkDelayNested(item);
  }
  
  public NetworkDelayNested<A> editNetworkDelay() {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(null));
  }
  
  public NetworkDelayNested<A> editOrNewNetworkDelay() {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(new NetworkDelaySpecBuilder().build()));
  }
  
  public NetworkDelayNested<A> editOrNewNetworkDelayLike(NetworkDelaySpec item) {
    return withNewNetworkDelayLike(java.util.Optional.ofNullable(buildNetworkDelay()).orElse(item));
  }
  
  public NetworkDNSSpec buildNetworkDns() {
    return this.networkDns != null ? this.networkDns.build() : null;
  }
  
  public A withNetworkDns(NetworkDNSSpec networkDns) {
    this._visitables.remove("networkDns");
    if (networkDns != null) {
        this.networkDns = new NetworkDNSSpecBuilder(networkDns);
        this._visitables.get("networkDns").add(this.networkDns);
    } else {
        this.networkDns = null;
        this._visitables.get("networkDns").remove(this.networkDns);
    }
    return (A) this;
  }
  
  public boolean hasNetworkDns() {
    return this.networkDns != null;
  }
  
  public A withNewNetworkDns(String dnsDomainName,String dnsIp,String dnsServer) {
    return (A)withNetworkDns(new NetworkDNSSpec(dnsDomainName, dnsIp, dnsServer));
  }
  
  public NetworkDnsNested<A> withNewNetworkDns() {
    return new NetworkDnsNested(null);
  }
  
  public NetworkDnsNested<A> withNewNetworkDnsLike(NetworkDNSSpec item) {
    return new NetworkDnsNested(item);
  }
  
  public NetworkDnsNested<A> editNetworkDns() {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(null));
  }
  
  public NetworkDnsNested<A> editOrNewNetworkDns() {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(new NetworkDNSSpecBuilder().build()));
  }
  
  public NetworkDnsNested<A> editOrNewNetworkDnsLike(NetworkDNSSpec item) {
    return withNewNetworkDnsLike(java.util.Optional.ofNullable(buildNetworkDns()).orElse(item));
  }
  
  public NetworkDownSpec buildNetworkDown() {
    return this.networkDown != null ? this.networkDown.build() : null;
  }
  
  public A withNetworkDown(NetworkDownSpec networkDown) {
    this._visitables.remove("networkDown");
    if (networkDown != null) {
        this.networkDown = new NetworkDownSpecBuilder(networkDown);
        this._visitables.get("networkDown").add(this.networkDown);
    } else {
        this.networkDown = null;
        this._visitables.get("networkDown").remove(this.networkDown);
    }
    return (A) this;
  }
  
  public boolean hasNetworkDown() {
    return this.networkDown != null;
  }
  
  public A withNewNetworkDown(String device,String duration) {
    return (A)withNetworkDown(new NetworkDownSpec(device, duration));
  }
  
  public NetworkDownNested<A> withNewNetworkDown() {
    return new NetworkDownNested(null);
  }
  
  public NetworkDownNested<A> withNewNetworkDownLike(NetworkDownSpec item) {
    return new NetworkDownNested(item);
  }
  
  public NetworkDownNested<A> editNetworkDown() {
    return withNewNetworkDownLike(java.util.Optional.ofNullable(buildNetworkDown()).orElse(null));
  }
  
  public NetworkDownNested<A> editOrNewNetworkDown() {
    return withNewNetworkDownLike(java.util.Optional.ofNullable(buildNetworkDown()).orElse(new NetworkDownSpecBuilder().build()));
  }
  
  public NetworkDownNested<A> editOrNewNetworkDownLike(NetworkDownSpec item) {
    return withNewNetworkDownLike(java.util.Optional.ofNullable(buildNetworkDown()).orElse(item));
  }
  
  public NetworkDuplicateSpec buildNetworkDuplicate() {
    return this.networkDuplicate != null ? this.networkDuplicate.build() : null;
  }
  
  public A withNetworkDuplicate(NetworkDuplicateSpec networkDuplicate) {
    this._visitables.remove("networkDuplicate");
    if (networkDuplicate != null) {
        this.networkDuplicate = new NetworkDuplicateSpecBuilder(networkDuplicate);
        this._visitables.get("networkDuplicate").add(this.networkDuplicate);
    } else {
        this.networkDuplicate = null;
        this._visitables.get("networkDuplicate").remove(this.networkDuplicate);
    }
    return (A) this;
  }
  
  public boolean hasNetworkDuplicate() {
    return this.networkDuplicate != null;
  }
  
  public NetworkDuplicateNested<A> withNewNetworkDuplicate() {
    return new NetworkDuplicateNested(null);
  }
  
  public NetworkDuplicateNested<A> withNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return new NetworkDuplicateNested(item);
  }
  
  public NetworkDuplicateNested<A> editNetworkDuplicate() {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(null));
  }
  
  public NetworkDuplicateNested<A> editOrNewNetworkDuplicate() {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(new NetworkDuplicateSpecBuilder().build()));
  }
  
  public NetworkDuplicateNested<A> editOrNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return withNewNetworkDuplicateLike(java.util.Optional.ofNullable(buildNetworkDuplicate()).orElse(item));
  }
  
  public NetworkFloodSpec buildNetworkFlood() {
    return this.networkFlood != null ? this.networkFlood.build() : null;
  }
  
  public A withNetworkFlood(NetworkFloodSpec networkFlood) {
    this._visitables.remove("networkFlood");
    if (networkFlood != null) {
        this.networkFlood = new NetworkFloodSpecBuilder(networkFlood);
        this._visitables.get("networkFlood").add(this.networkFlood);
    } else {
        this.networkFlood = null;
        this._visitables.get("networkFlood").remove(this.networkFlood);
    }
    return (A) this;
  }
  
  public boolean hasNetworkFlood() {
    return this.networkFlood != null;
  }
  
  public A withNewNetworkFlood(String duration,String ipAddress,Integer parallel,String port,String rate) {
    return (A)withNetworkFlood(new NetworkFloodSpec(duration, ipAddress, parallel, port, rate));
  }
  
  public NetworkFloodNested<A> withNewNetworkFlood() {
    return new NetworkFloodNested(null);
  }
  
  public NetworkFloodNested<A> withNewNetworkFloodLike(NetworkFloodSpec item) {
    return new NetworkFloodNested(item);
  }
  
  public NetworkFloodNested<A> editNetworkFlood() {
    return withNewNetworkFloodLike(java.util.Optional.ofNullable(buildNetworkFlood()).orElse(null));
  }
  
  public NetworkFloodNested<A> editOrNewNetworkFlood() {
    return withNewNetworkFloodLike(java.util.Optional.ofNullable(buildNetworkFlood()).orElse(new NetworkFloodSpecBuilder().build()));
  }
  
  public NetworkFloodNested<A> editOrNewNetworkFloodLike(NetworkFloodSpec item) {
    return withNewNetworkFloodLike(java.util.Optional.ofNullable(buildNetworkFlood()).orElse(item));
  }
  
  public NetworkLossSpec buildNetworkLoss() {
    return this.networkLoss != null ? this.networkLoss.build() : null;
  }
  
  public A withNetworkLoss(NetworkLossSpec networkLoss) {
    this._visitables.remove("networkLoss");
    if (networkLoss != null) {
        this.networkLoss = new NetworkLossSpecBuilder(networkLoss);
        this._visitables.get("networkLoss").add(this.networkLoss);
    } else {
        this.networkLoss = null;
        this._visitables.get("networkLoss").remove(this.networkLoss);
    }
    return (A) this;
  }
  
  public boolean hasNetworkLoss() {
    return this.networkLoss != null;
  }
  
  public NetworkLossNested<A> withNewNetworkLoss() {
    return new NetworkLossNested(null);
  }
  
  public NetworkLossNested<A> withNewNetworkLossLike(NetworkLossSpec item) {
    return new NetworkLossNested(item);
  }
  
  public NetworkLossNested<A> editNetworkLoss() {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(null));
  }
  
  public NetworkLossNested<A> editOrNewNetworkLoss() {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(new NetworkLossSpecBuilder().build()));
  }
  
  public NetworkLossNested<A> editOrNewNetworkLossLike(NetworkLossSpec item) {
    return withNewNetworkLossLike(java.util.Optional.ofNullable(buildNetworkLoss()).orElse(item));
  }
  
  public NetworkPartitionSpec buildNetworkPartition() {
    return this.networkPartition != null ? this.networkPartition.build() : null;
  }
  
  public A withNetworkPartition(NetworkPartitionSpec networkPartition) {
    this._visitables.remove("networkPartition");
    if (networkPartition != null) {
        this.networkPartition = new NetworkPartitionSpecBuilder(networkPartition);
        this._visitables.get("networkPartition").add(this.networkPartition);
    } else {
        this.networkPartition = null;
        this._visitables.get("networkPartition").remove(this.networkPartition);
    }
    return (A) this;
  }
  
  public boolean hasNetworkPartition() {
    return this.networkPartition != null;
  }
  
  public NetworkPartitionNested<A> withNewNetworkPartition() {
    return new NetworkPartitionNested(null);
  }
  
  public NetworkPartitionNested<A> withNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return new NetworkPartitionNested(item);
  }
  
  public NetworkPartitionNested<A> editNetworkPartition() {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(null));
  }
  
  public NetworkPartitionNested<A> editOrNewNetworkPartition() {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(new NetworkPartitionSpecBuilder().build()));
  }
  
  public NetworkPartitionNested<A> editOrNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return withNewNetworkPartitionLike(java.util.Optional.ofNullable(buildNetworkPartition()).orElse(item));
  }
  
  public ProcessSpec buildProcess() {
    return this.process != null ? this.process.build() : null;
  }
  
  public A withProcess(ProcessSpec process) {
    this._visitables.remove("process");
    if (process != null) {
        this.process = new ProcessSpecBuilder(process);
        this._visitables.get("process").add(this.process);
    } else {
        this.process = null;
        this._visitables.get("process").remove(this.process);
    }
    return (A) this;
  }
  
  public boolean hasProcess() {
    return this.process != null;
  }
  
  public A withNewProcess(String process,String recoverCmd,Integer signal) {
    return (A)withProcess(new ProcessSpec(process, recoverCmd, signal));
  }
  
  public ProcessNested<A> withNewProcess() {
    return new ProcessNested(null);
  }
  
  public ProcessNested<A> withNewProcessLike(ProcessSpec item) {
    return new ProcessNested(item);
  }
  
  public ProcessNested<A> editProcess() {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(null));
  }
  
  public ProcessNested<A> editOrNewProcess() {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(new ProcessSpecBuilder().build()));
  }
  
  public ProcessNested<A> editOrNewProcessLike(ProcessSpec item) {
    return withNewProcessLike(java.util.Optional.ofNullable(buildProcess()).orElse(item));
  }
  
  public RedisCacheLimitSpec buildRedisCacheLimit() {
    return this.redisCacheLimit != null ? this.redisCacheLimit.build() : null;
  }
  
  public A withRedisCacheLimit(RedisCacheLimitSpec redisCacheLimit) {
    this._visitables.remove("redisCacheLimit");
    if (redisCacheLimit != null) {
        this.redisCacheLimit = new RedisCacheLimitSpecBuilder(redisCacheLimit);
        this._visitables.get("redisCacheLimit").add(this.redisCacheLimit);
    } else {
        this.redisCacheLimit = null;
        this._visitables.get("redisCacheLimit").remove(this.redisCacheLimit);
    }
    return (A) this;
  }
  
  public boolean hasRedisCacheLimit() {
    return this.redisCacheLimit != null;
  }
  
  public A withNewRedisCacheLimit(String addr,String cacheSize,String password,String percent) {
    return (A)withRedisCacheLimit(new RedisCacheLimitSpec(addr, cacheSize, password, percent));
  }
  
  public RedisCacheLimitNested<A> withNewRedisCacheLimit() {
    return new RedisCacheLimitNested(null);
  }
  
  public RedisCacheLimitNested<A> withNewRedisCacheLimitLike(RedisCacheLimitSpec item) {
    return new RedisCacheLimitNested(item);
  }
  
  public RedisCacheLimitNested<A> editRedisCacheLimit() {
    return withNewRedisCacheLimitLike(java.util.Optional.ofNullable(buildRedisCacheLimit()).orElse(null));
  }
  
  public RedisCacheLimitNested<A> editOrNewRedisCacheLimit() {
    return withNewRedisCacheLimitLike(java.util.Optional.ofNullable(buildRedisCacheLimit()).orElse(new RedisCacheLimitSpecBuilder().build()));
  }
  
  public RedisCacheLimitNested<A> editOrNewRedisCacheLimitLike(RedisCacheLimitSpec item) {
    return withNewRedisCacheLimitLike(java.util.Optional.ofNullable(buildRedisCacheLimit()).orElse(item));
  }
  
  public RedisExpirationSpec buildRedisExpiration() {
    return this.redisExpiration != null ? this.redisExpiration.build() : null;
  }
  
  public A withRedisExpiration(RedisExpirationSpec redisExpiration) {
    this._visitables.remove("redisExpiration");
    if (redisExpiration != null) {
        this.redisExpiration = new RedisExpirationSpecBuilder(redisExpiration);
        this._visitables.get("redisExpiration").add(this.redisExpiration);
    } else {
        this.redisExpiration = null;
        this._visitables.get("redisExpiration").remove(this.redisExpiration);
    }
    return (A) this;
  }
  
  public boolean hasRedisExpiration() {
    return this.redisExpiration != null;
  }
  
  public A withNewRedisExpiration(String addr,String expiration,String key,String option,String password) {
    return (A)withRedisExpiration(new RedisExpirationSpec(addr, expiration, key, option, password));
  }
  
  public RedisExpirationNested<A> withNewRedisExpiration() {
    return new RedisExpirationNested(null);
  }
  
  public RedisExpirationNested<A> withNewRedisExpirationLike(RedisExpirationSpec item) {
    return new RedisExpirationNested(item);
  }
  
  public RedisExpirationNested<A> editRedisExpiration() {
    return withNewRedisExpirationLike(java.util.Optional.ofNullable(buildRedisExpiration()).orElse(null));
  }
  
  public RedisExpirationNested<A> editOrNewRedisExpiration() {
    return withNewRedisExpirationLike(java.util.Optional.ofNullable(buildRedisExpiration()).orElse(new RedisExpirationSpecBuilder().build()));
  }
  
  public RedisExpirationNested<A> editOrNewRedisExpirationLike(RedisExpirationSpec item) {
    return withNewRedisExpirationLike(java.util.Optional.ofNullable(buildRedisExpiration()).orElse(item));
  }
  
  public RedisPenetrationSpec buildRedisPenetration() {
    return this.redisPenetration != null ? this.redisPenetration.build() : null;
  }
  
  public A withRedisPenetration(RedisPenetrationSpec redisPenetration) {
    this._visitables.remove("redisPenetration");
    if (redisPenetration != null) {
        this.redisPenetration = new RedisPenetrationSpecBuilder(redisPenetration);
        this._visitables.get("redisPenetration").add(this.redisPenetration);
    } else {
        this.redisPenetration = null;
        this._visitables.get("redisPenetration").remove(this.redisPenetration);
    }
    return (A) this;
  }
  
  public boolean hasRedisPenetration() {
    return this.redisPenetration != null;
  }
  
  public A withNewRedisPenetration(String addr,String password,Integer requestNum) {
    return (A)withRedisPenetration(new RedisPenetrationSpec(addr, password, requestNum));
  }
  
  public RedisPenetrationNested<A> withNewRedisPenetration() {
    return new RedisPenetrationNested(null);
  }
  
  public RedisPenetrationNested<A> withNewRedisPenetrationLike(RedisPenetrationSpec item) {
    return new RedisPenetrationNested(item);
  }
  
  public RedisPenetrationNested<A> editRedisPenetration() {
    return withNewRedisPenetrationLike(java.util.Optional.ofNullable(buildRedisPenetration()).orElse(null));
  }
  
  public RedisPenetrationNested<A> editOrNewRedisPenetration() {
    return withNewRedisPenetrationLike(java.util.Optional.ofNullable(buildRedisPenetration()).orElse(new RedisPenetrationSpecBuilder().build()));
  }
  
  public RedisPenetrationNested<A> editOrNewRedisPenetrationLike(RedisPenetrationSpec item) {
    return withNewRedisPenetrationLike(java.util.Optional.ofNullable(buildRedisPenetration()).orElse(item));
  }
  
  public RedisSentinelRestartSpec buildRedisRestart() {
    return this.redisRestart != null ? this.redisRestart.build() : null;
  }
  
  public A withRedisRestart(RedisSentinelRestartSpec redisRestart) {
    this._visitables.remove("redisRestart");
    if (redisRestart != null) {
        this.redisRestart = new RedisSentinelRestartSpecBuilder(redisRestart);
        this._visitables.get("redisRestart").add(this.redisRestart);
    } else {
        this.redisRestart = null;
        this._visitables.get("redisRestart").remove(this.redisRestart);
    }
    return (A) this;
  }
  
  public boolean hasRedisRestart() {
    return this.redisRestart != null;
  }
  
  public A withNewRedisRestart(String addr,String conf,Boolean flushConfig,String password,Boolean redisPath) {
    return (A)withRedisRestart(new RedisSentinelRestartSpec(addr, conf, flushConfig, password, redisPath));
  }
  
  public RedisRestartNested<A> withNewRedisRestart() {
    return new RedisRestartNested(null);
  }
  
  public RedisRestartNested<A> withNewRedisRestartLike(RedisSentinelRestartSpec item) {
    return new RedisRestartNested(item);
  }
  
  public RedisRestartNested<A> editRedisRestart() {
    return withNewRedisRestartLike(java.util.Optional.ofNullable(buildRedisRestart()).orElse(null));
  }
  
  public RedisRestartNested<A> editOrNewRedisRestart() {
    return withNewRedisRestartLike(java.util.Optional.ofNullable(buildRedisRestart()).orElse(new RedisSentinelRestartSpecBuilder().build()));
  }
  
  public RedisRestartNested<A> editOrNewRedisRestartLike(RedisSentinelRestartSpec item) {
    return withNewRedisRestartLike(java.util.Optional.ofNullable(buildRedisRestart()).orElse(item));
  }
  
  public RedisSentinelStopSpec buildRedisStop() {
    return this.redisStop != null ? this.redisStop.build() : null;
  }
  
  public A withRedisStop(RedisSentinelStopSpec redisStop) {
    this._visitables.remove("redisStop");
    if (redisStop != null) {
        this.redisStop = new RedisSentinelStopSpecBuilder(redisStop);
        this._visitables.get("redisStop").add(this.redisStop);
    } else {
        this.redisStop = null;
        this._visitables.get("redisStop").remove(this.redisStop);
    }
    return (A) this;
  }
  
  public boolean hasRedisStop() {
    return this.redisStop != null;
  }
  
  public A withNewRedisStop(String addr,String conf,Boolean flushConfig,String password,Boolean redisPath) {
    return (A)withRedisStop(new RedisSentinelStopSpec(addr, conf, flushConfig, password, redisPath));
  }
  
  public RedisStopNested<A> withNewRedisStop() {
    return new RedisStopNested(null);
  }
  
  public RedisStopNested<A> withNewRedisStopLike(RedisSentinelStopSpec item) {
    return new RedisStopNested(item);
  }
  
  public RedisStopNested<A> editRedisStop() {
    return withNewRedisStopLike(java.util.Optional.ofNullable(buildRedisStop()).orElse(null));
  }
  
  public RedisStopNested<A> editOrNewRedisStop() {
    return withNewRedisStopLike(java.util.Optional.ofNullable(buildRedisStop()).orElse(new RedisSentinelStopSpecBuilder().build()));
  }
  
  public RedisStopNested<A> editOrNewRedisStopLike(RedisSentinelStopSpec item) {
    return withNewRedisStopLike(java.util.Optional.ofNullable(buildRedisStop()).orElse(item));
  }
  
  public String getRemoteCluster() {
    return this.remoteCluster;
  }
  
  public A withRemoteCluster(String remoteCluster) {
    this.remoteCluster = remoteCluster;
    return (A) this;
  }
  
  public boolean hasRemoteCluster() {
    return this.remoteCluster != null;
  }
  
  public PhysicalMachineSelectorSpec buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(PhysicalMachineSelectorSpec selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new PhysicalMachineSelectorSpecBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PhysicalMachineSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public StressCPUSpec buildStressCpu() {
    return this.stressCpu != null ? this.stressCpu.build() : null;
  }
  
  public A withStressCpu(StressCPUSpec stressCpu) {
    this._visitables.remove("stressCpu");
    if (stressCpu != null) {
        this.stressCpu = new StressCPUSpecBuilder(stressCpu);
        this._visitables.get("stressCpu").add(this.stressCpu);
    } else {
        this.stressCpu = null;
        this._visitables.get("stressCpu").remove(this.stressCpu);
    }
    return (A) this;
  }
  
  public boolean hasStressCpu() {
    return this.stressCpu != null;
  }
  
  public StressCpuNested<A> withNewStressCpu() {
    return new StressCpuNested(null);
  }
  
  public StressCpuNested<A> withNewStressCpuLike(StressCPUSpec item) {
    return new StressCpuNested(item);
  }
  
  public StressCpuNested<A> editStressCpu() {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(null));
  }
  
  public StressCpuNested<A> editOrNewStressCpu() {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(new StressCPUSpecBuilder().build()));
  }
  
  public StressCpuNested<A> editOrNewStressCpuLike(StressCPUSpec item) {
    return withNewStressCpuLike(java.util.Optional.ofNullable(buildStressCpu()).orElse(item));
  }
  
  public StressMemorySpec buildStressMem() {
    return this.stressMem != null ? this.stressMem.build() : null;
  }
  
  public A withStressMem(StressMemorySpec stressMem) {
    this._visitables.remove("stressMem");
    if (stressMem != null) {
        this.stressMem = new StressMemorySpecBuilder(stressMem);
        this._visitables.get("stressMem").add(this.stressMem);
    } else {
        this.stressMem = null;
        this._visitables.get("stressMem").remove(this.stressMem);
    }
    return (A) this;
  }
  
  public boolean hasStressMem() {
    return this.stressMem != null;
  }
  
  public StressMemNested<A> withNewStressMem() {
    return new StressMemNested(null);
  }
  
  public StressMemNested<A> withNewStressMemLike(StressMemorySpec item) {
    return new StressMemNested(item);
  }
  
  public StressMemNested<A> editStressMem() {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(null));
  }
  
  public StressMemNested<A> editOrNewStressMem() {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(new StressMemorySpecBuilder().build()));
  }
  
  public StressMemNested<A> editOrNewStressMemLike(StressMemorySpec item) {
    return withNewStressMemLike(java.util.Optional.ofNullable(buildStressMem()).orElse(item));
  }
  
  public UserDefinedSpec buildUserDefined() {
    return this.userDefined != null ? this.userDefined.build() : null;
  }
  
  public A withUserDefined(UserDefinedSpec userDefined) {
    this._visitables.remove("userDefined");
    if (userDefined != null) {
        this.userDefined = new UserDefinedSpecBuilder(userDefined);
        this._visitables.get("userDefined").add(this.userDefined);
    } else {
        this.userDefined = null;
        this._visitables.get("userDefined").remove(this.userDefined);
    }
    return (A) this;
  }
  
  public boolean hasUserDefined() {
    return this.userDefined != null;
  }
  
  public A withNewUserDefined(String attackCmd,String recoverCmd) {
    return (A)withUserDefined(new UserDefinedSpec(attackCmd, recoverCmd));
  }
  
  public UserDefinedNested<A> withNewUserDefined() {
    return new UserDefinedNested(null);
  }
  
  public UserDefinedNested<A> withNewUserDefinedLike(UserDefinedSpec item) {
    return new UserDefinedNested(item);
  }
  
  public UserDefinedNested<A> editUserDefined() {
    return withNewUserDefinedLike(java.util.Optional.ofNullable(buildUserDefined()).orElse(null));
  }
  
  public UserDefinedNested<A> editOrNewUserDefined() {
    return withNewUserDefinedLike(java.util.Optional.ofNullable(buildUserDefined()).orElse(new UserDefinedSpecBuilder().build()));
  }
  
  public UserDefinedNested<A> editOrNewUserDefinedLike(UserDefinedSpec item) {
    return withNewUserDefinedLike(java.util.Optional.ofNullable(buildUserDefined()).orElse(item));
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public VMSpec buildVm() {
    return this.vm != null ? this.vm.build() : null;
  }
  
  public A withVm(VMSpec vm) {
    this._visitables.remove("vm");
    if (vm != null) {
        this.vm = new VMSpecBuilder(vm);
        this._visitables.get("vm").add(this.vm);
    } else {
        this.vm = null;
        this._visitables.get("vm").remove(this.vm);
    }
    return (A) this;
  }
  
  public boolean hasVm() {
    return this.vm != null;
  }
  
  public A withNewVm(String vmName) {
    return (A)withVm(new VMSpec(vmName));
  }
  
  public VmNested<A> withNewVm() {
    return new VmNested(null);
  }
  
  public VmNested<A> withNewVmLike(VMSpec item) {
    return new VmNested(item);
  }
  
  public VmNested<A> editVm() {
    return withNewVmLike(java.util.Optional.ofNullable(buildVm()).orElse(null));
  }
  
  public VmNested<A> editOrNewVm() {
    return withNewVmLike(java.util.Optional.ofNullable(buildVm()).orElse(new VMSpecBuilder().build()));
  }
  
  public VmNested<A> editOrNewVmLike(VMSpec item) {
    return withNewVmLike(java.util.Optional.ofNullable(buildVm()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PhysicalMachineChaosSpecFluent that = (PhysicalMachineChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
    if (!java.util.Objects.equals(address, that.address)) return false;
    if (!java.util.Objects.equals(clock, that.clock)) return false;
    if (!java.util.Objects.equals(diskFill, that.diskFill)) return false;
    if (!java.util.Objects.equals(diskReadPayload, that.diskReadPayload)) return false;
    if (!java.util.Objects.equals(diskWritePayload, that.diskWritePayload)) return false;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(fileAppend, that.fileAppend)) return false;
    if (!java.util.Objects.equals(fileCreate, that.fileCreate)) return false;
    if (!java.util.Objects.equals(fileDelete, that.fileDelete)) return false;
    if (!java.util.Objects.equals(fileModify, that.fileModify)) return false;
    if (!java.util.Objects.equals(fileRename, that.fileRename)) return false;
    if (!java.util.Objects.equals(fileReplace, that.fileReplace)) return false;
    if (!java.util.Objects.equals(httpAbort, that.httpAbort)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(httpDelay, that.httpDelay)) return false;
    if (!java.util.Objects.equals(httpRequest, that.httpRequest)) return false;
    if (!java.util.Objects.equals(jvmException, that.jvmException)) return false;
    if (!java.util.Objects.equals(jvmGc, that.jvmGc)) return false;
    if (!java.util.Objects.equals(jvmLatency, that.jvmLatency)) return false;
    if (!java.util.Objects.equals(jvmMysql, that.jvmMysql)) return false;
    if (!java.util.Objects.equals(jvmReturn, that.jvmReturn)) return false;
    if (!java.util.Objects.equals(jvmRuleData, that.jvmRuleData)) return false;
    if (!java.util.Objects.equals(jvmStress, that.jvmStress)) return false;
    if (!java.util.Objects.equals(kafkaFill, that.kafkaFill)) return false;
    if (!java.util.Objects.equals(kafkaFlood, that.kafkaFlood)) return false;
    if (!java.util.Objects.equals(kafkaIo, that.kafkaIo)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(networkBandwidth, that.networkBandwidth)) return false;
    if (!java.util.Objects.equals(networkCorrupt, that.networkCorrupt)) return false;
    if (!java.util.Objects.equals(networkDelay, that.networkDelay)) return false;
    if (!java.util.Objects.equals(networkDns, that.networkDns)) return false;
    if (!java.util.Objects.equals(networkDown, that.networkDown)) return false;
    if (!java.util.Objects.equals(networkDuplicate, that.networkDuplicate)) return false;
    if (!java.util.Objects.equals(networkFlood, that.networkFlood)) return false;
    if (!java.util.Objects.equals(networkLoss, that.networkLoss)) return false;
    if (!java.util.Objects.equals(networkPartition, that.networkPartition)) return false;
    if (!java.util.Objects.equals(process, that.process)) return false;
    if (!java.util.Objects.equals(redisCacheLimit, that.redisCacheLimit)) return false;
    if (!java.util.Objects.equals(redisExpiration, that.redisExpiration)) return false;
    if (!java.util.Objects.equals(redisPenetration, that.redisPenetration)) return false;
    if (!java.util.Objects.equals(redisRestart, that.redisRestart)) return false;
    if (!java.util.Objects.equals(redisStop, that.redisStop)) return false;
    if (!java.util.Objects.equals(remoteCluster, that.remoteCluster)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(stressCpu, that.stressCpu)) return false;
    if (!java.util.Objects.equals(stressMem, that.stressMem)) return false;
    if (!java.util.Objects.equals(userDefined, that.userDefined)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(vm, that.vm)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  address,  clock,  diskFill,  diskReadPayload,  diskWritePayload,  duration,  fileAppend,  fileCreate,  fileDelete,  fileModify,  fileRename,  fileReplace,  httpAbort,  httpConfig,  httpDelay,  httpRequest,  jvmException,  jvmGc,  jvmLatency,  jvmMysql,  jvmReturn,  jvmRuleData,  jvmStress,  kafkaFill,  kafkaFlood,  kafkaIo,  mode,  networkBandwidth,  networkCorrupt,  networkDelay,  networkDns,  networkDown,  networkDuplicate,  networkFlood,  networkLoss,  networkPartition,  process,  redisCacheLimit,  redisExpiration,  redisPenetration,  redisRestart,  redisStop,  remoteCluster,  selector,  stressCpu,  stressMem,  userDefined,  value,  vm,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (address != null && !address.isEmpty()) { sb.append("address:"); sb.append(address + ","); }
    if (clock != null) { sb.append("clock:"); sb.append(clock + ","); }
    if (diskFill != null) { sb.append("diskFill:"); sb.append(diskFill + ","); }
    if (diskReadPayload != null) { sb.append("diskReadPayload:"); sb.append(diskReadPayload + ","); }
    if (diskWritePayload != null) { sb.append("diskWritePayload:"); sb.append(diskWritePayload + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (fileAppend != null) { sb.append("fileAppend:"); sb.append(fileAppend + ","); }
    if (fileCreate != null) { sb.append("fileCreate:"); sb.append(fileCreate + ","); }
    if (fileDelete != null) { sb.append("fileDelete:"); sb.append(fileDelete + ","); }
    if (fileModify != null) { sb.append("fileModify:"); sb.append(fileModify + ","); }
    if (fileRename != null) { sb.append("fileRename:"); sb.append(fileRename + ","); }
    if (fileReplace != null) { sb.append("fileReplace:"); sb.append(fileReplace + ","); }
    if (httpAbort != null) { sb.append("httpAbort:"); sb.append(httpAbort + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (httpDelay != null) { sb.append("httpDelay:"); sb.append(httpDelay + ","); }
    if (httpRequest != null) { sb.append("httpRequest:"); sb.append(httpRequest + ","); }
    if (jvmException != null) { sb.append("jvmException:"); sb.append(jvmException + ","); }
    if (jvmGc != null) { sb.append("jvmGc:"); sb.append(jvmGc + ","); }
    if (jvmLatency != null) { sb.append("jvmLatency:"); sb.append(jvmLatency + ","); }
    if (jvmMysql != null) { sb.append("jvmMysql:"); sb.append(jvmMysql + ","); }
    if (jvmReturn != null) { sb.append("jvmReturn:"); sb.append(jvmReturn + ","); }
    if (jvmRuleData != null) { sb.append("jvmRuleData:"); sb.append(jvmRuleData + ","); }
    if (jvmStress != null) { sb.append("jvmStress:"); sb.append(jvmStress + ","); }
    if (kafkaFill != null) { sb.append("kafkaFill:"); sb.append(kafkaFill + ","); }
    if (kafkaFlood != null) { sb.append("kafkaFlood:"); sb.append(kafkaFlood + ","); }
    if (kafkaIo != null) { sb.append("kafkaIo:"); sb.append(kafkaIo + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (networkBandwidth != null) { sb.append("networkBandwidth:"); sb.append(networkBandwidth + ","); }
    if (networkCorrupt != null) { sb.append("networkCorrupt:"); sb.append(networkCorrupt + ","); }
    if (networkDelay != null) { sb.append("networkDelay:"); sb.append(networkDelay + ","); }
    if (networkDns != null) { sb.append("networkDns:"); sb.append(networkDns + ","); }
    if (networkDown != null) { sb.append("networkDown:"); sb.append(networkDown + ","); }
    if (networkDuplicate != null) { sb.append("networkDuplicate:"); sb.append(networkDuplicate + ","); }
    if (networkFlood != null) { sb.append("networkFlood:"); sb.append(networkFlood + ","); }
    if (networkLoss != null) { sb.append("networkLoss:"); sb.append(networkLoss + ","); }
    if (networkPartition != null) { sb.append("networkPartition:"); sb.append(networkPartition + ","); }
    if (process != null) { sb.append("process:"); sb.append(process + ","); }
    if (redisCacheLimit != null) { sb.append("redisCacheLimit:"); sb.append(redisCacheLimit + ","); }
    if (redisExpiration != null) { sb.append("redisExpiration:"); sb.append(redisExpiration + ","); }
    if (redisPenetration != null) { sb.append("redisPenetration:"); sb.append(redisPenetration + ","); }
    if (redisRestart != null) { sb.append("redisRestart:"); sb.append(redisRestart + ","); }
    if (redisStop != null) { sb.append("redisStop:"); sb.append(redisStop + ","); }
    if (remoteCluster != null) { sb.append("remoteCluster:"); sb.append(remoteCluster + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (stressCpu != null) { sb.append("stressCpu:"); sb.append(stressCpu + ","); }
    if (stressMem != null) { sb.append("stressMem:"); sb.append(stressMem + ","); }
    if (userDefined != null) { sb.append("userDefined:"); sb.append(userDefined + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (vm != null) { sb.append("vm:"); sb.append(vm + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClockNested<N> extends ClockSpecFluent<ClockNested<N>> implements Nested<N>{
    ClockNested(ClockSpec item) {
      this.builder = new ClockSpecBuilder(this, item);
    }
    ClockSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withClock(builder.build());
    }
    
    public N endClock() {
      return and();
    }
    
  
  }
  public class DiskFillNested<N> extends DiskFillSpecFluent<DiskFillNested<N>> implements Nested<N>{
    DiskFillNested(DiskFillSpec item) {
      this.builder = new DiskFillSpecBuilder(this, item);
    }
    DiskFillSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskFill(builder.build());
    }
    
    public N endDiskFill() {
      return and();
    }
    
  
  }
  public class DiskReadPayloadNested<N> extends DiskPayloadSpecFluent<DiskReadPayloadNested<N>> implements Nested<N>{
    DiskReadPayloadNested(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskPayloadSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskReadPayload(builder.build());
    }
    
    public N endDiskReadPayload() {
      return and();
    }
    
  
  }
  public class DiskWritePayloadNested<N> extends DiskPayloadSpecFluent<DiskWritePayloadNested<N>> implements Nested<N>{
    DiskWritePayloadNested(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskPayloadSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withDiskWritePayload(builder.build());
    }
    
    public N endDiskWritePayload() {
      return and();
    }
    
  
  }
  public class FileAppendNested<N> extends FileAppendSpecFluent<FileAppendNested<N>> implements Nested<N>{
    FileAppendNested(FileAppendSpec item) {
      this.builder = new FileAppendSpecBuilder(this, item);
    }
    FileAppendSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileAppend(builder.build());
    }
    
    public N endFileAppend() {
      return and();
    }
    
  
  }
  public class FileCreateNested<N> extends FileCreateSpecFluent<FileCreateNested<N>> implements Nested<N>{
    FileCreateNested(FileCreateSpec item) {
      this.builder = new FileCreateSpecBuilder(this, item);
    }
    FileCreateSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileCreate(builder.build());
    }
    
    public N endFileCreate() {
      return and();
    }
    
  
  }
  public class FileDeleteNested<N> extends FileDeleteSpecFluent<FileDeleteNested<N>> implements Nested<N>{
    FileDeleteNested(FileDeleteSpec item) {
      this.builder = new FileDeleteSpecBuilder(this, item);
    }
    FileDeleteSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileDelete(builder.build());
    }
    
    public N endFileDelete() {
      return and();
    }
    
  
  }
  public class FileModifyNested<N> extends FileModifyPrivilegeSpecFluent<FileModifyNested<N>> implements Nested<N>{
    FileModifyNested(FileModifyPrivilegeSpec item) {
      this.builder = new FileModifyPrivilegeSpecBuilder(this, item);
    }
    FileModifyPrivilegeSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileModify(builder.build());
    }
    
    public N endFileModify() {
      return and();
    }
    
  
  }
  public class FileRenameNested<N> extends FileRenameSpecFluent<FileRenameNested<N>> implements Nested<N>{
    FileRenameNested(FileRenameSpec item) {
      this.builder = new FileRenameSpecBuilder(this, item);
    }
    FileRenameSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileRename(builder.build());
    }
    
    public N endFileRename() {
      return and();
    }
    
  
  }
  public class FileReplaceNested<N> extends FileReplaceSpecFluent<FileReplaceNested<N>> implements Nested<N>{
    FileReplaceNested(FileReplaceSpec item) {
      this.builder = new FileReplaceSpecBuilder(this, item);
    }
    FileReplaceSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withFileReplace(builder.build());
    }
    
    public N endFileReplace() {
      return and();
    }
    
  
  }
  public class HttpAbortNested<N> extends HTTPAbortSpecFluent<HttpAbortNested<N>> implements Nested<N>{
    HttpAbortNested(HTTPAbortSpec item) {
      this.builder = new HTTPAbortSpecBuilder(this, item);
    }
    HTTPAbortSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withHttpAbort(builder.build());
    }
    
    public N endHttpAbort() {
      return and();
    }
    
  
  }
  public class HttpConfigNested<N> extends HTTPConfigSpecFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfigSpec item) {
      this.builder = new HTTPConfigSpecBuilder(this, item);
    }
    HTTPConfigSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class HttpDelayNested<N> extends HTTPDelaySpecFluent<HttpDelayNested<N>> implements Nested<N>{
    HttpDelayNested(HTTPDelaySpec item) {
      this.builder = new HTTPDelaySpecBuilder(this, item);
    }
    HTTPDelaySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withHttpDelay(builder.build());
    }
    
    public N endHttpDelay() {
      return and();
    }
    
  
  }
  public class HttpRequestNested<N> extends HTTPRequestSpecFluent<HttpRequestNested<N>> implements Nested<N>{
    HttpRequestNested(HTTPRequestSpec item) {
      this.builder = new HTTPRequestSpecBuilder(this, item);
    }
    HTTPRequestSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withHttpRequest(builder.build());
    }
    
    public N endHttpRequest() {
      return and();
    }
    
  
  }
  public class JvmExceptionNested<N> extends JVMExceptionSpecFluent<JvmExceptionNested<N>> implements Nested<N>{
    JvmExceptionNested(JVMExceptionSpec item) {
      this.builder = new JVMExceptionSpecBuilder(this, item);
    }
    JVMExceptionSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmException(builder.build());
    }
    
    public N endJvmException() {
      return and();
    }
    
  
  }
  public class JvmGcNested<N> extends JVMGCSpecFluent<JvmGcNested<N>> implements Nested<N>{
    JvmGcNested(JVMGCSpec item) {
      this.builder = new JVMGCSpecBuilder(this, item);
    }
    JVMGCSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmGc(builder.build());
    }
    
    public N endJvmGc() {
      return and();
    }
    
  
  }
  public class JvmLatencyNested<N> extends JVMLatencySpecFluent<JvmLatencyNested<N>> implements Nested<N>{
    JvmLatencyNested(JVMLatencySpec item) {
      this.builder = new JVMLatencySpecBuilder(this, item);
    }
    JVMLatencySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmLatency(builder.build());
    }
    
    public N endJvmLatency() {
      return and();
    }
    
  
  }
  public class JvmMysqlNested<N> extends PMJVMMySQLSpecFluent<JvmMysqlNested<N>> implements Nested<N>{
    JvmMysqlNested(PMJVMMySQLSpec item) {
      this.builder = new PMJVMMySQLSpecBuilder(this, item);
    }
    PMJVMMySQLSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmMysql(builder.build());
    }
    
    public N endJvmMysql() {
      return and();
    }
    
  
  }
  public class JvmReturnNested<N> extends JVMReturnSpecFluent<JvmReturnNested<N>> implements Nested<N>{
    JvmReturnNested(JVMReturnSpec item) {
      this.builder = new JVMReturnSpecBuilder(this, item);
    }
    JVMReturnSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmReturn(builder.build());
    }
    
    public N endJvmReturn() {
      return and();
    }
    
  
  }
  public class JvmRuleDataNested<N> extends JVMRuleDataSpecFluent<JvmRuleDataNested<N>> implements Nested<N>{
    JvmRuleDataNested(JVMRuleDataSpec item) {
      this.builder = new JVMRuleDataSpecBuilder(this, item);
    }
    JVMRuleDataSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmRuleData(builder.build());
    }
    
    public N endJvmRuleData() {
      return and();
    }
    
  
  }
  public class JvmStressNested<N> extends JVMStressSpecFluent<JvmStressNested<N>> implements Nested<N>{
    JvmStressNested(JVMStressSpec item) {
      this.builder = new JVMStressSpecBuilder(this, item);
    }
    JVMStressSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withJvmStress(builder.build());
    }
    
    public N endJvmStress() {
      return and();
    }
    
  
  }
  public class KafkaFillNested<N> extends KafkaFillSpecFluent<KafkaFillNested<N>> implements Nested<N>{
    KafkaFillNested(KafkaFillSpec item) {
      this.builder = new KafkaFillSpecBuilder(this, item);
    }
    KafkaFillSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withKafkaFill(builder.build());
    }
    
    public N endKafkaFill() {
      return and();
    }
    
  
  }
  public class KafkaFloodNested<N> extends KafkaFloodSpecFluent<KafkaFloodNested<N>> implements Nested<N>{
    KafkaFloodNested(KafkaFloodSpec item) {
      this.builder = new KafkaFloodSpecBuilder(this, item);
    }
    KafkaFloodSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withKafkaFlood(builder.build());
    }
    
    public N endKafkaFlood() {
      return and();
    }
    
  
  }
  public class KafkaIoNested<N> extends KafkaIOSpecFluent<KafkaIoNested<N>> implements Nested<N>{
    KafkaIoNested(KafkaIOSpec item) {
      this.builder = new KafkaIOSpecBuilder(this, item);
    }
    KafkaIOSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withKafkaIo(builder.build());
    }
    
    public N endKafkaIo() {
      return and();
    }
    
  
  }
  public class NetworkBandwidthNested<N> extends NetworkBandwidthSpecFluent<NetworkBandwidthNested<N>> implements Nested<N>{
    NetworkBandwidthNested(NetworkBandwidthSpec item) {
      this.builder = new NetworkBandwidthSpecBuilder(this, item);
    }
    NetworkBandwidthSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkBandwidth(builder.build());
    }
    
    public N endNetworkBandwidth() {
      return and();
    }
    
  
  }
  public class NetworkCorruptNested<N> extends NetworkCorruptSpecFluent<NetworkCorruptNested<N>> implements Nested<N>{
    NetworkCorruptNested(NetworkCorruptSpec item) {
      this.builder = new NetworkCorruptSpecBuilder(this, item);
    }
    NetworkCorruptSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkCorrupt(builder.build());
    }
    
    public N endNetworkCorrupt() {
      return and();
    }
    
  
  }
  public class NetworkDelayNested<N> extends NetworkDelaySpecFluent<NetworkDelayNested<N>> implements Nested<N>{
    NetworkDelayNested(NetworkDelaySpec item) {
      this.builder = new NetworkDelaySpecBuilder(this, item);
    }
    NetworkDelaySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDelay(builder.build());
    }
    
    public N endNetworkDelay() {
      return and();
    }
    
  
  }
  public class NetworkDnsNested<N> extends NetworkDNSSpecFluent<NetworkDnsNested<N>> implements Nested<N>{
    NetworkDnsNested(NetworkDNSSpec item) {
      this.builder = new NetworkDNSSpecBuilder(this, item);
    }
    NetworkDNSSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDns(builder.build());
    }
    
    public N endNetworkDns() {
      return and();
    }
    
  
  }
  public class NetworkDownNested<N> extends NetworkDownSpecFluent<NetworkDownNested<N>> implements Nested<N>{
    NetworkDownNested(NetworkDownSpec item) {
      this.builder = new NetworkDownSpecBuilder(this, item);
    }
    NetworkDownSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDown(builder.build());
    }
    
    public N endNetworkDown() {
      return and();
    }
    
  
  }
  public class NetworkDuplicateNested<N> extends NetworkDuplicateSpecFluent<NetworkDuplicateNested<N>> implements Nested<N>{
    NetworkDuplicateNested(NetworkDuplicateSpec item) {
      this.builder = new NetworkDuplicateSpecBuilder(this, item);
    }
    NetworkDuplicateSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkDuplicate(builder.build());
    }
    
    public N endNetworkDuplicate() {
      return and();
    }
    
  
  }
  public class NetworkFloodNested<N> extends NetworkFloodSpecFluent<NetworkFloodNested<N>> implements Nested<N>{
    NetworkFloodNested(NetworkFloodSpec item) {
      this.builder = new NetworkFloodSpecBuilder(this, item);
    }
    NetworkFloodSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkFlood(builder.build());
    }
    
    public N endNetworkFlood() {
      return and();
    }
    
  
  }
  public class NetworkLossNested<N> extends NetworkLossSpecFluent<NetworkLossNested<N>> implements Nested<N>{
    NetworkLossNested(NetworkLossSpec item) {
      this.builder = new NetworkLossSpecBuilder(this, item);
    }
    NetworkLossSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkLoss(builder.build());
    }
    
    public N endNetworkLoss() {
      return and();
    }
    
  
  }
  public class NetworkPartitionNested<N> extends NetworkPartitionSpecFluent<NetworkPartitionNested<N>> implements Nested<N>{
    NetworkPartitionNested(NetworkPartitionSpec item) {
      this.builder = new NetworkPartitionSpecBuilder(this, item);
    }
    NetworkPartitionSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withNetworkPartition(builder.build());
    }
    
    public N endNetworkPartition() {
      return and();
    }
    
  
  }
  public class ProcessNested<N> extends ProcessSpecFluent<ProcessNested<N>> implements Nested<N>{
    ProcessNested(ProcessSpec item) {
      this.builder = new ProcessSpecBuilder(this, item);
    }
    ProcessSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withProcess(builder.build());
    }
    
    public N endProcess() {
      return and();
    }
    
  
  }
  public class RedisCacheLimitNested<N> extends RedisCacheLimitSpecFluent<RedisCacheLimitNested<N>> implements Nested<N>{
    RedisCacheLimitNested(RedisCacheLimitSpec item) {
      this.builder = new RedisCacheLimitSpecBuilder(this, item);
    }
    RedisCacheLimitSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withRedisCacheLimit(builder.build());
    }
    
    public N endRedisCacheLimit() {
      return and();
    }
    
  
  }
  public class RedisExpirationNested<N> extends RedisExpirationSpecFluent<RedisExpirationNested<N>> implements Nested<N>{
    RedisExpirationNested(RedisExpirationSpec item) {
      this.builder = new RedisExpirationSpecBuilder(this, item);
    }
    RedisExpirationSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withRedisExpiration(builder.build());
    }
    
    public N endRedisExpiration() {
      return and();
    }
    
  
  }
  public class RedisPenetrationNested<N> extends RedisPenetrationSpecFluent<RedisPenetrationNested<N>> implements Nested<N>{
    RedisPenetrationNested(RedisPenetrationSpec item) {
      this.builder = new RedisPenetrationSpecBuilder(this, item);
    }
    RedisPenetrationSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withRedisPenetration(builder.build());
    }
    
    public N endRedisPenetration() {
      return and();
    }
    
  
  }
  public class RedisRestartNested<N> extends RedisSentinelRestartSpecFluent<RedisRestartNested<N>> implements Nested<N>{
    RedisRestartNested(RedisSentinelRestartSpec item) {
      this.builder = new RedisSentinelRestartSpecBuilder(this, item);
    }
    RedisSentinelRestartSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withRedisRestart(builder.build());
    }
    
    public N endRedisRestart() {
      return and();
    }
    
  
  }
  public class RedisStopNested<N> extends RedisSentinelStopSpecFluent<RedisStopNested<N>> implements Nested<N>{
    RedisStopNested(RedisSentinelStopSpec item) {
      this.builder = new RedisSentinelStopSpecBuilder(this, item);
    }
    RedisSentinelStopSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withRedisStop(builder.build());
    }
    
    public N endRedisStop() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends PhysicalMachineSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PhysicalMachineSelectorSpec item) {
      this.builder = new PhysicalMachineSelectorSpecBuilder(this, item);
    }
    PhysicalMachineSelectorSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class StressCpuNested<N> extends StressCPUSpecFluent<StressCpuNested<N>> implements Nested<N>{
    StressCpuNested(StressCPUSpec item) {
      this.builder = new StressCPUSpecBuilder(this, item);
    }
    StressCPUSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withStressCpu(builder.build());
    }
    
    public N endStressCpu() {
      return and();
    }
    
  
  }
  public class StressMemNested<N> extends StressMemorySpecFluent<StressMemNested<N>> implements Nested<N>{
    StressMemNested(StressMemorySpec item) {
      this.builder = new StressMemorySpecBuilder(this, item);
    }
    StressMemorySpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withStressMem(builder.build());
    }
    
    public N endStressMem() {
      return and();
    }
    
  
  }
  public class UserDefinedNested<N> extends UserDefinedSpecFluent<UserDefinedNested<N>> implements Nested<N>{
    UserDefinedNested(UserDefinedSpec item) {
      this.builder = new UserDefinedSpecBuilder(this, item);
    }
    UserDefinedSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withUserDefined(builder.build());
    }
    
    public N endUserDefined() {
      return and();
    }
    
  
  }
  public class VmNested<N> extends VMSpecFluent<VmNested<N>> implements Nested<N>{
    VmNested(VMSpec item) {
      this.builder = new VMSpecBuilder(this, item);
    }
    VMSpecBuilder builder;
    
    public N and() {
      return (N) PhysicalMachineChaosSpecFluent.this.withVm(builder.build());
    }
    
    public N endVm() {
      return and();
    }
    
  
  }

}