package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPartitionSpecBuilder extends NetworkPartitionSpecFluent<NetworkPartitionSpecBuilder> implements VisitableBuilder<NetworkPartitionSpec,NetworkPartitionSpecBuilder>{
  public NetworkPartitionSpecBuilder() {
    this(new NetworkPartitionSpec());
  }
  
  public NetworkPartitionSpecBuilder(NetworkPartitionSpecFluent<?> fluent) {
    this(fluent, new NetworkPartitionSpec());
  }
  
  public NetworkPartitionSpecBuilder(NetworkPartitionSpecFluent<?> fluent,NetworkPartitionSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPartitionSpecBuilder(NetworkPartitionSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPartitionSpecFluent<?> fluent;
  
  public NetworkPartitionSpec build() {
    NetworkPartitionSpec buildable = new NetworkPartitionSpec(fluent.getAcceptTcpFlags(),fluent.getDevice(),fluent.getDirection(),fluent.getHostname(),fluent.getIpAddress(),fluent.getIpProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}