package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDownSpecBuilder extends NetworkDownSpecFluent<NetworkDownSpecBuilder> implements VisitableBuilder<NetworkDownSpec,NetworkDownSpecBuilder>{
  public NetworkDownSpecBuilder() {
    this(new NetworkDownSpec());
  }
  
  public NetworkDownSpecBuilder(NetworkDownSpecFluent<?> fluent) {
    this(fluent, new NetworkDownSpec());
  }
  
  public NetworkDownSpecBuilder(NetworkDownSpecFluent<?> fluent,NetworkDownSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDownSpecBuilder(NetworkDownSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDownSpecFluent<?> fluent;
  
  public NetworkDownSpec build() {
    NetworkDownSpec buildable = new NetworkDownSpec(fluent.getDevice(),fluent.getDuration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}