package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDNSSpecFluent<A extends NetworkDNSSpecFluent<A>> extends BaseFluent<A>{
  public NetworkDNSSpecFluent() {
  }
  
  public NetworkDNSSpecFluent(NetworkDNSSpec instance) {
    this.copyInstance(instance);
  }
  private String dnsDomainName;
  private String dnsIp;
  private String dnsServer;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDNSSpec instance) {
    instance = (instance != null ? instance : new NetworkDNSSpec());
    if (instance != null) {
          this.withDnsDomainName(instance.getDnsDomainName());
          this.withDnsIp(instance.getDnsIp());
          this.withDnsServer(instance.getDnsServer());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDnsDomainName() {
    return this.dnsDomainName;
  }
  
  public A withDnsDomainName(String dnsDomainName) {
    this.dnsDomainName = dnsDomainName;
    return (A) this;
  }
  
  public boolean hasDnsDomainName() {
    return this.dnsDomainName != null;
  }
  
  public String getDnsIp() {
    return this.dnsIp;
  }
  
  public A withDnsIp(String dnsIp) {
    this.dnsIp = dnsIp;
    return (A) this;
  }
  
  public boolean hasDnsIp() {
    return this.dnsIp != null;
  }
  
  public String getDnsServer() {
    return this.dnsServer;
  }
  
  public A withDnsServer(String dnsServer) {
    this.dnsServer = dnsServer;
    return (A) this;
  }
  
  public boolean hasDnsServer() {
    return this.dnsServer != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDNSSpecFluent that = (NetworkDNSSpecFluent) o;
    if (!java.util.Objects.equals(dnsDomainName, that.dnsDomainName)) return false;
    if (!java.util.Objects.equals(dnsIp, that.dnsIp)) return false;
    if (!java.util.Objects.equals(dnsServer, that.dnsServer)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dnsDomainName,  dnsIp,  dnsServer,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsDomainName != null) { sb.append("dnsDomainName:"); sb.append(dnsDomainName + ","); }
    if (dnsIp != null) { sb.append("dnsIp:"); sb.append(dnsIp + ","); }
    if (dnsServer != null) { sb.append("dnsServer:"); sb.append(dnsServer + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}