package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JVMStressSpecBuilder extends JVMStressSpecFluent<JVMStressSpecBuilder> implements VisitableBuilder<JVMStressSpec,JVMStressSpecBuilder>{
  public JVMStressSpecBuilder() {
    this(new JVMStressSpec());
  }
  
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent) {
    this(fluent, new JVMStressSpec());
  }
  
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent,JVMStressSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JVMStressSpecBuilder(JVMStressSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JVMStressSpecFluent<?> fluent;
  
  public JVMStressSpec build() {
    JVMStressSpec buildable = new JVMStressSpec(fluent.getCpuCount(),fluent.getMemType(),fluent.getPid(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}