package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPStatusCheckFluent<A extends HTTPStatusCheckFluent<A>> extends BaseFluent<A>{
  public HTTPStatusCheckFluent() {
  }
  
  public HTTPStatusCheckFluent(HTTPStatusCheck instance) {
    this.copyInstance(instance);
  }
  private String body;
  private HTTPCriteriaBuilder criteria;
  private Map<String,List<String>> headers;
  private String method;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPStatusCheck instance) {
    instance = (instance != null ? instance : new HTTPStatusCheck());
    if (instance != null) {
          this.withBody(instance.getBody());
          this.withCriteria(instance.getCriteria());
          this.withHeaders(instance.getHeaders());
          this.withMethod(instance.getMethod());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBody() {
    return this.body;
  }
  
  public A withBody(String body) {
    this.body = body;
    return (A) this;
  }
  
  public boolean hasBody() {
    return this.body != null;
  }
  
  public HTTPCriteria buildCriteria() {
    return this.criteria != null ? this.criteria.build() : null;
  }
  
  public A withCriteria(HTTPCriteria criteria) {
    this._visitables.remove("criteria");
    if (criteria != null) {
        this.criteria = new HTTPCriteriaBuilder(criteria);
        this._visitables.get("criteria").add(this.criteria);
    } else {
        this.criteria = null;
        this._visitables.get("criteria").remove(this.criteria);
    }
    return (A) this;
  }
  
  public boolean hasCriteria() {
    return this.criteria != null;
  }
  
  public A withNewCriteria(String statusCode) {
    return (A)withCriteria(new HTTPCriteria(statusCode));
  }
  
  public CriteriaNested<A> withNewCriteria() {
    return new CriteriaNested(null);
  }
  
  public CriteriaNested<A> withNewCriteriaLike(HTTPCriteria item) {
    return new CriteriaNested(item);
  }
  
  public CriteriaNested<A> editCriteria() {
    return withNewCriteriaLike(java.util.Optional.ofNullable(buildCriteria()).orElse(null));
  }
  
  public CriteriaNested<A> editOrNewCriteria() {
    return withNewCriteriaLike(java.util.Optional.ofNullable(buildCriteria()).orElse(new HTTPCriteriaBuilder().build()));
  }
  
  public CriteriaNested<A> editOrNewCriteriaLike(HTTPCriteria item) {
    return withNewCriteriaLike(java.util.Optional.ofNullable(buildCriteria()).orElse(item));
  }
  
  public A addToHeaders(String key,List<String> value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  
  public A addToHeaders(Map<String,List<String>> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  
  public A removeFromHeaders(Map<String,List<String>> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<String>> getHeaders() {
    return this.headers;
  }
  
  public <K,V>A withHeaders(Map<String,List<String>> headers) {
    if (headers == null) {
      this.headers = null;
    } else {
      this.headers = new LinkedHashMap(headers);
    }
    return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public String getMethod() {
    return this.method;
  }
  
  public A withMethod(String method) {
    this.method = method;
    return (A) this;
  }
  
  public boolean hasMethod() {
    return this.method != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPStatusCheckFluent that = (HTTPStatusCheckFluent) o;
    if (!java.util.Objects.equals(body, that.body)) return false;
    if (!java.util.Objects.equals(criteria, that.criteria)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(method, that.method)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(body,  criteria,  headers,  method,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (body != null) { sb.append("body:"); sb.append(body + ","); }
    if (criteria != null) { sb.append("criteria:"); sb.append(criteria + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CriteriaNested<N> extends HTTPCriteriaFluent<CriteriaNested<N>> implements Nested<N>{
    CriteriaNested(HTTPCriteria item) {
      this.builder = new HTTPCriteriaBuilder(this, item);
    }
    HTTPCriteriaBuilder builder;
    
    public N and() {
      return (N) HTTPStatusCheckFluent.this.withCriteria(builder.build());
    }
    
    public N endCriteria() {
      return and();
    }
    
  
  }

}