package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPCommonSpecFluent<A extends HTTPCommonSpecFluent<A>> extends BaseFluent<A>{
  public HTTPCommonSpecFluent() {
  }
  
  public HTTPCommonSpecFluent(HTTPCommonSpec instance) {
    this.copyInstance(instance);
  }
  private String code;
  private String method;
  private String path;
  private Integer port;
  private List<Integer> proxyPorts = new ArrayList<Integer>();
  private String target;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPCommonSpec instance) {
    instance = (instance != null ? instance : new HTTPCommonSpec());
    if (instance != null) {
          this.withCode(instance.getCode());
          this.withMethod(instance.getMethod());
          this.withPath(instance.getPath());
          this.withPort(instance.getPort());
          this.withProxyPorts(instance.getProxyPorts());
          this.withTarget(instance.getTarget());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCode() {
    return this.code;
  }
  
  public A withCode(String code) {
    this.code = code;
    return (A) this;
  }
  
  public boolean hasCode() {
    return this.code != null;
  }
  
  public String getMethod() {
    return this.method;
  }
  
  public A withMethod(String method) {
    this.method = method;
    return (A) this;
  }
  
  public boolean hasMethod() {
    return this.method != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A addToProxyPorts(int index,Integer item) {
    if (this.proxyPorts == null) {this.proxyPorts = new ArrayList<Integer>();}
    this.proxyPorts.add(index, item);
    return (A)this;
  }
  
  public A setToProxyPorts(int index,Integer item) {
    if (this.proxyPorts == null) {this.proxyPorts = new ArrayList<Integer>();}
    this.proxyPorts.set(index, item); return (A)this;
  }
  
  public A addToProxyPorts(java.lang.Integer... items) {
    if (this.proxyPorts == null) {this.proxyPorts = new ArrayList<Integer>();}
    for (Integer item : items) {this.proxyPorts.add(item);} return (A)this;
  }
  
  public A addAllToProxyPorts(Collection<Integer> items) {
    if (this.proxyPorts == null) {this.proxyPorts = new ArrayList<Integer>();}
    for (Integer item : items) {this.proxyPorts.add(item);} return (A)this;
  }
  
  public A removeFromProxyPorts(java.lang.Integer... items) {
    if (this.proxyPorts == null) return (A)this;
    for (Integer item : items) { this.proxyPorts.remove(item);} return (A)this;
  }
  
  public A removeAllFromProxyPorts(Collection<Integer> items) {
    if (this.proxyPorts == null) return (A)this;
    for (Integer item : items) { this.proxyPorts.remove(item);} return (A)this;
  }
  
  public List<Integer> getProxyPorts() {
    return this.proxyPorts;
  }
  
  public Integer getProxyPort(int index) {
    return this.proxyPorts.get(index);
  }
  
  public Integer getFirstProxyPort() {
    return this.proxyPorts.get(0);
  }
  
  public Integer getLastProxyPort() {
    return this.proxyPorts.get(proxyPorts.size() - 1);
  }
  
  public Integer getMatchingProxyPort(Predicate<Integer> predicate) {
      for (Integer item : proxyPorts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingProxyPort(Predicate<Integer> predicate) {
      for (Integer item : proxyPorts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withProxyPorts(List<Integer> proxyPorts) {
    if (proxyPorts != null) {
        this.proxyPorts = new ArrayList();
        for (Integer item : proxyPorts) {
          this.addToProxyPorts(item);
        }
    } else {
      this.proxyPorts = null;
    }
    return (A) this;
  }
  
  public A withProxyPorts(java.lang.Integer... proxyPorts) {
    if (this.proxyPorts != null) {
        this.proxyPorts.clear();
        _visitables.remove("proxyPorts");
    }
    if (proxyPorts != null) {
      for (Integer item : proxyPorts) {
        this.addToProxyPorts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasProxyPorts() {
    return this.proxyPorts != null && !this.proxyPorts.isEmpty();
  }
  
  public String getTarget() {
    return this.target;
  }
  
  public A withTarget(String target) {
    this.target = target;
    return (A) this;
  }
  
  public boolean hasTarget() {
    return this.target != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPCommonSpecFluent that = (HTTPCommonSpecFluent) o;
    if (!java.util.Objects.equals(code, that.code)) return false;
    if (!java.util.Objects.equals(method, that.method)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(proxyPorts, that.proxyPorts)) return false;
    if (!java.util.Objects.equals(target, that.target)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(code,  method,  path,  port,  proxyPorts,  target,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (code != null) { sb.append("code:"); sb.append(code + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyPorts != null && !proxyPorts.isEmpty()) { sb.append("proxyPorts:"); sb.append(proxyPorts + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}