
package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "method",
    "path",
    "port",
    "proxy_ports",
    "target"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class HTTPCommonSpec implements Editable<HTTPCommonSpecBuilder>, KubernetesResource
{

    @JsonProperty("code")
    private String code;
    @JsonProperty("method")
    private String method;
    @JsonProperty("path")
    private String path;
    @JsonProperty("port")
    private Integer port;
    @JsonProperty("proxy_ports")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Integer> proxyPorts = new ArrayList<>();
    @JsonProperty("target")
    private String target;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public HTTPCommonSpec() {
    }

    public HTTPCommonSpec(String code, String method, String path, Integer port, List<Integer> proxyPorts, String target) {
        super();
        this.code = code;
        this.method = method;
        this.path = path;
        this.port = port;
        this.proxyPorts = proxyPorts;
        this.target = target;
    }

    /**
     * Code is a rule to select target by http status code in response
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * Code is a rule to select target by http status code in response
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * HTTP method
     */
    @JsonProperty("method")
    public String getMethod() {
        return method;
    }

    /**
     * HTTP method
     */
    @JsonProperty("method")
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * Match path of Uri with wildcard matches
     */
    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    /**
     * Match path of Uri with wildcard matches
     */
    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * The TCP port that the target service listens on
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * The TCP port that the target service listens on
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * Composed with one of the port of HTTP connection, we will only attack HTTP connection with port inside proxy_ports
     */
    @JsonProperty("proxy_ports")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public List<Integer> getProxyPorts() {
        return proxyPorts;
    }

    /**
     * Composed with one of the port of HTTP connection, we will only attack HTTP connection with port inside proxy_ports
     */
    @JsonProperty("proxy_ports")
    public void setProxyPorts(List<Integer> proxyPorts) {
        this.proxyPorts = proxyPorts;
    }

    /**
     * HTTP target: Request or Response
     */
    @JsonProperty("target")
    public String getTarget() {
        return target;
    }

    /**
     * HTTP target: Request or Response
     */
    @JsonProperty("target")
    public void setTarget(String target) {
        this.target = target;
    }

    @JsonIgnore
    public HTTPCommonSpecBuilder edit() {
        return new HTTPCommonSpecBuilder(this);
    }

    @JsonIgnore
    public HTTPCommonSpecBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
