package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPSelectorFluent<A extends GCPSelectorFluent<A>> extends BaseFluent<A>{
  public GCPSelectorFluent() {
  }
  
  public GCPSelectorFluent(GCPSelector instance) {
    this.copyInstance(instance);
  }
  private List<String> deviceNames = new ArrayList<String>();
  private String instance;
  private String project;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPSelector instance) {
    instance = (instance != null ? instance : new GCPSelector());
    if (instance != null) {
          this.withDeviceNames(instance.getDeviceNames());
          this.withInstance(instance.getInstance());
          this.withProject(instance.getProject());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDeviceNames(int index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.add(index, item);
    return (A)this;
  }
  
  public A setToDeviceNames(int index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.set(index, item); return (A)this;
  }
  
  public A addToDeviceNames(java.lang.String... items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  
  public A addAllToDeviceNames(Collection<String> items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  
  public A removeFromDeviceNames(java.lang.String... items) {
    if (this.deviceNames == null) return (A)this;
    for (String item : items) { this.deviceNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromDeviceNames(Collection<String> items) {
    if (this.deviceNames == null) return (A)this;
    for (String item : items) { this.deviceNames.remove(item);} return (A)this;
  }
  
  public List<String> getDeviceNames() {
    return this.deviceNames;
  }
  
  public String getDeviceName(int index) {
    return this.deviceNames.get(index);
  }
  
  public String getFirstDeviceName() {
    return this.deviceNames.get(0);
  }
  
  public String getLastDeviceName() {
    return this.deviceNames.get(deviceNames.size() - 1);
  }
  
  public String getMatchingDeviceName(Predicate<String> predicate) {
      for (String item : deviceNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDeviceName(Predicate<String> predicate) {
      for (String item : deviceNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDeviceNames(List<String> deviceNames) {
    if (deviceNames != null) {
        this.deviceNames = new ArrayList();
        for (String item : deviceNames) {
          this.addToDeviceNames(item);
        }
    } else {
      this.deviceNames = null;
    }
    return (A) this;
  }
  
  public A withDeviceNames(java.lang.String... deviceNames) {
    if (this.deviceNames != null) {
        this.deviceNames.clear();
        _visitables.remove("deviceNames");
    }
    if (deviceNames != null) {
      for (String item : deviceNames) {
        this.addToDeviceNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDeviceNames() {
    return this.deviceNames != null && !this.deviceNames.isEmpty();
  }
  
  public String getInstance() {
    return this.instance;
  }
  
  public A withInstance(String instance) {
    this.instance = instance;
    return (A) this;
  }
  
  public boolean hasInstance() {
    return this.instance != null;
  }
  
  public String getProject() {
    return this.project;
  }
  
  public A withProject(String project) {
    this.project = project;
    return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPSelectorFluent that = (GCPSelectorFluent) o;
    if (!java.util.Objects.equals(deviceNames, that.deviceNames)) return false;
    if (!java.util.Objects.equals(instance, that.instance)) return false;
    if (!java.util.Objects.equals(project, that.project)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deviceNames,  instance,  project,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deviceNames != null && !deviceNames.isEmpty()) { sb.append("deviceNames:"); sb.append(deviceNames + ","); }
    if (instance != null) { sb.append("instance:"); sb.append(instance + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}