package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GCPSelectorBuilder extends GCPSelectorFluent<GCPSelectorBuilder> implements VisitableBuilder<GCPSelector,GCPSelectorBuilder>{
  public GCPSelectorBuilder() {
    this(new GCPSelector());
  }
  
  public GCPSelectorBuilder(GCPSelectorFluent<?> fluent) {
    this(fluent, new GCPSelector());
  }
  
  public GCPSelectorBuilder(GCPSelectorFluent<?> fluent,GCPSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GCPSelectorBuilder(GCPSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GCPSelectorFluent<?> fluent;
  
  public GCPSelector build() {
    GCPSelector buildable = new GCPSelector(fluent.getDeviceNames(),fluent.getInstance(),fluent.getProject(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}