package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPChaosSpecFluent<A extends GCPChaosSpecFluent<A>> extends BaseFluent<A>{
  public GCPChaosSpecFluent() {
  }
  
  public GCPChaosSpecFluent(GCPChaosSpec instance) {
    this.copyInstance(instance);
  }
  private String action;
  private List<String> deviceNames = new ArrayList<String>();
  private String duration;
  private String instance;
  private String project;
  private String remoteCluster;
  private String secretName;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPChaosSpec instance) {
    instance = (instance != null ? instance : new GCPChaosSpec());
    if (instance != null) {
          this.withAction(instance.getAction());
          this.withDeviceNames(instance.getDeviceNames());
          this.withDuration(instance.getDuration());
          this.withInstance(instance.getInstance());
          this.withProject(instance.getProject());
          this.withRemoteCluster(instance.getRemoteCluster());
          this.withSecretName(instance.getSecretName());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action = action;
    return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public A addToDeviceNames(int index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.add(index, item);
    return (A)this;
  }
  
  public A setToDeviceNames(int index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.set(index, item); return (A)this;
  }
  
  public A addToDeviceNames(java.lang.String... items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  
  public A addAllToDeviceNames(Collection<String> items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  
  public A removeFromDeviceNames(java.lang.String... items) {
    if (this.deviceNames == null) return (A)this;
    for (String item : items) { this.deviceNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromDeviceNames(Collection<String> items) {
    if (this.deviceNames == null) return (A)this;
    for (String item : items) { this.deviceNames.remove(item);} return (A)this;
  }
  
  public List<String> getDeviceNames() {
    return this.deviceNames;
  }
  
  public String getDeviceName(int index) {
    return this.deviceNames.get(index);
  }
  
  public String getFirstDeviceName() {
    return this.deviceNames.get(0);
  }
  
  public String getLastDeviceName() {
    return this.deviceNames.get(deviceNames.size() - 1);
  }
  
  public String getMatchingDeviceName(Predicate<String> predicate) {
      for (String item : deviceNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDeviceName(Predicate<String> predicate) {
      for (String item : deviceNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDeviceNames(List<String> deviceNames) {
    if (deviceNames != null) {
        this.deviceNames = new ArrayList();
        for (String item : deviceNames) {
          this.addToDeviceNames(item);
        }
    } else {
      this.deviceNames = null;
    }
    return (A) this;
  }
  
  public A withDeviceNames(java.lang.String... deviceNames) {
    if (this.deviceNames != null) {
        this.deviceNames.clear();
        _visitables.remove("deviceNames");
    }
    if (deviceNames != null) {
      for (String item : deviceNames) {
        this.addToDeviceNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDeviceNames() {
    return this.deviceNames != null && !this.deviceNames.isEmpty();
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public String getInstance() {
    return this.instance;
  }
  
  public A withInstance(String instance) {
    this.instance = instance;
    return (A) this;
  }
  
  public boolean hasInstance() {
    return this.instance != null;
  }
  
  public String getProject() {
    return this.project;
  }
  
  public A withProject(String project) {
    this.project = project;
    return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public String getRemoteCluster() {
    return this.remoteCluster;
  }
  
  public A withRemoteCluster(String remoteCluster) {
    this.remoteCluster = remoteCluster;
    return (A) this;
  }
  
  public boolean hasRemoteCluster() {
    return this.remoteCluster != null;
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPChaosSpecFluent that = (GCPChaosSpecFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
    if (!java.util.Objects.equals(deviceNames, that.deviceNames)) return false;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(instance, that.instance)) return false;
    if (!java.util.Objects.equals(project, that.project)) return false;
    if (!java.util.Objects.equals(remoteCluster, that.remoteCluster)) return false;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  deviceNames,  duration,  instance,  project,  remoteCluster,  secretName,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (deviceNames != null && !deviceNames.isEmpty()) { sb.append("deviceNames:"); sb.append(deviceNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (instance != null) { sb.append("instance:"); sb.append(instance + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (remoteCluster != null) { sb.append("remoteCluster:"); sb.append(remoteCluster + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}