package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FilterFluent<A extends FilterFluent<A>> extends BaseFluent<A>{
  public FilterFluent() {
  }
  
  public FilterFluent(Filter instance) {
    this.copyInstance(instance);
  }
  private List<String> methods = new ArrayList<String>();
  private String path;
  private Integer percent;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Filter instance) {
    instance = (instance != null ? instance : new Filter());
    if (instance != null) {
          this.withMethods(instance.getMethods());
          this.withPath(instance.getPath());
          this.withPercent(instance.getPercent());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  
  public A setToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  
  public A removeFromMethods(java.lang.String... items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  
  public A removeAllFromMethods(Collection<String> items) {
    if (this.methods == null) return (A)this;
    for (String item : items) { this.methods.remove(item);} return (A)this;
  }
  
  public List<String> getMethods() {
    return this.methods;
  }
  
  public String getMethod(int index) {
    return this.methods.get(index);
  }
  
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  
  public String getMatchingMethod(Predicate<String> predicate) {
      for (String item : methods) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMethod(Predicate<String> predicate) {
      for (String item : methods) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMethods(List<String> methods) {
    if (methods != null) {
        this.methods = new ArrayList();
        for (String item : methods) {
          this.addToMethods(item);
        }
    } else {
      this.methods = null;
    }
    return (A) this;
  }
  
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {
        this.methods.clear();
        _visitables.remove("methods");
    }
    if (methods != null) {
      for (String item : methods) {
        this.addToMethods(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMethods() {
    return this.methods != null && !this.methods.isEmpty();
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent = percent;
    return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FilterFluent that = (FilterFluent) o;
    if (!java.util.Objects.equals(methods, that.methods)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(percent, that.percent)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(methods,  path,  percent,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}