package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileReplaceSpecBuilder extends FileReplaceSpecFluent<FileReplaceSpecBuilder> implements VisitableBuilder<FileReplaceSpec,FileReplaceSpecBuilder>{
  public FileReplaceSpecBuilder() {
    this(new FileReplaceSpec());
  }
  
  public FileReplaceSpecBuilder(FileReplaceSpecFluent<?> fluent) {
    this(fluent, new FileReplaceSpec());
  }
  
  public FileReplaceSpecBuilder(FileReplaceSpecFluent<?> fluent,FileReplaceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileReplaceSpecBuilder(FileReplaceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileReplaceSpecFluent<?> fluent;
  
  public FileReplaceSpec build() {
    FileReplaceSpec buildable = new FileReplaceSpec(fluent.getDestString(),fluent.getFileName(),fluent.getLine(),fluent.getOriginString());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}