package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileRenameSpecBuilder extends FileRenameSpecFluent<FileRenameSpecBuilder> implements VisitableBuilder<FileRenameSpec,FileRenameSpecBuilder>{
  public FileRenameSpecBuilder() {
    this(new FileRenameSpec());
  }
  
  public FileRenameSpecBuilder(FileRenameSpecFluent<?> fluent) {
    this(fluent, new FileRenameSpec());
  }
  
  public FileRenameSpecBuilder(FileRenameSpecFluent<?> fluent,FileRenameSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileRenameSpecBuilder(FileRenameSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileRenameSpecFluent<?> fluent;
  
  public FileRenameSpec build() {
    FileRenameSpec buildable = new FileRenameSpec(fluent.getDestFile(),fluent.getSourceFile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}