package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileCreateSpecBuilder extends FileCreateSpecFluent<FileCreateSpecBuilder> implements VisitableBuilder<FileCreateSpec,FileCreateSpecBuilder>{
  public FileCreateSpecBuilder() {
    this(new FileCreateSpec());
  }
  
  public FileCreateSpecBuilder(FileCreateSpecFluent<?> fluent) {
    this(fluent, new FileCreateSpec());
  }
  
  public FileCreateSpecBuilder(FileCreateSpecFluent<?> fluent,FileCreateSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileCreateSpecBuilder(FileCreateSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileCreateSpecFluent<?> fluent;
  
  public FileCreateSpec build() {
    FileCreateSpec buildable = new FileCreateSpec(fluent.getDirName(),fluent.getFileName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}