package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DiskFileSpecBuilder extends DiskFileSpecFluent<DiskFileSpecBuilder> implements VisitableBuilder<DiskFileSpec,DiskFileSpecBuilder>{
  public DiskFileSpecBuilder() {
    this(new DiskFileSpec());
  }
  
  public DiskFileSpecBuilder(DiskFileSpecFluent<?> fluent) {
    this(fluent, new DiskFileSpec());
  }
  
  public DiskFileSpecBuilder(DiskFileSpecFluent<?> fluent,DiskFileSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DiskFileSpecBuilder(DiskFileSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DiskFileSpecFluent<?> fluent;
  
  public DiskFileSpec build() {
    DiskFileSpec buildable = new DiskFileSpec(fluent.getPath(),fluent.getSize());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}