package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConditionalBranchesStatusFluent<A extends ConditionalBranchesStatusFluent<A>> extends BaseFluent<A>{
  public ConditionalBranchesStatusFluent() {
  }
  
  public ConditionalBranchesStatusFluent(ConditionalBranchesStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ConditionalBranchStatusBuilder> branches = new ArrayList<ConditionalBranchStatusBuilder>();
  private List<String> context = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConditionalBranchesStatus instance) {
    instance = (instance != null ? instance : new ConditionalBranchesStatus());
    if (instance != null) {
          this.withBranches(instance.getBranches());
          this.withContext(instance.getContext());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBranches(int index,ConditionalBranchStatus item) {
    if (this.branches == null) {this.branches = new ArrayList<ConditionalBranchStatusBuilder>();}
    ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);
    if (index < 0 || index >= branches.size()) {
        _visitables.get("branches").add(builder);
        branches.add(builder);
    } else {
        _visitables.get("branches").add(builder);
        branches.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToBranches(int index,ConditionalBranchStatus item) {
    if (this.branches == null) {this.branches = new ArrayList<ConditionalBranchStatusBuilder>();}
    ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);
    if (index < 0 || index >= branches.size()) {
        _visitables.get("branches").add(builder);
        branches.add(builder);
    } else {
        _visitables.get("branches").add(builder);
        branches.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToBranches(io.fabric8.chaosmesh.v1alpha1.ConditionalBranchStatus... items) {
    if (this.branches == null) {this.branches = new ArrayList<ConditionalBranchStatusBuilder>();}
    for (ConditionalBranchStatus item : items) {ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  
  public A addAllToBranches(Collection<ConditionalBranchStatus> items) {
    if (this.branches == null) {this.branches = new ArrayList<ConditionalBranchStatusBuilder>();}
    for (ConditionalBranchStatus item : items) {ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  
  public A removeFromBranches(io.fabric8.chaosmesh.v1alpha1.ConditionalBranchStatus... items) {
    if (this.branches == null) return (A)this;
    for (ConditionalBranchStatus item : items) {ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);_visitables.get("branches").remove(builder); this.branches.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBranches(Collection<ConditionalBranchStatus> items) {
    if (this.branches == null) return (A)this;
    for (ConditionalBranchStatus item : items) {ConditionalBranchStatusBuilder builder = new ConditionalBranchStatusBuilder(item);_visitables.get("branches").remove(builder); this.branches.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBranches(Predicate<ConditionalBranchStatusBuilder> predicate) {
    if (branches == null) return (A) this;
    final Iterator<ConditionalBranchStatusBuilder> each = branches.iterator();
    final List visitables = _visitables.get("branches");
    while (each.hasNext()) {
      ConditionalBranchStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ConditionalBranchStatus> buildBranches() {
    return this.branches != null ? build(branches) : null;
  }
  
  public ConditionalBranchStatus buildBranch(int index) {
    return this.branches.get(index).build();
  }
  
  public ConditionalBranchStatus buildFirstBranch() {
    return this.branches.get(0).build();
  }
  
  public ConditionalBranchStatus buildLastBranch() {
    return this.branches.get(branches.size() - 1).build();
  }
  
  public ConditionalBranchStatus buildMatchingBranch(Predicate<ConditionalBranchStatusBuilder> predicate) {
      for (ConditionalBranchStatusBuilder item : branches) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBranch(Predicate<ConditionalBranchStatusBuilder> predicate) {
      for (ConditionalBranchStatusBuilder item : branches) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBranches(List<ConditionalBranchStatus> branches) {
    if (this.branches != null) {
      this._visitables.get("branches").clear();
    }
    if (branches != null) {
        this.branches = new ArrayList();
        for (ConditionalBranchStatus item : branches) {
          this.addToBranches(item);
        }
    } else {
      this.branches = null;
    }
    return (A) this;
  }
  
  public A withBranches(io.fabric8.chaosmesh.v1alpha1.ConditionalBranchStatus... branches) {
    if (this.branches != null) {
        this.branches.clear();
        _visitables.remove("branches");
    }
    if (branches != null) {
      for (ConditionalBranchStatus item : branches) {
        this.addToBranches(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBranches() {
    return this.branches != null && !this.branches.isEmpty();
  }
  
  public A addNewBranch(String evaluationResult,String target) {
    return (A)addToBranches(new ConditionalBranchStatus(evaluationResult, target));
  }
  
  public BranchesNested<A> addNewBranch() {
    return new BranchesNested(-1, null);
  }
  
  public BranchesNested<A> addNewBranchLike(ConditionalBranchStatus item) {
    return new BranchesNested(-1, item);
  }
  
  public BranchesNested<A> setNewBranchLike(int index,ConditionalBranchStatus item) {
    return new BranchesNested(index, item);
  }
  
  public BranchesNested<A> editBranch(int index) {
    if (branches.size() <= index) throw new RuntimeException("Can't edit branches. Index exceeds size.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public BranchesNested<A> editFirstBranch() {
    if (branches.size() == 0) throw new RuntimeException("Can't edit first branches. The list is empty.");
    return setNewBranchLike(0, buildBranch(0));
  }
  
  public BranchesNested<A> editLastBranch() {
    int index = branches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last branches. The list is empty.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public BranchesNested<A> editMatchingBranch(Predicate<ConditionalBranchStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<branches.size();i++) { 
    if (predicate.test(branches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching branches. No match found.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  public A addToContext(int index,String item) {
    if (this.context == null) {this.context = new ArrayList<String>();}
    this.context.add(index, item);
    return (A)this;
  }
  
  public A setToContext(int index,String item) {
    if (this.context == null) {this.context = new ArrayList<String>();}
    this.context.set(index, item); return (A)this;
  }
  
  public A addToContext(java.lang.String... items) {
    if (this.context == null) {this.context = new ArrayList<String>();}
    for (String item : items) {this.context.add(item);} return (A)this;
  }
  
  public A addAllToContext(Collection<String> items) {
    if (this.context == null) {this.context = new ArrayList<String>();}
    for (String item : items) {this.context.add(item);} return (A)this;
  }
  
  public A removeFromContext(java.lang.String... items) {
    if (this.context == null) return (A)this;
    for (String item : items) { this.context.remove(item);} return (A)this;
  }
  
  public A removeAllFromContext(Collection<String> items) {
    if (this.context == null) return (A)this;
    for (String item : items) { this.context.remove(item);} return (A)this;
  }
  
  public List<String> getContext() {
    return this.context;
  }
  
  public String getContext(int index) {
    return this.context.get(index);
  }
  
  public String getFirstContext() {
    return this.context.get(0);
  }
  
  public String getLastContext() {
    return this.context.get(context.size() - 1);
  }
  
  public String getMatchingContext(Predicate<String> predicate) {
      for (String item : context) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingContext(Predicate<String> predicate) {
      for (String item : context) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContext(List<String> context) {
    if (context != null) {
        this.context = new ArrayList();
        for (String item : context) {
          this.addToContext(item);
        }
    } else {
      this.context = null;
    }
    return (A) this;
  }
  
  public A withContext(java.lang.String... context) {
    if (this.context != null) {
        this.context.clear();
        _visitables.remove("context");
    }
    if (context != null) {
      for (String item : context) {
        this.addToContext(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContext() {
    return this.context != null && !this.context.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConditionalBranchesStatusFluent that = (ConditionalBranchesStatusFluent) o;
    if (!java.util.Objects.equals(branches, that.branches)) return false;
    if (!java.util.Objects.equals(context, that.context)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(branches,  context,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (branches != null && !branches.isEmpty()) { sb.append("branches:"); sb.append(branches + ","); }
    if (context != null && !context.isEmpty()) { sb.append("context:"); sb.append(context + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BranchesNested<N> extends ConditionalBranchStatusFluent<BranchesNested<N>> implements Nested<N>{
    BranchesNested(int index,ConditionalBranchStatus item) {
      this.index = index;
      this.builder = new ConditionalBranchStatusBuilder(this, item);
    }
    ConditionalBranchStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ConditionalBranchesStatusFluent.this.setToBranches(index,builder.build());
    }
    
    public N endBranch() {
      return and();
    }
    
  
  }

}