package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CPUStressorBuilder extends CPUStressorFluent<CPUStressorBuilder> implements VisitableBuilder<CPUStressor,CPUStressorBuilder>{
  public CPUStressorBuilder() {
    this(new CPUStressor());
  }
  
  public CPUStressorBuilder(CPUStressorFluent<?> fluent) {
    this(fluent, new CPUStressor());
  }
  
  public CPUStressorBuilder(CPUStressorFluent<?> fluent,CPUStressor instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CPUStressorBuilder(CPUStressor instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CPUStressorFluent<?> fluent;
  
  public CPUStressor build() {
    CPUStressor buildable = new CPUStressor(fluent.getLoad(),fluent.getOptions(),fluent.getWorkers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}