package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureChaosListBuilder extends AzureChaosListFluent<AzureChaosListBuilder> implements VisitableBuilder<AzureChaosList,AzureChaosListBuilder>{
  public AzureChaosListBuilder() {
    this(new AzureChaosList());
  }
  
  public AzureChaosListBuilder(AzureChaosListFluent<?> fluent) {
    this(fluent, new AzureChaosList());
  }
  
  public AzureChaosListBuilder(AzureChaosListFluent<?> fluent,AzureChaosList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureChaosListBuilder(AzureChaosList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureChaosListFluent<?> fluent;
  
  public AzureChaosList build() {
    AzureChaosList buildable = new AzureChaosList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}