package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSChaosListBuilder extends AWSChaosListFluent<AWSChaosListBuilder> implements VisitableBuilder<AWSChaosList,AWSChaosListBuilder>{
  public AWSChaosListBuilder() {
    this(new AWSChaosList());
  }
  
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent) {
    this(fluent, new AWSChaosList());
  }
  
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent,AWSChaosList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSChaosListBuilder(AWSChaosList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSChaosListFluent<?> fluent;
  
  public AWSChaosList build() {
    AWSChaosList buildable = new AWSChaosList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}