/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.HTTPAbortSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPAbortSpecFluent<A extends HTTPAbortSpecFluent<A>>
extends BaseFluent<A> {
    private String code;
    private String method;
    private String path;
    private Integer port;
    private List<Integer> proxyPorts = new ArrayList<Integer>();
    private String target;
    private Map<String, Object> additionalProperties;

    public HTTPAbortSpecFluent() {
    }

    public HTTPAbortSpecFluent(HTTPAbortSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPAbortSpec instance) {
        HTTPAbortSpec hTTPAbortSpec = instance = instance != null ? instance : new HTTPAbortSpec();
        if (instance != null) {
            this.withCode(instance.getCode());
            this.withMethod(instance.getMethod());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withProxyPorts(instance.getProxyPorts());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCode() {
        return this.code;
    }

    public A withCode(String code) {
        this.code = code;
        return (A)((Object)this);
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public String getMethod() {
        return this.method;
    }

    public A withMethod(String method) {
        this.method = method;
        return (A)((Object)this);
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A addToProxyPorts(int index, Integer item) {
        if (this.proxyPorts == null) {
            this.proxyPorts = new ArrayList<Integer>();
        }
        this.proxyPorts.add(index, item);
        return (A)((Object)this);
    }

    public A setToProxyPorts(int index, Integer item) {
        if (this.proxyPorts == null) {
            this.proxyPorts = new ArrayList<Integer>();
        }
        this.proxyPorts.set(index, item);
        return (A)((Object)this);
    }

    public A addToProxyPorts(Integer ... items) {
        if (this.proxyPorts == null) {
            this.proxyPorts = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.proxyPorts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProxyPorts(Collection<Integer> items) {
        if (this.proxyPorts == null) {
            this.proxyPorts = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.proxyPorts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyPorts(Integer ... items) {
        if (this.proxyPorts == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.proxyPorts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProxyPorts(Collection<Integer> items) {
        if (this.proxyPorts == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.proxyPorts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getProxyPorts() {
        return this.proxyPorts;
    }

    public Integer getProxyPort(int index) {
        return this.proxyPorts.get(index);
    }

    public Integer getFirstProxyPort() {
        return this.proxyPorts.get(0);
    }

    public Integer getLastProxyPort() {
        return this.proxyPorts.get(this.proxyPorts.size() - 1);
    }

    public Integer getMatchingProxyPort(Predicate<Integer> predicate) {
        for (Integer item : this.proxyPorts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProxyPort(Predicate<Integer> predicate) {
        for (Integer item : this.proxyPorts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProxyPorts(List<Integer> proxyPorts) {
        if (proxyPorts != null) {
            this.proxyPorts = new ArrayList<Integer>();
            for (Integer item : proxyPorts) {
                this.addToProxyPorts(item);
            }
        } else {
            this.proxyPorts = null;
        }
        return (A)((Object)this);
    }

    public A withProxyPorts(Integer ... proxyPorts) {
        if (this.proxyPorts != null) {
            this.proxyPorts.clear();
            this._visitables.remove((Object)"proxyPorts");
        }
        if (proxyPorts != null) {
            for (Integer item : proxyPorts) {
                this.addToProxyPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProxyPorts() {
        return this.proxyPorts != null && !this.proxyPorts.isEmpty();
    }

    public String getTarget() {
        return this.target;
    }

    public A withTarget(String target) {
        this.target = target;
        return (A)((Object)this);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPAbortSpecFluent that = (HTTPAbortSpecFluent)((Object)o);
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.proxyPorts, that.proxyPorts)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.method, this.path, this.port, this.proxyPorts, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.code != null) {
            sb.append("code:");
            sb.append(this.code + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.proxyPorts != null && !this.proxyPorts.isEmpty()) {
            sb.append("proxyPorts:");
            sb.append(String.valueOf(this.proxyPorts) + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

