/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.GCPChaosSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GCPChaosSpecFluent<A extends GCPChaosSpecFluent<A>>
extends BaseFluent<A> {
    private String action;
    private List<String> deviceNames = new ArrayList<String>();
    private String duration;
    private String instance;
    private String project;
    private String remoteCluster;
    private String secretName;
    private String zone;
    private Map<String, Object> additionalProperties;

    public GCPChaosSpecFluent() {
    }

    public GCPChaosSpecFluent(GCPChaosSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPChaosSpec instance) {
        GCPChaosSpec gCPChaosSpec = instance = instance != null ? instance : new GCPChaosSpec();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withDeviceNames(instance.getDeviceNames());
            this.withDuration(instance.getDuration());
            this.withInstance(instance.getInstance());
            this.withProject(instance.getProject());
            this.withRemoteCluster(instance.getRemoteCluster());
            this.withSecretName(instance.getSecretName());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)((Object)this);
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public A addToDeviceNames(int index, String item) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        this.deviceNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDeviceNames(int index, String item) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        this.deviceNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDeviceNames(String ... items) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.deviceNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDeviceNames(Collection<String> items) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.deviceNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDeviceNames(String ... items) {
        if (this.deviceNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.deviceNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDeviceNames(Collection<String> items) {
        if (this.deviceNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.deviceNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDeviceNames() {
        return this.deviceNames;
    }

    public String getDeviceName(int index) {
        return this.deviceNames.get(index);
    }

    public String getFirstDeviceName() {
        return this.deviceNames.get(0);
    }

    public String getLastDeviceName() {
        return this.deviceNames.get(this.deviceNames.size() - 1);
    }

    public String getMatchingDeviceName(Predicate<String> predicate) {
        for (String item : this.deviceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDeviceName(Predicate<String> predicate) {
        for (String item : this.deviceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDeviceNames(List<String> deviceNames) {
        if (deviceNames != null) {
            this.deviceNames = new ArrayList<String>();
            for (String item : deviceNames) {
                this.addToDeviceNames(item);
            }
        } else {
            this.deviceNames = null;
        }
        return (A)((Object)this);
    }

    public A withDeviceNames(String ... deviceNames) {
        if (this.deviceNames != null) {
            this.deviceNames.clear();
            this._visitables.remove((Object)"deviceNames");
        }
        if (deviceNames != null) {
            for (String item : deviceNames) {
                this.addToDeviceNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDeviceNames() {
        return this.deviceNames != null && !this.deviceNames.isEmpty();
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public String getInstance() {
        return this.instance;
    }

    public A withInstance(String instance) {
        this.instance = instance;
        return (A)((Object)this);
    }

    public boolean hasInstance() {
        return this.instance != null;
    }

    public String getProject() {
        return this.project;
    }

    public A withProject(String project) {
        this.project = project;
        return (A)((Object)this);
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public A withRemoteCluster(String remoteCluster) {
        this.remoteCluster = remoteCluster;
        return (A)((Object)this);
    }

    public boolean hasRemoteCluster() {
        return this.remoteCluster != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPChaosSpecFluent that = (GCPChaosSpecFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.deviceNames, that.deviceNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.instance, that.instance)) {
            return false;
        }
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        if (!Objects.equals(this.remoteCluster, that.remoteCluster)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.deviceNames, this.duration, this.instance, this.project, this.remoteCluster, this.secretName, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.deviceNames != null && !this.deviceNames.isEmpty()) {
            sb.append("deviceNames:");
            sb.append(String.valueOf(this.deviceNames) + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.instance != null) {
            sb.append("instance:");
            sb.append(this.instance + ",");
        }
        if (this.project != null) {
            sb.append("project:");
            sb.append(this.project + ",");
        }
        if (this.remoteCluster != null) {
            sb.append("remoteCluster:");
            sb.append(this.remoteCluster + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

