/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.Filter;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterFluent<A extends FilterFluent<A>>
extends BaseFluent<A> {
    private List<String> methods = new ArrayList<String>();
    private String path;
    private Integer percent;
    private Map<String, Object> additionalProperties;

    public FilterFluent() {
    }

    public FilterFluent(Filter instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Filter instance) {
        Filter filter = instance = instance != null ? instance : new Filter();
        if (instance != null) {
            this.withMethods(instance.getMethods());
            this.withPath(instance.getPath());
            this.withPercent(instance.getPercent());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(index, item);
        return (A)((Object)this);
    }

    public A setToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.set(index, item);
        return (A)((Object)this);
    }

    public A addToMethods(String ... items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMethods(String ... items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.methods.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMethods(Collection<String> items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.methods.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getMethod(int index) {
        return this.methods.get(index);
    }

    public String getFirstMethod() {
        return this.methods.get(0);
    }

    public String getLastMethod() {
        return this.methods.get(this.methods.size() - 1);
    }

    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMethods(List<String> methods) {
        if (methods != null) {
            this.methods = new ArrayList<String>();
            for (String item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)((Object)this);
    }

    public A withMethods(String ... methods) {
        if (this.methods != null) {
            this.methods.clear();
            this._visitables.remove((Object)"methods");
        }
        if (methods != null) {
            for (String item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public A withPercent(Integer percent) {
        this.percent = percent;
        return (A)((Object)this);
    }

    public boolean hasPercent() {
        return this.percent != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterFluent that = (FilterFluent)((Object)o);
        if (!Objects.equals(this.methods, that.methods)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.percent, that.percent)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.path, this.percent, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.methods != null && !this.methods.isEmpty()) {
            sb.append("methods:");
            sb.append(String.valueOf(this.methods) + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.percent != null) {
            sb.append("percent:");
            sb.append(this.percent + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

