/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.CPUStressor;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CPUStressorFluent<A extends CPUStressorFluent<A>>
extends BaseFluent<A> {
    private Integer load;
    private List<String> options = new ArrayList<String>();
    private Integer workers;
    private Map<String, Object> additionalProperties;

    public CPUStressorFluent() {
    }

    public CPUStressorFluent(CPUStressor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CPUStressor instance) {
        CPUStressor cPUStressor = instance = instance != null ? instance : new CPUStressor();
        if (instance != null) {
            this.withLoad(instance.getLoad());
            this.withOptions(instance.getOptions());
            this.withWorkers(instance.getWorkers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getLoad() {
        return this.load;
    }

    public A withLoad(Integer load) {
        this.load = load;
        return (A)((Object)this);
    }

    public boolean hasLoad() {
        return this.load != null;
    }

    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)((Object)this);
    }

    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)((Object)this);
    }

    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<String> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public A withWorkers(Integer workers) {
        this.workers = workers;
        return (A)((Object)this);
    }

    public boolean hasWorkers() {
        return this.workers != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUStressorFluent that = (CPUStressorFluent)((Object)o);
        if (!Objects.equals(this.load, that.load)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.workers, that.workers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.load, this.options, this.workers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.load != null) {
            sb.append("load:");
            sb.append(this.load + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(String.valueOf(this.options) + ",");
        }
        if (this.workers != null) {
            sb.append("workers:");
            sb.append(this.workers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

