/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.HTTPStatusCheck;
import io.fabric8.chaosmesh.v1alpha1.HTTPStatusCheckBuilder;
import io.fabric8.chaosmesh.v1alpha1.HTTPStatusCheckFluent;
import io.fabric8.chaosmesh.v1alpha1.StatusCheckTemplate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatusCheckTemplateFluent<A extends StatusCheckTemplateFluent<A>>
extends BaseFluent<A> {
    private String duration;
    private Integer failureThreshold;
    private HTTPStatusCheckBuilder http;
    private Integer intervalSeconds;
    private String mode;
    private Integer recordsHistoryLimit;
    private Integer successThreshold;
    private Integer timeoutSeconds;
    private String type;
    private Map<String, Object> additionalProperties;

    public StatusCheckTemplateFluent() {
    }

    public StatusCheckTemplateFluent(StatusCheckTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StatusCheckTemplate instance) {
        StatusCheckTemplate statusCheckTemplate = instance = instance != null ? instance : new StatusCheckTemplate();
        if (instance != null) {
            this.withDuration(instance.getDuration());
            this.withFailureThreshold(instance.getFailureThreshold());
            this.withHttp(instance.getHttp());
            this.withIntervalSeconds(instance.getIntervalSeconds());
            this.withMode(instance.getMode());
            this.withRecordsHistoryLimit(instance.getRecordsHistoryLimit());
            this.withSuccessThreshold(instance.getSuccessThreshold());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public A withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return (A)((Object)this);
    }

    public boolean hasFailureThreshold() {
        return this.failureThreshold != null;
    }

    public HTTPStatusCheck buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    public A withHttp(HTTPStatusCheck http) {
        this._visitables.remove((Object)"http");
        if (http != null) {
            this.http = new HTTPStatusCheckBuilder(http);
            this._visitables.get((Object)"http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get((Object)"http").remove((Object)this.http);
        }
        return (A)((Object)this);
    }

    public boolean hasHttp() {
        return this.http != null;
    }

    public HttpNested<A> withNewHttp() {
        return new HttpNested(null);
    }

    public HttpNested<A> withNewHttpLike(HTTPStatusCheck item) {
        return new HttpNested(item);
    }

    public HttpNested<A> editHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(null));
    }

    public HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(new HTTPStatusCheckBuilder().build()));
    }

    public HttpNested<A> editOrNewHttpLike(HTTPStatusCheck item) {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(item));
    }

    public Integer getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public A withIntervalSeconds(Integer intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
        return (A)((Object)this);
    }

    public boolean hasIntervalSeconds() {
        return this.intervalSeconds != null;
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public Integer getRecordsHistoryLimit() {
        return this.recordsHistoryLimit;
    }

    public A withRecordsHistoryLimit(Integer recordsHistoryLimit) {
        this.recordsHistoryLimit = recordsHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasRecordsHistoryLimit() {
        return this.recordsHistoryLimit != null;
    }

    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public A withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return (A)((Object)this);
    }

    public boolean hasSuccessThreshold() {
        return this.successThreshold != null;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusCheckTemplateFluent that = (StatusCheckTemplateFluent)((Object)o);
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.failureThreshold, that.failureThreshold)) {
            return false;
        }
        if (!Objects.equals((Object)this.http, (Object)that.http)) {
            return false;
        }
        if (!Objects.equals(this.intervalSeconds, that.intervalSeconds)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.recordsHistoryLimit, that.recordsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.successThreshold, that.successThreshold)) {
            return false;
        }
        if (!Objects.equals(this.timeoutSeconds, that.timeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.failureThreshold, this.http, this.intervalSeconds, this.mode, this.recordsHistoryLimit, this.successThreshold, this.timeoutSeconds, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.failureThreshold != null) {
            sb.append("failureThreshold:");
            sb.append(this.failureThreshold + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http + ",");
        }
        if (this.intervalSeconds != null) {
            sb.append("intervalSeconds:");
            sb.append(this.intervalSeconds + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.recordsHistoryLimit != null) {
            sb.append("recordsHistoryLimit:");
            sb.append(this.recordsHistoryLimit + ",");
        }
        if (this.successThreshold != null) {
            sb.append("successThreshold:");
            sb.append(this.successThreshold + ",");
        }
        if (this.timeoutSeconds != null) {
            sb.append("timeoutSeconds:");
            sb.append(this.timeoutSeconds + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpNested<N>
    extends HTTPStatusCheckFluent<HttpNested<N>>
    implements Nested<N> {
        HTTPStatusCheckBuilder builder;

        HttpNested(HTTPStatusCheck item) {
            this.builder = new HTTPStatusCheckBuilder(this, item);
        }

        public N and() {
            return (N)StatusCheckTemplateFluent.this.withHttp(this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }
}

