/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.Record;
import io.fabric8.chaosmesh.v1alpha1.RecordEvent;
import io.fabric8.chaosmesh.v1alpha1.RecordEventBuilder;
import io.fabric8.chaosmesh.v1alpha1.RecordEventFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RecordFluent<A extends RecordFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RecordEventBuilder> events = new ArrayList();
    private String id;
    private Integer injectedCount;
    private String phase;
    private Integer recoveredCount;
    private String selectorKey;
    private Map<String, Object> additionalProperties;

    public RecordFluent() {
    }

    public RecordFluent(Record instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Record instance) {
        Record record = instance = instance != null ? instance : new Record();
        if (instance != null) {
            this.withEvents(instance.getEvents());
            this.withId(instance.getId());
            this.withInjectedCount(instance.getInjectedCount());
            this.withPhase(instance.getPhase());
            this.withRecoveredCount(instance.getRecoveredCount());
            this.withSelectorKey(instance.getSelectorKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEvents(int index, RecordEvent item) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        RecordEventBuilder builder = new RecordEventBuilder(item);
        if (index < 0 || index >= this.events.size()) {
            this._visitables.get((Object)"events").add(builder);
            this.events.add(builder);
        } else {
            this._visitables.get((Object)"events").add(index, builder);
            this.events.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEvents(int index, RecordEvent item) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        RecordEventBuilder builder = new RecordEventBuilder(item);
        if (index < 0 || index >= this.events.size()) {
            this._visitables.get((Object)"events").add(builder);
            this.events.add(builder);
        } else {
            this._visitables.get((Object)"events").set(index, builder);
            this.events.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEvents(RecordEvent ... items) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        for (RecordEvent item : items) {
            RecordEventBuilder builder = new RecordEventBuilder(item);
            this._visitables.get((Object)"events").add(builder);
            this.events.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEvents(Collection<RecordEvent> items) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        for (RecordEvent item : items) {
            RecordEventBuilder builder = new RecordEventBuilder(item);
            this._visitables.get((Object)"events").add(builder);
            this.events.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEvents(RecordEvent ... items) {
        if (this.events == null) {
            return (A)((Object)this);
        }
        for (RecordEvent item : items) {
            RecordEventBuilder builder = new RecordEventBuilder(item);
            this._visitables.get((Object)"events").remove((Object)builder);
            this.events.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEvents(Collection<RecordEvent> items) {
        if (this.events == null) {
            return (A)((Object)this);
        }
        for (RecordEvent item : items) {
            RecordEventBuilder builder = new RecordEventBuilder(item);
            this._visitables.get((Object)"events").remove((Object)builder);
            this.events.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEvents(Predicate<RecordEventBuilder> predicate) {
        if (this.events == null) {
            return (A)((Object)this);
        }
        Iterator<RecordEventBuilder> each = this.events.iterator();
        List visitables = this._visitables.get((Object)"events");
        while (each.hasNext()) {
            RecordEventBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RecordEvent> buildEvents() {
        return this.events != null ? RecordFluent.build(this.events) : null;
    }

    public RecordEvent buildEvent(int index) {
        return this.events.get(index).build();
    }

    public RecordEvent buildFirstEvent() {
        return this.events.get(0).build();
    }

    public RecordEvent buildLastEvent() {
        return this.events.get(this.events.size() - 1).build();
    }

    public RecordEvent buildMatchingEvent(Predicate<RecordEventBuilder> predicate) {
        for (RecordEventBuilder item : this.events) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEvent(Predicate<RecordEventBuilder> predicate) {
        for (RecordEventBuilder item : this.events) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEvents(List<RecordEvent> events) {
        if (this.events != null) {
            this._visitables.get((Object)"events").clear();
        }
        if (events != null) {
            this.events = new ArrayList();
            for (RecordEvent item : events) {
                this.addToEvents(item);
            }
        } else {
            this.events = null;
        }
        return (A)((Object)this);
    }

    public A withEvents(RecordEvent ... events) {
        if (this.events != null) {
            this.events.clear();
            this._visitables.remove((Object)"events");
        }
        if (events != null) {
            for (RecordEvent item : events) {
                this.addToEvents(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEvents() {
        return this.events != null && !this.events.isEmpty();
    }

    public A addNewEvent(String message, String operation, String timestamp, String type) {
        return this.addToEvents(new RecordEvent(message, operation, timestamp, type));
    }

    public EventsNested<A> addNewEvent() {
        return new EventsNested(-1, null);
    }

    public EventsNested<A> addNewEventLike(RecordEvent item) {
        return new EventsNested(-1, item);
    }

    public EventsNested<A> setNewEventLike(int index, RecordEvent item) {
        return new EventsNested(index, item);
    }

    public EventsNested<A> editEvent(int index) {
        if (this.events.size() <= index) {
            throw new RuntimeException("Can't edit events. Index exceeds size.");
        }
        return this.setNewEventLike(index, this.buildEvent(index));
    }

    public EventsNested<A> editFirstEvent() {
        if (this.events.size() == 0) {
            throw new RuntimeException("Can't edit first events. The list is empty.");
        }
        return this.setNewEventLike(0, this.buildEvent(0));
    }

    public EventsNested<A> editLastEvent() {
        int index = this.events.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last events. The list is empty.");
        }
        return this.setNewEventLike(index, this.buildEvent(index));
    }

    public EventsNested<A> editMatchingEvent(Predicate<RecordEventBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.events.size(); ++i) {
            if (!predicate.test(this.events.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching events. No match found.");
        }
        return this.setNewEventLike(index, this.buildEvent(index));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public Integer getInjectedCount() {
        return this.injectedCount;
    }

    public A withInjectedCount(Integer injectedCount) {
        this.injectedCount = injectedCount;
        return (A)((Object)this);
    }

    public boolean hasInjectedCount() {
        return this.injectedCount != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Integer getRecoveredCount() {
        return this.recoveredCount;
    }

    public A withRecoveredCount(Integer recoveredCount) {
        this.recoveredCount = recoveredCount;
        return (A)((Object)this);
    }

    public boolean hasRecoveredCount() {
        return this.recoveredCount != null;
    }

    public String getSelectorKey() {
        return this.selectorKey;
    }

    public A withSelectorKey(String selectorKey) {
        this.selectorKey = selectorKey;
        return (A)((Object)this);
    }

    public boolean hasSelectorKey() {
        return this.selectorKey != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecordFluent that = (RecordFluent)((Object)o);
        if (!Objects.equals(this.events, that.events)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.injectedCount, that.injectedCount)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.recoveredCount, that.recoveredCount)) {
            return false;
        }
        if (!Objects.equals(this.selectorKey, that.selectorKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.id, this.injectedCount, this.phase, this.recoveredCount, this.selectorKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events != null && !this.events.isEmpty()) {
            sb.append("events:");
            sb.append(this.events + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.injectedCount != null) {
            sb.append("injectedCount:");
            sb.append(this.injectedCount + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.recoveredCount != null) {
            sb.append("recoveredCount:");
            sb.append(this.recoveredCount + ",");
        }
        if (this.selectorKey != null) {
            sb.append("selectorKey:");
            sb.append(this.selectorKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EventsNested<N>
    extends RecordEventFluent<EventsNested<N>>
    implements Nested<N> {
        RecordEventBuilder builder;
        int index;

        EventsNested(int index, RecordEvent item) {
            this.index = index;
            this.builder = new RecordEventBuilder(this, item);
        }

        public N and() {
            return (N)RecordFluent.this.setToEvents(this.index, this.builder.build());
        }

        public N endEvent() {
            return this.and();
        }
    }
}

