/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.PhysicalMachineSelector;
import io.fabric8.chaosmesh.v1alpha1.PhysicalMachineSelectorSpec;
import io.fabric8.chaosmesh.v1alpha1.PhysicalMachineSelectorSpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.PhysicalMachineSelectorSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PhysicalMachineSelectorFluent<A extends PhysicalMachineSelectorFluent<A>>
extends BaseFluent<A> {
    private List<String> address = new ArrayList<String>();
    private String mode;
    private PhysicalMachineSelectorSpecBuilder selector;
    private String value;
    private Map<String, Object> additionalProperties;

    public PhysicalMachineSelectorFluent() {
    }

    public PhysicalMachineSelectorFluent(PhysicalMachineSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PhysicalMachineSelector instance) {
        PhysicalMachineSelector physicalMachineSelector = instance = instance != null ? instance : new PhysicalMachineSelector();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withMode(instance.getMode());
            this.withSelector(instance.getSelector());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddress(int index, String item) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        this.address.add(index, item);
        return (A)((Object)this);
    }

    public A setToAddress(int index, String item) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        this.address.set(index, item);
        return (A)((Object)this);
    }

    public A addToAddress(String ... items) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        for (String item : items) {
            this.address.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAddress(Collection<String> items) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        for (String item : items) {
            this.address.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAddress(String ... items) {
        if (this.address == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.address.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddress(Collection<String> items) {
        if (this.address == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.address.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAddress() {
        return this.address;
    }

    public String getAddress(int index) {
        return this.address.get(index);
    }

    public String getFirstAddress() {
        return this.address.get(0);
    }

    public String getLastAddress() {
        return this.address.get(this.address.size() - 1);
    }

    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.address) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.address) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddress(List<String> address) {
        if (address != null) {
            this.address = new ArrayList<String>();
            for (String item : address) {
                this.addToAddress(item);
            }
        } else {
            this.address = null;
        }
        return (A)((Object)this);
    }

    public A withAddress(String ... address) {
        if (this.address != null) {
            this.address.clear();
            this._visitables.remove((Object)"address");
        }
        if (address != null) {
            for (String item : address) {
                this.addToAddress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public PhysicalMachineSelectorSpec buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(PhysicalMachineSelectorSpec selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new PhysicalMachineSelectorSpecBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(PhysicalMachineSelectorSpec item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new PhysicalMachineSelectorSpecBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(PhysicalMachineSelectorSpec item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)((Object)this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhysicalMachineSelectorFluent that = (PhysicalMachineSelectorFluent)((Object)o);
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals((Object)this.selector, (Object)that.selector)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.mode, this.selector, this.value, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null && !this.address.isEmpty()) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends PhysicalMachineSelectorSpecFluent<SelectorNested<N>>
    implements Nested<N> {
        PhysicalMachineSelectorSpecBuilder builder;

        SelectorNested(PhysicalMachineSelectorSpec item) {
            this.builder = new PhysicalMachineSelectorSpecBuilder(this, item);
        }

        public N and() {
            return (N)PhysicalMachineSelectorFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

