/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.RawIptables;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RawIptablesFluent<A extends RawIptablesFluent<A>>
extends BaseFluent<A> {
    private String device;
    private String direction;
    private List<String> ipsets = new ArrayList<String>();
    private String name;
    private String source;

    public RawIptablesFluent() {
    }

    public RawIptablesFluent(RawIptables instance) {
        RawIptables rawIptables = instance = instance != null ? instance : new RawIptables();
        if (instance != null) {
            this.withDevice(instance.getDevice());
            this.withDirection(instance.getDirection());
            this.withIpsets(instance.getIpsets());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withDevice(instance.getDevice());
            this.withDirection(instance.getDirection());
            this.withIpsets(instance.getIpsets());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
        }
    }

    public String getDevice() {
        return this.device;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)((Object)this);
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public String getDirection() {
        return this.direction;
    }

    public A withDirection(String direction) {
        this.direction = direction;
        return (A)((Object)this);
    }

    public boolean hasDirection() {
        return this.direction != null;
    }

    public A addToIpsets(int index, String item) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        this.ipsets.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpsets(int index, String item) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        this.ipsets.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpsets(String ... items) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipsets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpsets(Collection<String> items) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipsets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpsets(String ... items) {
        if (this.ipsets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipsets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpsets(Collection<String> items) {
        if (this.ipsets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipsets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpsets() {
        return this.ipsets;
    }

    public String getIpset(int index) {
        return this.ipsets.get(index);
    }

    public String getFirstIpset() {
        return this.ipsets.get(0);
    }

    public String getLastIpset() {
        return this.ipsets.get(this.ipsets.size() - 1);
    }

    public String getMatchingIpset(Predicate<String> predicate) {
        for (String item : this.ipsets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpset(Predicate<String> predicate) {
        for (String item : this.ipsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpsets(List<String> ipsets) {
        if (ipsets != null) {
            this.ipsets = new ArrayList<String>();
            for (String item : ipsets) {
                this.addToIpsets(item);
            }
        } else {
            this.ipsets = null;
        }
        return (A)((Object)this);
    }

    public A withIpsets(String ... ipsets) {
        if (this.ipsets != null) {
            this.ipsets.clear();
            this._visitables.remove((Object)"ipsets");
        }
        if (ipsets != null) {
            for (String item : ipsets) {
                this.addToIpsets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpsets() {
        return this.ipsets != null && !this.ipsets.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawIptablesFluent that = (RawIptablesFluent)((Object)o);
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.direction, that.direction)) {
            return false;
        }
        if (!Objects.equals(this.ipsets, that.ipsets)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.device, this.direction, this.ipsets, this.name, this.source, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device + ",");
        }
        if (this.direction != null) {
            sb.append("direction:");
            sb.append(this.direction + ",");
        }
        if (this.ipsets != null && !this.ipsets.isEmpty()) {
            sb.append("ipsets:");
            sb.append(this.ipsets + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
        }
        sb.append("}");
        return sb.toString();
    }
}

