/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.IOChaosAction;
import io.fabric8.chaosmesh.v1alpha1.IoFault;
import io.fabric8.chaosmesh.v1alpha1.IoFaultBuilder;
import io.fabric8.chaosmesh.v1alpha1.IoFaultFluent;
import io.fabric8.chaosmesh.v1alpha1.MistakeSpec;
import io.fabric8.chaosmesh.v1alpha1.MistakeSpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.MistakeSpecFluent;
import io.fabric8.chaosmesh.v1alpha1.Timespec;
import io.fabric8.chaosmesh.v1alpha1.TimespecBuilder;
import io.fabric8.chaosmesh.v1alpha1.TimespecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IOChaosActionFluent<A extends IOChaosActionFluent<A>>
extends BaseFluent<A> {
    private TimespecBuilder atime;
    private Long blocks;
    private TimespecBuilder ctime;
    private ArrayList<IoFaultBuilder> faults = new ArrayList();
    private Long gid;
    private Long ino;
    private String kind;
    private String latency;
    private List<String> methods = new ArrayList<String>();
    private MistakeSpecBuilder mistake;
    private TimespecBuilder mtime;
    private Long nlink;
    private String path;
    private Integer percent;
    private Integer perm;
    private Long rdev;
    private Long size;
    private String source;
    private String type;
    private Long uid;

    public IOChaosActionFluent() {
    }

    public IOChaosActionFluent(IOChaosAction instance) {
        IOChaosAction iOChaosAction = instance = instance != null ? instance : new IOChaosAction();
        if (instance != null) {
            this.withAtime(instance.getAtime());
            this.withBlocks(instance.getBlocks());
            this.withCtime(instance.getCtime());
            this.withFaults(instance.getFaults());
            this.withGid(instance.getGid());
            this.withIno(instance.getIno());
            this.withKind(instance.getKind());
            this.withLatency(instance.getLatency());
            this.withMethods(instance.getMethods());
            this.withMistake(instance.getMistake());
            this.withMtime(instance.getMtime());
            this.withNlink(instance.getNlink());
            this.withPath(instance.getPath());
            this.withPercent(instance.getPercent());
            this.withPerm(instance.getPerm());
            this.withRdev(instance.getRdev());
            this.withSize(instance.getSize());
            this.withSource(instance.getSource());
            this.withType(instance.getType());
            this.withUid(instance.getUid());
            this.withAtime(instance.getAtime());
            this.withBlocks(instance.getBlocks());
            this.withCtime(instance.getCtime());
            this.withFaults(instance.getFaults());
            this.withGid(instance.getGid());
            this.withIno(instance.getIno());
            this.withKind(instance.getKind());
            this.withLatency(instance.getLatency());
            this.withMethods(instance.getMethods());
            this.withMistake(instance.getMistake());
            this.withMtime(instance.getMtime());
            this.withNlink(instance.getNlink());
            this.withPath(instance.getPath());
            this.withPercent(instance.getPercent());
            this.withPerm(instance.getPerm());
            this.withRdev(instance.getRdev());
            this.withSize(instance.getSize());
            this.withSource(instance.getSource());
            this.withType(instance.getType());
            this.withUid(instance.getUid());
        }
    }

    public Timespec buildAtime() {
        return this.atime != null ? this.atime.build() : null;
    }

    public A withAtime(Timespec atime) {
        this._visitables.get((Object)"atime").remove((Object)this.atime);
        if (atime != null) {
            this.atime = new TimespecBuilder(atime);
            this._visitables.get((Object)"atime").add(this.atime);
        } else {
            this.atime = null;
            this._visitables.get((Object)"atime").remove((Object)this.atime);
        }
        return (A)((Object)this);
    }

    public boolean hasAtime() {
        return this.atime != null;
    }

    public A withNewAtime(Long nsec, Long sec) {
        return this.withAtime(new Timespec(nsec, sec));
    }

    public AtimeNested<A> withNewAtime() {
        return new AtimeNested(null);
    }

    public AtimeNested<A> withNewAtimeLike(Timespec item) {
        return new AtimeNested(item);
    }

    public AtimeNested<A> editAtime() {
        return this.withNewAtimeLike(Optional.ofNullable(this.buildAtime()).orElse(null));
    }

    public AtimeNested<A> editOrNewAtime() {
        return this.withNewAtimeLike(Optional.ofNullable(this.buildAtime()).orElse(new TimespecBuilder().build()));
    }

    public AtimeNested<A> editOrNewAtimeLike(Timespec item) {
        return this.withNewAtimeLike(Optional.ofNullable(this.buildAtime()).orElse(item));
    }

    public Long getBlocks() {
        return this.blocks;
    }

    public A withBlocks(Long blocks) {
        this.blocks = blocks;
        return (A)((Object)this);
    }

    public boolean hasBlocks() {
        return this.blocks != null;
    }

    public Timespec buildCtime() {
        return this.ctime != null ? this.ctime.build() : null;
    }

    public A withCtime(Timespec ctime) {
        this._visitables.get((Object)"ctime").remove((Object)this.ctime);
        if (ctime != null) {
            this.ctime = new TimespecBuilder(ctime);
            this._visitables.get((Object)"ctime").add(this.ctime);
        } else {
            this.ctime = null;
            this._visitables.get((Object)"ctime").remove((Object)this.ctime);
        }
        return (A)((Object)this);
    }

    public boolean hasCtime() {
        return this.ctime != null;
    }

    public A withNewCtime(Long nsec, Long sec) {
        return this.withCtime(new Timespec(nsec, sec));
    }

    public CtimeNested<A> withNewCtime() {
        return new CtimeNested(null);
    }

    public CtimeNested<A> withNewCtimeLike(Timespec item) {
        return new CtimeNested(item);
    }

    public CtimeNested<A> editCtime() {
        return this.withNewCtimeLike(Optional.ofNullable(this.buildCtime()).orElse(null));
    }

    public CtimeNested<A> editOrNewCtime() {
        return this.withNewCtimeLike(Optional.ofNullable(this.buildCtime()).orElse(new TimespecBuilder().build()));
    }

    public CtimeNested<A> editOrNewCtimeLike(Timespec item) {
        return this.withNewCtimeLike(Optional.ofNullable(this.buildCtime()).orElse(item));
    }

    public A addToFaults(int index, IoFault item) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        IoFaultBuilder builder = new IoFaultBuilder(item);
        if (index < 0 || index >= this.faults.size()) {
            this._visitables.get((Object)"faults").add(builder);
            this.faults.add(builder);
        } else {
            this._visitables.get((Object)"faults").add(index, builder);
            this.faults.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFaults(int index, IoFault item) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        IoFaultBuilder builder = new IoFaultBuilder(item);
        if (index < 0 || index >= this.faults.size()) {
            this._visitables.get((Object)"faults").add(builder);
            this.faults.add(builder);
        } else {
            this._visitables.get((Object)"faults").set(index, builder);
            this.faults.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFaults(IoFault ... items) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        for (IoFault item : items) {
            IoFaultBuilder builder = new IoFaultBuilder(item);
            this._visitables.get((Object)"faults").add(builder);
            this.faults.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFaults(Collection<IoFault> items) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        for (IoFault item : items) {
            IoFaultBuilder builder = new IoFaultBuilder(item);
            this._visitables.get((Object)"faults").add(builder);
            this.faults.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFaults(IoFault ... items) {
        if (this.faults == null) {
            return (A)((Object)this);
        }
        for (IoFault item : items) {
            IoFaultBuilder builder = new IoFaultBuilder(item);
            this._visitables.get((Object)"faults").remove((Object)builder);
            this.faults.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFaults(Collection<IoFault> items) {
        if (this.faults == null) {
            return (A)((Object)this);
        }
        for (IoFault item : items) {
            IoFaultBuilder builder = new IoFaultBuilder(item);
            this._visitables.get((Object)"faults").remove((Object)builder);
            this.faults.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFaults(Predicate<IoFaultBuilder> predicate) {
        if (this.faults == null) {
            return (A)((Object)this);
        }
        Iterator<IoFaultBuilder> each = this.faults.iterator();
        List visitables = this._visitables.get((Object)"faults");
        while (each.hasNext()) {
            IoFaultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IoFault> buildFaults() {
        return this.faults != null ? IOChaosActionFluent.build(this.faults) : null;
    }

    public IoFault buildFault(int index) {
        return this.faults.get(index).build();
    }

    public IoFault buildFirstFault() {
        return this.faults.get(0).build();
    }

    public IoFault buildLastFault() {
        return this.faults.get(this.faults.size() - 1).build();
    }

    public IoFault buildMatchingFault(Predicate<IoFaultBuilder> predicate) {
        for (IoFaultBuilder item : this.faults) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFault(Predicate<IoFaultBuilder> predicate) {
        for (IoFaultBuilder item : this.faults) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFaults(List<IoFault> faults) {
        if (this.faults != null) {
            this._visitables.get((Object)"faults").clear();
        }
        if (faults != null) {
            this.faults = new ArrayList();
            for (IoFault item : faults) {
                this.addToFaults(item);
            }
        } else {
            this.faults = null;
        }
        return (A)((Object)this);
    }

    public A withFaults(IoFault ... faults) {
        if (this.faults != null) {
            this.faults.clear();
            this._visitables.remove((Object)"faults");
        }
        if (faults != null) {
            for (IoFault item : faults) {
                this.addToFaults(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFaults() {
        return this.faults != null && !this.faults.isEmpty();
    }

    public A addNewFault(Integer errno, Integer weight) {
        return this.addToFaults(new IoFault(errno, weight));
    }

    public FaultsNested<A> addNewFault() {
        return new FaultsNested(-1, null);
    }

    public FaultsNested<A> addNewFaultLike(IoFault item) {
        return new FaultsNested(-1, item);
    }

    public FaultsNested<A> setNewFaultLike(int index, IoFault item) {
        return new FaultsNested(index, item);
    }

    public FaultsNested<A> editFault(int index) {
        if (this.faults.size() <= index) {
            throw new RuntimeException("Can't edit faults. Index exceeds size.");
        }
        return this.setNewFaultLike(index, this.buildFault(index));
    }

    public FaultsNested<A> editFirstFault() {
        if (this.faults.size() == 0) {
            throw new RuntimeException("Can't edit first faults. The list is empty.");
        }
        return this.setNewFaultLike(0, this.buildFault(0));
    }

    public FaultsNested<A> editLastFault() {
        int index = this.faults.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last faults. The list is empty.");
        }
        return this.setNewFaultLike(index, this.buildFault(index));
    }

    public FaultsNested<A> editMatchingFault(Predicate<IoFaultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.faults.size(); ++i) {
            if (!predicate.test(this.faults.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching faults. No match found.");
        }
        return this.setNewFaultLike(index, this.buildFault(index));
    }

    public Long getGid() {
        return this.gid;
    }

    public A withGid(Long gid) {
        this.gid = gid;
        return (A)((Object)this);
    }

    public boolean hasGid() {
        return this.gid != null;
    }

    public Long getIno() {
        return this.ino;
    }

    public A withIno(Long ino) {
        this.ino = ino;
        return (A)((Object)this);
    }

    public boolean hasIno() {
        return this.ino != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getLatency() {
        return this.latency;
    }

    public A withLatency(String latency) {
        this.latency = latency;
        return (A)((Object)this);
    }

    public boolean hasLatency() {
        return this.latency != null;
    }

    public A addToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(index, item);
        return (A)((Object)this);
    }

    public A setToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.set(index, item);
        return (A)((Object)this);
    }

    public A addToMethods(String ... items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMethods(String ... items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.methods.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMethods(Collection<String> items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.methods.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getMethod(int index) {
        return this.methods.get(index);
    }

    public String getFirstMethod() {
        return this.methods.get(0);
    }

    public String getLastMethod() {
        return this.methods.get(this.methods.size() - 1);
    }

    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMethods(List<String> methods) {
        if (methods != null) {
            this.methods = new ArrayList<String>();
            for (String item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)((Object)this);
    }

    public A withMethods(String ... methods) {
        if (this.methods != null) {
            this.methods.clear();
            this._visitables.remove((Object)"methods");
        }
        if (methods != null) {
            for (String item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public MistakeSpec buildMistake() {
        return this.mistake != null ? this.mistake.build() : null;
    }

    public A withMistake(MistakeSpec mistake) {
        this._visitables.get((Object)"mistake").remove((Object)this.mistake);
        if (mistake != null) {
            this.mistake = new MistakeSpecBuilder(mistake);
            this._visitables.get((Object)"mistake").add(this.mistake);
        } else {
            this.mistake = null;
            this._visitables.get((Object)"mistake").remove((Object)this.mistake);
        }
        return (A)((Object)this);
    }

    public boolean hasMistake() {
        return this.mistake != null;
    }

    public A withNewMistake(String filling, Long maxLength, Long maxOccurrences) {
        return this.withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
    }

    public MistakeNested<A> withNewMistake() {
        return new MistakeNested(null);
    }

    public MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
        return new MistakeNested(item);
    }

    public MistakeNested<A> editMistake() {
        return this.withNewMistakeLike(Optional.ofNullable(this.buildMistake()).orElse(null));
    }

    public MistakeNested<A> editOrNewMistake() {
        return this.withNewMistakeLike(Optional.ofNullable(this.buildMistake()).orElse(new MistakeSpecBuilder().build()));
    }

    public MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
        return this.withNewMistakeLike(Optional.ofNullable(this.buildMistake()).orElse(item));
    }

    public Timespec buildMtime() {
        return this.mtime != null ? this.mtime.build() : null;
    }

    public A withMtime(Timespec mtime) {
        this._visitables.get((Object)"mtime").remove((Object)this.mtime);
        if (mtime != null) {
            this.mtime = new TimespecBuilder(mtime);
            this._visitables.get((Object)"mtime").add(this.mtime);
        } else {
            this.mtime = null;
            this._visitables.get((Object)"mtime").remove((Object)this.mtime);
        }
        return (A)((Object)this);
    }

    public boolean hasMtime() {
        return this.mtime != null;
    }

    public A withNewMtime(Long nsec, Long sec) {
        return this.withMtime(new Timespec(nsec, sec));
    }

    public MtimeNested<A> withNewMtime() {
        return new MtimeNested(null);
    }

    public MtimeNested<A> withNewMtimeLike(Timespec item) {
        return new MtimeNested(item);
    }

    public MtimeNested<A> editMtime() {
        return this.withNewMtimeLike(Optional.ofNullable(this.buildMtime()).orElse(null));
    }

    public MtimeNested<A> editOrNewMtime() {
        return this.withNewMtimeLike(Optional.ofNullable(this.buildMtime()).orElse(new TimespecBuilder().build()));
    }

    public MtimeNested<A> editOrNewMtimeLike(Timespec item) {
        return this.withNewMtimeLike(Optional.ofNullable(this.buildMtime()).orElse(item));
    }

    public Long getNlink() {
        return this.nlink;
    }

    public A withNlink(Long nlink) {
        this.nlink = nlink;
        return (A)((Object)this);
    }

    public boolean hasNlink() {
        return this.nlink != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public A withPercent(Integer percent) {
        this.percent = percent;
        return (A)((Object)this);
    }

    public boolean hasPercent() {
        return this.percent != null;
    }

    public Integer getPerm() {
        return this.perm;
    }

    public A withPerm(Integer perm) {
        this.perm = perm;
        return (A)((Object)this);
    }

    public boolean hasPerm() {
        return this.perm != null;
    }

    public Long getRdev() {
        return this.rdev;
    }

    public A withRdev(Long rdev) {
        this.rdev = rdev;
        return (A)((Object)this);
    }

    public boolean hasRdev() {
        return this.rdev != null;
    }

    public Long getSize() {
        return this.size;
    }

    public A withSize(Long size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Long getUid() {
        return this.uid;
    }

    public A withUid(Long uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IOChaosActionFluent that = (IOChaosActionFluent)((Object)o);
        if (!Objects.equals((Object)this.atime, (Object)that.atime)) {
            return false;
        }
        if (!Objects.equals(this.blocks, that.blocks)) {
            return false;
        }
        if (!Objects.equals((Object)this.ctime, (Object)that.ctime)) {
            return false;
        }
        if (!Objects.equals(this.faults, that.faults)) {
            return false;
        }
        if (!Objects.equals(this.gid, that.gid)) {
            return false;
        }
        if (!Objects.equals(this.ino, that.ino)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.latency, that.latency)) {
            return false;
        }
        if (!Objects.equals(this.methods, that.methods)) {
            return false;
        }
        if (!Objects.equals((Object)this.mistake, (Object)that.mistake)) {
            return false;
        }
        if (!Objects.equals((Object)this.mtime, (Object)that.mtime)) {
            return false;
        }
        if (!Objects.equals(this.nlink, that.nlink)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.percent, that.percent)) {
            return false;
        }
        if (!Objects.equals(this.perm, that.perm)) {
            return false;
        }
        if (!Objects.equals(this.rdev, that.rdev)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.uid, that.uid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.atime, this.blocks, this.ctime, this.faults, this.gid, this.ino, this.kind, this.latency, this.methods, this.mistake, this.mtime, this.nlink, this.path, this.percent, this.perm, this.rdev, this.size, this.source, this.type, this.uid, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.atime != null) {
            sb.append("atime:");
            sb.append((Object)((Object)this.atime) + ",");
        }
        if (this.blocks != null) {
            sb.append("blocks:");
            sb.append(this.blocks + ",");
        }
        if (this.ctime != null) {
            sb.append("ctime:");
            sb.append((Object)((Object)this.ctime) + ",");
        }
        if (this.faults != null && !this.faults.isEmpty()) {
            sb.append("faults:");
            sb.append(this.faults + ",");
        }
        if (this.gid != null) {
            sb.append("gid:");
            sb.append(this.gid + ",");
        }
        if (this.ino != null) {
            sb.append("ino:");
            sb.append(this.ino + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.latency != null) {
            sb.append("latency:");
            sb.append(this.latency + ",");
        }
        if (this.methods != null && !this.methods.isEmpty()) {
            sb.append("methods:");
            sb.append(this.methods + ",");
        }
        if (this.mistake != null) {
            sb.append("mistake:");
            sb.append((Object)((Object)this.mistake) + ",");
        }
        if (this.mtime != null) {
            sb.append("mtime:");
            sb.append((Object)((Object)this.mtime) + ",");
        }
        if (this.nlink != null) {
            sb.append("nlink:");
            sb.append(this.nlink + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.percent != null) {
            sb.append("percent:");
            sb.append(this.percent + ",");
        }
        if (this.perm != null) {
            sb.append("perm:");
            sb.append(this.perm + ",");
        }
        if (this.rdev != null) {
            sb.append("rdev:");
            sb.append(this.rdev + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MtimeNested<N>
    extends TimespecFluent<MtimeNested<N>>
    implements Nested<N> {
        TimespecBuilder builder;

        MtimeNested(Timespec item) {
            this.builder = new TimespecBuilder(this, item);
        }

        public N and() {
            return (N)IOChaosActionFluent.this.withMtime(this.builder.build());
        }

        public N endMtime() {
            return this.and();
        }
    }

    public class MistakeNested<N>
    extends MistakeSpecFluent<MistakeNested<N>>
    implements Nested<N> {
        MistakeSpecBuilder builder;

        MistakeNested(MistakeSpec item) {
            this.builder = new MistakeSpecBuilder(this, item);
        }

        public N and() {
            return (N)IOChaosActionFluent.this.withMistake(this.builder.build());
        }

        public N endMistake() {
            return this.and();
        }
    }

    public class FaultsNested<N>
    extends IoFaultFluent<FaultsNested<N>>
    implements Nested<N> {
        IoFaultBuilder builder;
        int index;

        FaultsNested(int index, IoFault item) {
            this.index = index;
            this.builder = new IoFaultBuilder(this, item);
        }

        public N and() {
            return (N)IOChaosActionFluent.this.setToFaults(this.index, this.builder.build());
        }

        public N endFault() {
            return this.and();
        }
    }

    public class CtimeNested<N>
    extends TimespecFluent<CtimeNested<N>>
    implements Nested<N> {
        TimespecBuilder builder;

        CtimeNested(Timespec item) {
            this.builder = new TimespecBuilder(this, item);
        }

        public N and() {
            return (N)IOChaosActionFluent.this.withCtime(this.builder.build());
        }

        public N endCtime() {
            return this.and();
        }
    }

    public class AtimeNested<N>
    extends TimespecFluent<AtimeNested<N>>
    implements Nested<N> {
        TimespecBuilder builder;

        AtimeNested(Timespec item) {
            this.builder = new TimespecBuilder(this, item);
        }

        public N and() {
            return (N)IOChaosActionFluent.this.withAtime(this.builder.build());
        }

        public N endAtime() {
            return this.and();
        }
    }
}

