/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.BlockChaosSpec;
import io.fabric8.chaosmesh.v1alpha1.BlockDelaySpec;
import io.fabric8.chaosmesh.v1alpha1.BlockDelaySpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.BlockDelaySpecFluent;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpec;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BlockChaosSpecFluent<A extends BlockChaosSpecFluent<A>>
extends BaseFluent<A> {
    private String action;
    private List<String> containerNames = new ArrayList<String>();
    private BlockDelaySpecBuilder delay;
    private String duration;
    private Integer iops;
    private String mode;
    private PodSelectorSpecBuilder selector;
    private String value;
    private String volumeName;

    public BlockChaosSpecFluent() {
    }

    public BlockChaosSpecFluent(BlockChaosSpec instance) {
        BlockChaosSpec blockChaosSpec = instance = instance != null ? instance : new BlockChaosSpec();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withContainerNames(instance.getContainerNames());
            this.withDelay(instance.getDelay());
            this.withDuration(instance.getDuration());
            this.withIops(instance.getIops());
            this.withMode(instance.getMode());
            this.withSelector(instance.getSelector());
            this.withValue(instance.getValue());
            this.withVolumeName(instance.getVolumeName());
            this.withAction(instance.getAction());
            this.withContainerNames(instance.getContainerNames());
            this.withDelay(instance.getDelay());
            this.withDuration(instance.getDuration());
            this.withIops(instance.getIops());
            this.withMode(instance.getMode());
            this.withSelector(instance.getSelector());
            this.withValue(instance.getValue());
            this.withVolumeName(instance.getVolumeName());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)((Object)this);
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public A addToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromContainerNames(String ... items) {
        if (this.containerNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.containerNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.containerNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getContainerNames() {
        return this.containerNames;
    }

    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerNames(List<String> containerNames) {
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = null;
        }
        return (A)((Object)this);
    }

    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
            this._visitables.remove((Object)"containerNames");
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    public BlockDelaySpec buildDelay() {
        return this.delay != null ? this.delay.build() : null;
    }

    public A withDelay(BlockDelaySpec delay) {
        this._visitables.get((Object)"delay").remove((Object)this.delay);
        if (delay != null) {
            this.delay = new BlockDelaySpecBuilder(delay);
            this._visitables.get((Object)"delay").add(this.delay);
        } else {
            this.delay = null;
            this._visitables.get((Object)"delay").remove((Object)this.delay);
        }
        return (A)((Object)this);
    }

    public boolean hasDelay() {
        return this.delay != null;
    }

    public A withNewDelay(String correlation, String jitter, String latency) {
        return this.withDelay(new BlockDelaySpec(correlation, jitter, latency));
    }

    public DelayNested<A> withNewDelay() {
        return new DelayNested(null);
    }

    public DelayNested<A> withNewDelayLike(BlockDelaySpec item) {
        return new DelayNested(item);
    }

    public DelayNested<A> editDelay() {
        return this.withNewDelayLike(Optional.ofNullable(this.buildDelay()).orElse(null));
    }

    public DelayNested<A> editOrNewDelay() {
        return this.withNewDelayLike(Optional.ofNullable(this.buildDelay()).orElse(new BlockDelaySpecBuilder().build()));
    }

    public DelayNested<A> editOrNewDelayLike(BlockDelaySpec item) {
        return this.withNewDelayLike(Optional.ofNullable(this.buildDelay()).orElse(item));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public Integer getIops() {
        return this.iops;
    }

    public A withIops(Integer iops) {
        this.iops = iops;
        return (A)((Object)this);
    }

    public boolean hasIops() {
        return this.iops != null;
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public PodSelectorSpec buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(PodSelectorSpec selector) {
        this._visitables.get((Object)"selector").remove((Object)this.selector);
        if (selector != null) {
            this.selector = new PodSelectorSpecBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new PodSelectorSpecBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)((Object)this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)((Object)this);
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockChaosSpecFluent that = (BlockChaosSpecFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.containerNames, that.containerNames)) {
            return false;
        }
        if (!Objects.equals((Object)this.delay, (Object)that.delay)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.iops, that.iops)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals((Object)this.selector, (Object)that.selector)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.volumeName, that.volumeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.containerNames, this.delay, this.duration, this.iops, this.mode, this.selector, this.value, this.volumeName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.containerNames != null && !this.containerNames.isEmpty()) {
            sb.append("containerNames:");
            sb.append(this.containerNames + ",");
        }
        if (this.delay != null) {
            sb.append("delay:");
            sb.append((Object)((Object)this.delay) + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.iops != null) {
            sb.append("iops:");
            sb.append(this.iops + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append((Object)((Object)this.selector) + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends PodSelectorSpecFluent<SelectorNested<N>>
    implements Nested<N> {
        PodSelectorSpecBuilder builder;

        SelectorNested(PodSelectorSpec item) {
            this.builder = new PodSelectorSpecBuilder(this, item);
        }

        public N and() {
            return (N)BlockChaosSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class DelayNested<N>
    extends BlockDelaySpecFluent<DelayNested<N>>
    implements Nested<N> {
        BlockDelaySpecBuilder builder;

        DelayNested(BlockDelaySpec item) {
            this.builder = new BlockDelaySpecBuilder(this, item);
        }

        public N and() {
            return (N)BlockChaosSpecFluent.this.withDelay(this.builder.build());
        }

        public N endDelay() {
            return this.and();
        }
    }
}

