/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.RawIPSet;
import io.fabric8.chaosmesh.v1alpha1.RawIPSetFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RawIPSetFluentImpl<A extends RawIPSetFluent<A>>
extends BaseFluent<A>
implements RawIPSetFluent<A> {
    private List<String> cidrs = new ArrayList<String>();
    private String name;
    private String source;

    public RawIPSetFluentImpl() {
    }

    public RawIPSetFluentImpl(RawIPSet instance) {
        if (instance != null) {
            this.withCidrs(instance.getCidrs());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
        }
    }

    @Override
    public A addToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCidrs(String ... items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCidrs(Collection<String> items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCidrs(String ... items) {
        for (String item : items) {
            if (this.cidrs == null) continue;
            this.cidrs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCidrs(Collection<String> items) {
        for (String item : items) {
            if (this.cidrs == null) continue;
            this.cidrs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCidrs() {
        return this.cidrs;
    }

    @Override
    public String getCidr(int index) {
        return this.cidrs.get(index);
    }

    @Override
    public String getFirstCidr() {
        return this.cidrs.get(0);
    }

    @Override
    public String getLastCidr() {
        return this.cidrs.get(this.cidrs.size() - 1);
    }

    @Override
    public String getMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCidrs(List<String> cidrs) {
        if (cidrs != null) {
            this.cidrs = new ArrayList<String>();
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        } else {
            this.cidrs = null;
        }
        return (A)this;
    }

    @Override
    public A withCidrs(String ... cidrs) {
        if (this.cidrs != null) {
            this.cidrs.clear();
            this._visitables.remove((Object)"cidrs");
        }
        if (cidrs != null) {
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCidrs() {
        return this.cidrs != null && !this.cidrs.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public A withSource(String source) {
        this.source = source;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawIPSetFluentImpl that = (RawIPSetFluentImpl)o;
        if (!Objects.equals(this.cidrs, that.cidrs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.cidrs, this.name, this.source, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrs != null && !this.cidrs.isEmpty()) {
            sb.append("cidrs:");
            sb.append(this.cidrs + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
        }
        sb.append("}");
        return sb.toString();
    }
}

