/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.PodChaosSpec;
import io.fabric8.chaosmesh.v1alpha1.PodChaosSpecFluent;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpec;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodChaosSpecFluentImpl<A extends PodChaosSpecFluent<A>>
extends BaseFluent<A>
implements PodChaosSpecFluent<A> {
    private String action;
    private List<String> containerNames = new ArrayList<String>();
    private String duration;
    private Long gracePeriod;
    private String mode;
    private PodSelectorSpecBuilder selector;
    private String value;

    public PodChaosSpecFluentImpl() {
    }

    public PodChaosSpecFluentImpl(PodChaosSpec instance) {
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withContainerNames(instance.getContainerNames());
            this.withDuration(instance.getDuration());
            this.withGracePeriod(instance.getGracePeriod());
            this.withMode(instance.getMode());
            this.withSelector(instance.getSelector());
            this.withValue(instance.getValue());
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public A addToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerNames(String ... items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerNames() {
        return this.containerNames;
    }

    @Override
    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    @Override
    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    @Override
    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    @Override
    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerNames(List<String> containerNames) {
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
            this._visitables.remove((Object)"containerNames");
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(String duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public Long getGracePeriod() {
        return this.gracePeriod;
    }

    @Override
    public A withGracePeriod(Long gracePeriod) {
        this.gracePeriod = gracePeriod;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriod() {
        return this.gracePeriod != null;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    @Deprecated
    public PodSelectorSpec getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public PodSelectorSpec buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(PodSelectorSpec selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new PodSelectorSpecBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PodChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PodChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PodChaosSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new PodSelectorSpecBuilder().build());
    }

    @Override
    public PodChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodChaosSpecFluentImpl that = (PodChaosSpecFluentImpl)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.containerNames, that.containerNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.gracePeriod, that.gracePeriod)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.containerNames, this.duration, this.gracePeriod, this.mode, this.selector, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.containerNames != null && !this.containerNames.isEmpty()) {
            sb.append("containerNames:");
            sb.append(this.containerNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.gracePeriod != null) {
            sb.append("gracePeriod:");
            sb.append(this.gracePeriod + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }

    class SelectorNestedImpl<N>
    extends PodSelectorSpecFluentImpl<PodChaosSpecFluent.SelectorNested<N>>
    implements PodChaosSpecFluent.SelectorNested<N>,
    Nested<N> {
        PodSelectorSpecBuilder builder;

        SelectorNestedImpl(PodSelectorSpec item) {
            this.builder = new PodSelectorSpecBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new PodSelectorSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodChaosSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

