/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.DNSChaosSpec;
import io.fabric8.chaosmesh.v1alpha1.DNSChaosSpecFluent;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpec;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecBuilder;
import io.fabric8.chaosmesh.v1alpha1.PodSelectorSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSChaosSpecFluentImpl<A extends DNSChaosSpecFluent<A>>
extends BaseFluent<A>
implements DNSChaosSpecFluent<A> {
    private String action;
    private List<String> containerNames = new ArrayList<String>();
    private String duration;
    private String mode;
    private List<String> patterns = new ArrayList<String>();
    private PodSelectorSpecBuilder selector;
    private String value;

    public DNSChaosSpecFluentImpl() {
    }

    public DNSChaosSpecFluentImpl(DNSChaosSpec instance) {
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withContainerNames(instance.getContainerNames());
            this.withDuration(instance.getDuration());
            this.withMode(instance.getMode());
            this.withPatterns(instance.getPatterns());
            this.withSelector(instance.getSelector());
            this.withValue(instance.getValue());
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public A addToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerNames(String ... items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerNames() {
        return this.containerNames;
    }

    @Override
    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    @Override
    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    @Override
    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    @Override
    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerNames(List<String> containerNames) {
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
            this._visitables.remove((Object)"containerNames");
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(String duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    public A addToPatterns(int index, String item) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        this.patterns.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPatterns(int index, String item) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        this.patterns.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPatterns(String ... items) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.patterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPatterns(Collection<String> items) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.patterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPatterns(String ... items) {
        for (String item : items) {
            if (this.patterns == null) continue;
            this.patterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPatterns(Collection<String> items) {
        for (String item : items) {
            if (this.patterns == null) continue;
            this.patterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPatterns() {
        return this.patterns;
    }

    @Override
    public String getPattern(int index) {
        return this.patterns.get(index);
    }

    @Override
    public String getFirstPattern() {
        return this.patterns.get(0);
    }

    @Override
    public String getLastPattern() {
        return this.patterns.get(this.patterns.size() - 1);
    }

    @Override
    public String getMatchingPattern(Predicate<String> predicate) {
        for (String item : this.patterns) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPattern(Predicate<String> predicate) {
        for (String item : this.patterns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPatterns(List<String> patterns) {
        if (patterns != null) {
            this.patterns = new ArrayList<String>();
            for (String item : patterns) {
                this.addToPatterns(item);
            }
        } else {
            this.patterns = null;
        }
        return (A)this;
    }

    @Override
    public A withPatterns(String ... patterns) {
        if (this.patterns != null) {
            this.patterns.clear();
            this._visitables.remove((Object)"patterns");
        }
        if (patterns != null) {
            for (String item : patterns) {
                this.addToPatterns(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPatterns() {
        return this.patterns != null && !this.patterns.isEmpty();
    }

    @Override
    @Deprecated
    public PodSelectorSpec getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public PodSelectorSpec buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(PodSelectorSpec selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new PodSelectorSpecBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public DNSChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public DNSChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public DNSChaosSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public DNSChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new PodSelectorSpecBuilder().build());
    }

    @Override
    public DNSChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSChaosSpecFluentImpl that = (DNSChaosSpecFluentImpl)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.containerNames, that.containerNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.patterns, that.patterns)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.containerNames, this.duration, this.mode, this.patterns, this.selector, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.containerNames != null && !this.containerNames.isEmpty()) {
            sb.append("containerNames:");
            sb.append(this.containerNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.patterns != null && !this.patterns.isEmpty()) {
            sb.append("patterns:");
            sb.append(this.patterns + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }

    class SelectorNestedImpl<N>
    extends PodSelectorSpecFluentImpl<DNSChaosSpecFluent.SelectorNested<N>>
    implements DNSChaosSpecFluent.SelectorNested<N>,
    Nested<N> {
        PodSelectorSpecBuilder builder;

        SelectorNestedImpl(PodSelectorSpec item) {
            this.builder = new PodSelectorSpecBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new PodSelectorSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSChaosSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

