/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.CPUStressor;
import io.fabric8.chaosmesh.v1alpha1.CPUStressorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CPUStressorFluentImpl<A extends CPUStressorFluent<A>>
extends BaseFluent<A>
implements CPUStressorFluent<A> {
    private Integer load;
    private List<String> options = new ArrayList<String>();
    private Integer workers;

    public CPUStressorFluentImpl() {
    }

    public CPUStressorFluentImpl(CPUStressor instance) {
        if (instance != null) {
            this.withLoad(instance.getLoad());
            this.withOptions(instance.getOptions());
            this.withWorkers(instance.getWorkers());
        }
    }

    @Override
    public Integer getLoad() {
        return this.load;
    }

    @Override
    public A withLoad(Integer load) {
        this.load = load;
        return (A)this;
    }

    @Override
    public Boolean hasLoad() {
        return this.load != null;
    }

    @Override
    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String ... items) {
        for (String item : items) {
            if (this.options == null) continue;
            this.options.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOptions(Collection<String> items) {
        for (String item : items) {
            if (this.options == null) continue;
            this.options.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public String getOption(int index) {
        return this.options.get(index);
    }

    @Override
    public String getFirstOption() {
        return this.options.get(0);
    }

    @Override
    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    @Override
    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)this;
    }

    @Override
    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    @Override
    public Integer getWorkers() {
        return this.workers;
    }

    @Override
    public A withWorkers(Integer workers) {
        this.workers = workers;
        return (A)this;
    }

    @Override
    public Boolean hasWorkers() {
        return this.workers != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUStressorFluentImpl that = (CPUStressorFluentImpl)o;
        if (!Objects.equals(this.load, that.load)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        return Objects.equals(this.workers, that.workers);
    }

    public int hashCode() {
        return Objects.hash(this.load, this.options, this.workers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.load != null) {
            sb.append("load:");
            sb.append(this.load + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.workers != null) {
            sb.append("workers:");
            sb.append(this.workers);
        }
        sb.append("}");
        return sb.toString();
    }
}

