/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.RawIPSet;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RawIPSetFluent<A extends RawIPSetFluent<A>>
extends BaseFluent<A> {
    private List<String> cidrs = new ArrayList<String>();
    private String name;
    private String source;
    private Map<String, Object> additionalProperties;

    public RawIPSetFluent() {
    }

    public RawIPSetFluent(RawIPSet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RawIPSet instance) {
        RawIPSet rawIPSet = instance = instance != null ? instance : new RawIPSet();
        if (instance != null) {
            this.withCidrs(instance.getCidrs());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.add(index, item);
        return (A)((Object)this);
    }

    public A setToCidrs(int index, String item) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        this.cidrs.set(index, item);
        return (A)((Object)this);
    }

    public A addToCidrs(String ... items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCidrs(Collection<String> items) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.cidrs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCidrs(String ... items) {
        if (this.cidrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cidrs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCidrs(Collection<String> items) {
        if (this.cidrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cidrs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCidrs() {
        return this.cidrs;
    }

    public String getCidr(int index) {
        return this.cidrs.get(index);
    }

    public String getFirstCidr() {
        return this.cidrs.get(0);
    }

    public String getLastCidr() {
        return this.cidrs.get(this.cidrs.size() - 1);
    }

    public String getMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCidr(Predicate<String> predicate) {
        for (String item : this.cidrs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCidrs(List<String> cidrs) {
        if (cidrs != null) {
            this.cidrs = new ArrayList<String>();
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        } else {
            this.cidrs = null;
        }
        return (A)((Object)this);
    }

    public A withCidrs(String ... cidrs) {
        if (this.cidrs != null) {
            this.cidrs.clear();
            this._visitables.remove((Object)"cidrs");
        }
        if (cidrs != null) {
            for (String item : cidrs) {
                this.addToCidrs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !this.cidrs.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawIPSetFluent that = (RawIPSetFluent)((Object)o);
        if (!Objects.equals(this.cidrs, that.cidrs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cidrs, this.name, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrs != null && !this.cidrs.isEmpty()) {
            sb.append("cidrs:");
            sb.append(this.cidrs + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

