package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class Route53KubernetesAuthFluent<A extends Route53KubernetesAuthFluent<A>> extends BaseFluent<A>{
  public Route53KubernetesAuthFluent() {
  }
  
  public Route53KubernetesAuthFluent(Route53KubernetesAuth instance) {
    this.copyInstance(instance);
  }
  private ServiceAccountRefBuilder serviceAccountRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Route53KubernetesAuth instance) {
    instance = (instance != null ? instance : new Route53KubernetesAuth());
    if (instance != null) {
          this.withServiceAccountRef(instance.getServiceAccountRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ServiceAccountRef buildServiceAccountRef() {
    return this.serviceAccountRef != null ? this.serviceAccountRef.build() : null;
  }
  
  public A withServiceAccountRef(ServiceAccountRef serviceAccountRef) {
    this._visitables.remove("serviceAccountRef");
    if (serviceAccountRef != null) {
        this.serviceAccountRef = new ServiceAccountRefBuilder(serviceAccountRef);
        this._visitables.get("serviceAccountRef").add(this.serviceAccountRef);
    } else {
        this.serviceAccountRef = null;
        this._visitables.get("serviceAccountRef").remove(this.serviceAccountRef);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccountRef() {
    return this.serviceAccountRef != null;
  }
  
  public ServiceAccountRefNested<A> withNewServiceAccountRef() {
    return new ServiceAccountRefNested(null);
  }
  
  public ServiceAccountRefNested<A> withNewServiceAccountRefLike(ServiceAccountRef item) {
    return new ServiceAccountRefNested(item);
  }
  
  public ServiceAccountRefNested<A> editServiceAccountRef() {
    return withNewServiceAccountRefLike(java.util.Optional.ofNullable(buildServiceAccountRef()).orElse(null));
  }
  
  public ServiceAccountRefNested<A> editOrNewServiceAccountRef() {
    return withNewServiceAccountRefLike(java.util.Optional.ofNullable(buildServiceAccountRef()).orElse(new ServiceAccountRefBuilder().build()));
  }
  
  public ServiceAccountRefNested<A> editOrNewServiceAccountRefLike(ServiceAccountRef item) {
    return withNewServiceAccountRefLike(java.util.Optional.ofNullable(buildServiceAccountRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Route53KubernetesAuthFluent that = (Route53KubernetesAuthFluent) o;
    if (!java.util.Objects.equals(serviceAccountRef, that.serviceAccountRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(serviceAccountRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (serviceAccountRef != null) { sb.append("serviceAccountRef:"); sb.append(serviceAccountRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceAccountRefNested<N> extends ServiceAccountRefFluent<ServiceAccountRefNested<N>> implements Nested<N>{
    ServiceAccountRefNested(ServiceAccountRef item) {
      this.builder = new ServiceAccountRefBuilder(this, item);
    }
    ServiceAccountRefBuilder builder;
    
    public N and() {
      return (N) Route53KubernetesAuthFluent.this.withServiceAccountRef(builder.build());
    }
    
    public N endServiceAccountRef() {
      return and();
    }
    
  
  }

}