package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEExternalAccountBindingFluent<A extends ACMEExternalAccountBindingFluent<A>> extends BaseFluent<A>{
  public ACMEExternalAccountBindingFluent() {
  }
  
  public ACMEExternalAccountBindingFluent(ACMEExternalAccountBinding instance) {
    this.copyInstance(instance);
  }
  private String keyAlgorithm;
  private String keyID;
  private SecretKeySelectorBuilder keySecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEExternalAccountBinding instance) {
    instance = (instance != null ? instance : new ACMEExternalAccountBinding());
    if (instance != null) {
          this.withKeyAlgorithm(instance.getKeyAlgorithm());
          this.withKeyID(instance.getKeyID());
          this.withKeySecretRef(instance.getKeySecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getKeyAlgorithm() {
    return this.keyAlgorithm;
  }
  
  public A withKeyAlgorithm(String keyAlgorithm) {
    this.keyAlgorithm = keyAlgorithm;
    return (A) this;
  }
  
  public boolean hasKeyAlgorithm() {
    return this.keyAlgorithm != null;
  }
  
  public String getKeyID() {
    return this.keyID;
  }
  
  public A withKeyID(String keyID) {
    this.keyID = keyID;
    return (A) this;
  }
  
  public boolean hasKeyID() {
    return this.keyID != null;
  }
  
  public SecretKeySelector buildKeySecretRef() {
    return this.keySecretRef != null ? this.keySecretRef.build() : null;
  }
  
  public A withKeySecretRef(SecretKeySelector keySecretRef) {
    this._visitables.remove("keySecretRef");
    if (keySecretRef != null) {
        this.keySecretRef = new SecretKeySelectorBuilder(keySecretRef);
        this._visitables.get("keySecretRef").add(this.keySecretRef);
    } else {
        this.keySecretRef = null;
        this._visitables.get("keySecretRef").remove(this.keySecretRef);
    }
    return (A) this;
  }
  
  public boolean hasKeySecretRef() {
    return this.keySecretRef != null;
  }
  
  public A withNewKeySecretRef(String key,String name) {
    return (A)withKeySecretRef(new SecretKeySelector(key, name));
  }
  
  public KeySecretRefNested<A> withNewKeySecretRef() {
    return new KeySecretRefNested(null);
  }
  
  public KeySecretRefNested<A> withNewKeySecretRefLike(SecretKeySelector item) {
    return new KeySecretRefNested(item);
  }
  
  public KeySecretRefNested<A> editKeySecretRef() {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(null));
  }
  
  public KeySecretRefNested<A> editOrNewKeySecretRef() {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public KeySecretRefNested<A> editOrNewKeySecretRefLike(SecretKeySelector item) {
    return withNewKeySecretRefLike(java.util.Optional.ofNullable(buildKeySecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEExternalAccountBindingFluent that = (ACMEExternalAccountBindingFluent) o;
    if (!java.util.Objects.equals(keyAlgorithm, that.keyAlgorithm)) return false;
    if (!java.util.Objects.equals(keyID, that.keyID)) return false;
    if (!java.util.Objects.equals(keySecretRef, that.keySecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(keyAlgorithm,  keyID,  keySecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (keyAlgorithm != null) { sb.append("keyAlgorithm:"); sb.append(keyAlgorithm + ","); }
    if (keyID != null) { sb.append("keyID:"); sb.append(keyID + ","); }
    if (keySecretRef != null) { sb.append("keySecretRef:"); sb.append(keySecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KeySecretRefNested<N> extends SecretKeySelectorFluent<KeySecretRefNested<N>> implements Nested<N>{
    KeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEExternalAccountBindingFluent.this.withKeySecretRef(builder.build());
    }
    
    public N endKeySecretRef() {
      return and();
    }
    
  
  }

}