package io.fabric8.certmanager.api.model.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertificatePrivateKeyFluent<A extends CertificatePrivateKeyFluent<A>> extends BaseFluent<A>{
  public CertificatePrivateKeyFluent() {
  }
  
  public CertificatePrivateKeyFluent(CertificatePrivateKey instance) {
    this.copyInstance(instance);
  }
  private String algorithm;
  private String encoding;
  private String rotationPolicy;
  private Integer size;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CertificatePrivateKey instance) {
    instance = (instance != null ? instance : new CertificatePrivateKey());
    if (instance != null) {
          this.withAlgorithm(instance.getAlgorithm());
          this.withEncoding(instance.getEncoding());
          this.withRotationPolicy(instance.getRotationPolicy());
          this.withSize(instance.getSize());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAlgorithm() {
    return this.algorithm;
  }
  
  public A withAlgorithm(String algorithm) {
    this.algorithm = algorithm;
    return (A) this;
  }
  
  public boolean hasAlgorithm() {
    return this.algorithm != null;
  }
  
  public String getEncoding() {
    return this.encoding;
  }
  
  public A withEncoding(String encoding) {
    this.encoding = encoding;
    return (A) this;
  }
  
  public boolean hasEncoding() {
    return this.encoding != null;
  }
  
  public String getRotationPolicy() {
    return this.rotationPolicy;
  }
  
  public A withRotationPolicy(String rotationPolicy) {
    this.rotationPolicy = rotationPolicy;
    return (A) this;
  }
  
  public boolean hasRotationPolicy() {
    return this.rotationPolicy != null;
  }
  
  public Integer getSize() {
    return this.size;
  }
  
  public A withSize(Integer size) {
    this.size = size;
    return (A) this;
  }
  
  public boolean hasSize() {
    return this.size != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificatePrivateKeyFluent that = (CertificatePrivateKeyFluent) o;
    if (!java.util.Objects.equals(algorithm, that.algorithm)) return false;
    if (!java.util.Objects.equals(encoding, that.encoding)) return false;
    if (!java.util.Objects.equals(rotationPolicy, that.rotationPolicy)) return false;
    if (!java.util.Objects.equals(size, that.size)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(algorithm,  encoding,  rotationPolicy,  size,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (algorithm != null) { sb.append("algorithm:"); sb.append(algorithm + ","); }
    if (encoding != null) { sb.append("encoding:"); sb.append(encoding + ","); }
    if (rotationPolicy != null) { sb.append("rotationPolicy:"); sb.append(rotationPolicy + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}