package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderDigitalOceanFluent<A extends ACMEIssuerDNS01ProviderDigitalOceanFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderDigitalOceanFluent() {
  }
  
  public ACMEIssuerDNS01ProviderDigitalOceanFluent(ACMEIssuerDNS01ProviderDigitalOcean instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelectorBuilder tokenSecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderDigitalOcean instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderDigitalOcean());
    if (instance != null) {
          this.withTokenSecretRef(instance.getTokenSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretKeySelector buildTokenSecretRef() {
    return this.tokenSecretRef != null ? this.tokenSecretRef.build() : null;
  }
  
  public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
    this._visitables.remove("tokenSecretRef");
    if (tokenSecretRef != null) {
        this.tokenSecretRef = new SecretKeySelectorBuilder(tokenSecretRef);
        this._visitables.get("tokenSecretRef").add(this.tokenSecretRef);
    } else {
        this.tokenSecretRef = null;
        this._visitables.get("tokenSecretRef").remove(this.tokenSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasTokenSecretRef() {
    return this.tokenSecretRef != null;
  }
  
  public A withNewTokenSecretRef(String key,String name) {
    return (A)withTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public TokenSecretRefNested<A> withNewTokenSecretRef() {
    return new TokenSecretRefNested(null);
  }
  
  public TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
    return new TokenSecretRefNested(item);
  }
  
  public TokenSecretRefNested<A> editTokenSecretRef() {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(null));
  }
  
  public TokenSecretRefNested<A> editOrNewTokenSecretRef() {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
    return withNewTokenSecretRefLike(java.util.Optional.ofNullable(buildTokenSecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderDigitalOceanFluent that = (ACMEIssuerDNS01ProviderDigitalOceanFluent) o;
    if (!java.util.Objects.equals(tokenSecretRef, that.tokenSecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(tokenSecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (tokenSecretRef != null) { sb.append("tokenSecretRef:"); sb.append(tokenSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TokenSecretRefNested<N> extends SecretKeySelectorFluent<TokenSecretRefNested<N>> implements Nested<N>{
    TokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderDigitalOceanFluent.this.withTokenSecretRef(builder.build());
    }
    
    public N endTokenSecretRef() {
      return and();
    }
    
  
  }

}