/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.domain;

import io.eventuate.DispatchedEvent;
import io.eventuate.Event;
import io.eventuate.javaclient.domain.SwimlaneDispatcher;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwimlaneBasedDispatcher {
    private static Logger logger = LoggerFactory.getLogger(SwimlaneBasedDispatcher.class);
    private final ConcurrentHashMap<Integer, SwimlaneDispatcher> map = new ConcurrentHashMap();
    private Executor executor;
    private String subscriberId;

    public SwimlaneBasedDispatcher(String subscriberId, Executor executor) {
        this.subscriberId = subscriberId;
        this.executor = executor;
    }

    public CompletableFuture<?> dispatch(DispatchedEvent<Event> de, Function<DispatchedEvent<Event>, CompletableFuture<?>> target) {
        Integer swimlane = de.getSwimlane();
        SwimlaneDispatcher stuff = this.map.get(swimlane);
        if (stuff == null) {
            logger.trace("No dispatcher for {} {}. Attempting to create", (Object)this.subscriberId, (Object)swimlane);
            stuff = new SwimlaneDispatcher(this.subscriberId, swimlane, this.executor);
            SwimlaneDispatcher r = this.map.putIfAbsent(swimlane, stuff);
            if (r != null) {
                logger.trace("Using concurrently created SwimlaneDispatcher for {} {}", (Object)this.subscriberId, (Object)swimlane);
                stuff = r;
            } else {
                logger.trace("Using newly created SwimlaneDispatcher for {} {}", (Object)this.subscriberId, (Object)swimlane);
            }
        }
        return stuff.dispatch(de, target);
    }
}

