/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;

public class HttpClientPush
implements HttpRequest {
    final String uri;
    final HttpMethod method;
    final HostAndPort authority;
    final HttpClientStream stream;
    final MultiMap headers;

    public HttpClientPush(Http2Headers headers, HttpClientStream stream) {
        String rawMethod = headers.method().toString();
        String authority = headers.authority() != null ? headers.authority().toString() : null;
        Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
        int pos = authority == null ? -1 : authority.indexOf(58);
        this.authority = pos == -1 ? HostAndPort.create(authority, 80) : HostAndPort.create(authority.substring(0, pos), Integer.parseInt(authority.substring(pos + 1)));
        this.method = HttpMethod.valueOf(rawMethod);
        this.uri = headers.path().toString();
        this.stream = stream;
        this.headers = headersMap;
    }

    @Override
    public int id() {
        return this.stream.id();
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String absoluteURI() {
        return null;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.stream.connection().remoteAddress();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }
}

