/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.CharsetUtil;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.MxRecordImpl;
import io.vertx.core.dns.impl.SrvRecordImpl;
import io.vertx.core.dns.impl.StartOfAuthorityRecord;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class RecordDecoder {
    private static final Logger log = LoggerFactory.getLogger(RecordDecoder.class);
    static Function<DnsRecord, MxRecord> MX = record -> {
        if (record.type() == DnsRecordType.MX) {
            ByteBuf packet = ((DnsRawRecord)record).content();
            short priority = packet.readShort();
            String name = RecordDecoder.readName(packet);
            long ttl = record.timeToLive();
            return new MxRecordImpl(ttl, priority, name);
        }
        return null;
    };
    static Function<DnsRecord, String> DOMAIN = record -> {
        if (record instanceof DnsPtrRecord) {
            String val = ((DnsPtrRecord)record).hostname();
            if (val.endsWith(".")) {
                val = val.substring(0, val.length() - 1);
            }
            return val;
        }
        ByteBuf content = ((DnsRawRecord)record).content();
        return RecordDecoder.getName(content, content.readerIndex());
    };
    static Function<DnsRecord, String> A = RecordDecoder.address(DnsRecordType.A, 4);
    static Function<DnsRecord, String> AAAA = RecordDecoder.address(DnsRecordType.AAAA, 16);
    static Function<DnsRecord, SrvRecord> SRV = record -> {
        if (record.type() == DnsRecordType.SRV) {
            ByteBuf packet = ((DnsRawRecord)record).content();
            short priority = packet.readShort();
            short weight = packet.readShort();
            int port = packet.readUnsignedShort();
            long ttl = record.timeToLive();
            String target = RecordDecoder.readName(packet);
            String[] parts = record.name().split("\\.", 3);
            String service = parts[0];
            String protocol = parts[1];
            String name = parts[2];
            return new SrvRecordImpl(ttl, priority, weight, port, name, protocol, service, target);
        }
        return null;
    };
    static Function<DnsRecord, StartOfAuthorityRecord> SOA = record -> {
        if (record.type() == DnsRecordType.SOA) {
            ByteBuf packet = ((DnsRawRecord)record).content();
            String mName = RecordDecoder.readName(packet);
            String rName = RecordDecoder.readName(packet);
            long serial = packet.readUnsignedInt();
            int refresh = packet.readInt();
            int retry = packet.readInt();
            int expire = packet.readInt();
            long minimum = packet.readUnsignedInt();
            return new StartOfAuthorityRecord(mName, rName, serial, refresh, retry, expire, minimum);
        }
        return null;
    };
    static Function<DnsRecord, List<String>> TXT = record -> {
        if (record.type() == DnsRecordType.TXT) {
            short len;
            ArrayList<String> list = new ArrayList<String>();
            ByteBuf data = ((DnsRawRecord)record).content();
            for (int index = data.readerIndex(); index < data.writerIndex(); index += len) {
                len = data.getUnsignedByte(index++);
                list.add(data.toString(index, len, CharsetUtil.UTF_8));
            }
            return list;
        }
        return null;
    };
    private static final Map<DnsRecordType, Function<DnsRecord, ?>> decoders = new HashMap();

    RecordDecoder() {
    }

    static Function<DnsRecord, String> address(DnsRecordType type, int octets) {
        return record -> {
            if (record.type() == type) {
                ByteBuf data = ((DnsRawRecord)record).content();
                int size = data.readableBytes();
                if (size != octets) {
                    throw new DecoderException("Invalid content length, or reader index when decoding address [index: " + data.readerIndex() + ", expected length: " + octets + ", actual: " + size + "].");
                }
                byte[] address = new byte[octets];
                data.getBytes(data.readerIndex(), address);
                try {
                    return InetAddress.getByAddress(address).getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw new DecoderException("Could not convert address " + data.toString(data.readerIndex(), size, CharsetUtil.UTF_8) + " to InetAddress.");
                }
            }
            return null;
        };
    }

    static String readName(ByteBuf buf) {
        int position = -1;
        StringBuilder name = new StringBuilder();
        short len = buf.readUnsignedByte();
        while (buf.isReadable() && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                if (position == -1) {
                    position = buf.readerIndex() + 1;
                }
                buf.readerIndex((len & 0x3F) << 8 | buf.readUnsignedByte());
            } else {
                name.append(buf.toString(buf.readerIndex(), len, CharsetUtil.UTF_8)).append(".");
                buf.skipBytes(len);
            }
            len = buf.readUnsignedByte();
        }
        if (position != -1) {
            buf.readerIndex(position);
        }
        if (name.length() == 0) {
            return null;
        }
        return name.substring(0, name.length() - 1);
    }

    static String getName(ByteBuf buf, int offset) {
        StringBuilder name = new StringBuilder();
        short len = buf.getUnsignedByte(offset++);
        while (buf.writerIndex() > offset && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                offset = (len & 0x3F) << 8 | buf.getUnsignedByte(offset++);
            } else {
                name.append(buf.toString(offset, len, CharsetUtil.UTF_8)).append(".");
                offset += len;
            }
            len = buf.getUnsignedByte(offset++);
        }
        if (name.length() == 0) {
            return null;
        }
        return name.substring(0, name.length() - 1);
    }

    static <T> T decode(DnsRecord record) {
        DnsRecordType type = record.type();
        Function<DnsRecord, ?> decoder = decoders.get(type);
        if (decoder == null) {
            throw new DecoderException("DNS record decoding error occurred: Unsupported resource record type [id: " + String.valueOf(type) + "].");
        }
        T result = null;
        try {
            result = (T)decoder.apply(record);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.getCause());
        }
        return result;
    }

    static {
        decoders.put(DnsRecordType.A, A);
        decoders.put(DnsRecordType.AAAA, AAAA);
        decoders.put(DnsRecordType.MX, MX);
        decoders.put(DnsRecordType.TXT, TXT);
        decoders.put(DnsRecordType.SRV, SRV);
        decoders.put(DnsRecordType.NS, DOMAIN);
        decoders.put(DnsRecordType.CNAME, DOMAIN);
        decoders.put(DnsRecordType.PTR, DOMAIN);
        decoders.put(DnsRecordType.SOA, SOA);
    }
}

