/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.internal.AuthorityVerifier;
import io.grpc.netty.ProtocolNegotiators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;

final class X509AuthorityVerifier
implements AuthorityVerifier {
    private final SSLEngine sslEngine;
    private final X509TrustManager x509ExtendedTrustManager;
    private static final Method checkServerTrustedMethod;

    public X509AuthorityVerifier(SSLEngine sslEngine, X509TrustManager x509ExtendedTrustManager) {
        this.sslEngine = Preconditions.checkNotNull(sslEngine, "sslEngine");
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
    }

    @Override
    public Status verifyAuthority(@Nonnull String authority) {
        Status peerVerificationStatus;
        if (this.x509ExtendedTrustManager == null) {
            return Status.UNAVAILABLE.withDescription("Can't allow authority override in rpc when X509ExtendedTrustManager is not available");
        }
        try {
            this.verifyAuthorityAllowedForPeerCert(this.removeAnyPortNumber(authority));
            peerVerificationStatus = Status.OK;
        }
        catch (IllegalAccessException | IllegalStateException | InvocationTargetException | CertificateException | SSLPeerUnverifiedException e) {
            peerVerificationStatus = Status.UNAVAILABLE.withDescription(String.format("Peer hostname verification during rpc failed for authority '%s'", authority)).withCause(e);
        }
        return peerVerificationStatus;
    }

    private String removeAnyPortNumber(String authority) {
        int closingSquareBracketIndex = authority.lastIndexOf(93);
        int portNumberSeperatorColonIndex = authority.lastIndexOf(58);
        if (portNumberSeperatorColonIndex > closingSquareBracketIndex) {
            return authority.substring(0, portNumberSeperatorColonIndex);
        }
        return authority;
    }

    private void verifyAuthorityAllowedForPeerCert(String authority) throws SSLPeerUnverifiedException, CertificateException, InvocationTargetException, IllegalAccessException {
        ProtocolNegotiators.SslEngineWrapper sslEngineWrapper = new ProtocolNegotiators.SslEngineWrapper(this.sslEngine, authority);
        Certificate[] peerCertificates = this.sslEngine.getSession().getPeerCertificates();
        X509Certificate[] x509PeerCertificates = new X509Certificate[peerCertificates.length];
        for (int i = 0; i < peerCertificates.length; ++i) {
            x509PeerCertificates[i] = (X509Certificate)peerCertificates[i];
        }
        if (checkServerTrustedMethod == null) {
            throw new IllegalStateException("checkServerTrustedMethod not found");
        }
        checkServerTrustedMethod.invoke((Object)this.x509ExtendedTrustManager, x509PeerCertificates, "RSA", sslEngineWrapper);
    }

    static {
        Method method = null;
        try {
            Class<?> x509ExtendedTrustManagerClass = Class.forName("javax.net.ssl.X509ExtendedTrustManager");
            method = x509ExtendedTrustManagerClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, SSLEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        checkServerTrustedMethod = method;
    }
}

