/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import com.google.common.base.Preconditions;

public final class PutOption {
    public static final PutOption DEFAULT = PutOption.builder().build();
    private final long leaseId;
    private final boolean prevKV;
    private final boolean autoRetry;

    private PutOption(long leaseId, boolean prevKV, boolean autoRetry) {
        this.leaseId = leaseId;
        this.prevKV = prevKV;
        this.autoRetry = autoRetry;
    }

    public long getLeaseId() {
        return this.leaseId;
    }

    public boolean getPrevKV() {
        return this.prevKV;
    }

    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    @Deprecated
    public static Builder newBuilder() {
        return PutOption.builder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long leaseId = 0L;
        private boolean prevKV = false;
        private boolean autoRetry = false;

        private Builder() {
        }

        public Builder withLeaseId(long leaseId) {
            Preconditions.checkArgument(leaseId >= 0L, "leaseId should greater than or equal to zero: leaseId=%s", leaseId);
            this.leaseId = leaseId;
            return this;
        }

        public Builder withPrevKV() {
            this.prevKV = true;
            return this;
        }

        public Builder withAutoRetry() {
            this.autoRetry = true;
            return this;
        }

        public PutOption build() {
            return new PutOption(this.leaseId, this.prevKV, this.autoRetry);
        }
    }
}

