/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import java.nio.charset.StandardCharsets;

public final class URIDecoder {
    private URIDecoder() {
        throw new RuntimeException("Static Class");
    }

    public static String decodeURIComponent(String s2) {
        return URIDecoder.decodeURIComponent(s2, true);
    }

    private static int indexOfPercentOrPlus(String s2) {
        int size = s2.length();
        for (int i = 0; i < size; ++i) {
            char c = s2.charAt(i);
            if (c != '%' && c != '+') continue;
            return i;
        }
        return -1;
    }

    public static String decodeURIComponent(String s2, boolean plus) {
        int i;
        if (s2 == null) {
            return null;
        }
        int n = i = !plus ? s2.indexOf(37) : URIDecoder.indexOfPercentOrPlus(s2);
        if (i == -1) {
            return s2;
        }
        return URIDecoder.decodeAndTransformURIComponent(s2, i, plus);
    }

    private static String decodeAndTransformURIComponent(String s2, int i, boolean plus) {
        byte[] buf = s2.getBytes(StandardCharsets.UTF_8);
        int pos = i;
        int size = s2.length();
        while (i < size) {
            int c = s2.charAt(i);
            if (c == 37) {
                if (i == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s2);
                }
                if ((c = (int)s2.charAt(++i)) == 37) {
                    buf[pos++] = 37;
                    break;
                }
                if (i >= size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s2);
                }
                c = URIDecoder.decodeHexNibble((char)c);
                char c2 = URIDecoder.decodeHexNibble(s2.charAt(++i));
                if (c == 65535 || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s2.charAt(i - 1) + s2.charAt(i) + "' at index " + (i - 2) + " of: " + s2);
                }
                c = (char)(c * 16 + c2);
                buf[pos++] = (byte)c;
            } else {
                buf[pos++] = (byte)(plus && c == 43 ? 32 : c);
            }
            ++i;
        }
        return new String(buf, 0, pos, StandardCharsets.UTF_8);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

