/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsyncMapping;
import io.netty.util.concurrent.ImmediateExecutor;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.VertxSniHandler;
import io.vertx.core.net.impl.VertxSslContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;

public class SslChannelProvider {
    private final long sslHandshakeTimeout;
    private final TimeUnit sslHandshakeTimeoutUnit;
    private final Executor workerPool;
    private final boolean useWorkerPool;
    private final boolean sni;
    private final boolean useAlpn;
    private final boolean trustAll;
    private final SslContextProvider sslContextProvider;
    private final SslContext[] sslContexts = new SslContext[2];
    private final Map<String, SslContext>[] sslContextMaps = new Map[]{new ConcurrentHashMap(), new ConcurrentHashMap()};

    public SslChannelProvider(SslContextProvider sslContextProvider, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit, boolean sni, boolean trustAll, boolean useAlpn, Executor workerPool, boolean useWorkerPool) {
        this.workerPool = workerPool;
        this.useWorkerPool = useWorkerPool;
        this.useAlpn = useAlpn;
        this.sni = sni;
        this.trustAll = trustAll;
        this.sslHandshakeTimeout = sslHandshakeTimeout;
        this.sslHandshakeTimeoutUnit = sslHandshakeTimeoutUnit;
        this.sslContextProvider = sslContextProvider;
    }

    public SslContextProvider sslContextProvider() {
        return this.sslContextProvider;
    }

    public SslContext sslClientContext(String serverName, boolean useAlpn) {
        return this.sslClientContext(serverName, useAlpn, this.trustAll);
    }

    public SslContext sslClientContext(String serverName, boolean useAlpn, boolean trustAll) {
        int idx = SslChannelProvider.idx(useAlpn);
        if (this.sslContexts[idx] == null) {
            VertxSslContext context = this.sslContextProvider.createClientContext(serverName, useAlpn, trustAll);
            this.sslContexts[idx] = context;
        }
        return this.sslContexts[idx];
    }

    public SslContext sslServerContext(boolean useAlpn) {
        int idx = SslChannelProvider.idx(useAlpn);
        if (this.sslContexts[idx] == null) {
            this.sslContexts[idx] = this.sslContextProvider.createServerContext(useAlpn);
        }
        return this.sslContexts[idx];
    }

    public AsyncMapping<? super String, ? extends SslContext> serverNameMapping() {
        return (serverName, promise) -> {
            this.workerPool.execute(() -> {
                if (serverName == null) {
                    promise.setSuccess(this.sslServerContext(this.useAlpn));
                } else {
                    TrustManager[] trustManagers;
                    KeyManagerFactory kmf;
                    try {
                        kmf = this.sslContextProvider.resolveKeyManagerFactory((String)serverName);
                    }
                    catch (Exception e) {
                        promise.setFailure(e);
                        return;
                    }
                    try {
                        trustManagers = this.sslContextProvider.resolveTrustManagers((String)serverName);
                    }
                    catch (Exception e) {
                        promise.setFailure(e);
                        return;
                    }
                    int idx = SslChannelProvider.idx(this.useAlpn);
                    SslContext sslContext = this.sslContextMaps[idx].computeIfAbsent((String)serverName, s2 -> this.sslContextProvider.createServerContext(kmf, trustManagers, (String)s2, this.useAlpn));
                    promise.setSuccess(sslContext);
                }
            });
            return promise;
        };
    }

    public SslHandler createClientSslHandler(SocketAddress remoteAddress, String serverName, boolean useAlpn) {
        SslContext sslContext = this.sslClientContext(serverName, useAlpn);
        Executor delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = remoteAddress.isDomainSocket() ? sslContext.newHandler(ByteBufAllocator.DEFAULT, delegatedTaskExec) : sslContext.newHandler(ByteBufAllocator.DEFAULT, remoteAddress.host(), remoteAddress.port(), delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.sslHandshakeTimeout, this.sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    public ChannelHandler createServerHandler() {
        if (this.sni) {
            return this.createSniHandler();
        }
        return this.createServerSslHandler(this.useAlpn);
    }

    private SslHandler createServerSslHandler(boolean useAlpn) {
        SslContext sslContext = this.sslServerContext(useAlpn);
        Executor delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = sslContext.newHandler(ByteBufAllocator.DEFAULT, delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.sslHandshakeTimeout, this.sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    private SniHandler createSniHandler() {
        Executor delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        return new VertxSniHandler(this.serverNameMapping(), this.sslHandshakeTimeoutUnit.toMillis(this.sslHandshakeTimeout), delegatedTaskExec);
    }

    private static int idx(boolean useAlpn) {
        return useAlpn ? 0 : 1;
    }
}

