/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpServerConnectionHandler;
import io.vertx.core.http.impl.HttpServerWorker;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslChannelProvider;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HttpServerImpl
extends TCPServerBase
implements HttpServer,
Closeable,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t2 -> log.trace("Connection failure", (Throwable)t2);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    final HttpServerOptions options;
    private final HttpStreamHandler<ServerWebSocket> wsStream = new HttpStreamHandler();
    private final HttpStreamHandler<HttpServerRequest> requestStream = new HttpStreamHandler();
    private Handler<HttpServerRequest> invalidRequestHandler;
    private Handler<HttpConnection> connectionHandler;
    private Handler<Throwable> exceptionHandler;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        super(vertx, options);
        this.options = new HttpServerOptions(options);
    }

    @Override
    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        if (vertxMetrics != null) {
            return vertxMetrics.createHttpServerMetrics(this.options, localAddress);
        }
        return null;
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public ReadStream<HttpServerRequest> requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        this.webSocketStream().handler(handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> handler) {
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> webSocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ReadStream<ServerWebSocket> webSocketStream() {
        return this.wsStream;
    }

    @Override
    public Future<HttpServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    protected BiConsumer<Channel, SslChannelProvider> childHandler(ContextInternal context, SocketAddress address, GlobalTrafficShapingHandler trafficShapingHandler) {
        ContextInternal connContext = context.isEventLoopContext() ? context : this.vertx.createEventLoopContext(context.nettyEventLoop(), context.workerPool(), context.classLoader());
        String host = address.isInetSocket() ? address.host() : "localhost";
        int port = address.port();
        String serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port;
        HttpServerConnectionHandler hello = new HttpServerConnectionHandler(this, ((HttpStreamHandler)this.requestStream).handler, this.invalidRequestHandler, ((HttpStreamHandler)this.wsStream).handler, this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler);
        Supplier<ContextInternal> streamContextSupplier = context::duplicate;
        return new HttpServerWorker(connContext, streamContextSupplier, this, this.vertx, this.options, serverOrigin, hello, hello.exceptionHandler, trafficShapingHandler);
    }

    @Override
    protected SSLHelper createSSLHelper() {
        return new SSLHelper(this.options, this.options.getAlpnVersions().stream().map(HttpVersion::alpnName).collect(Collectors.toList()));
    }

    @Override
    public synchronized Future<HttpServer> listen(SocketAddress address) {
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or WebSocket handler first");
        }
        return this.bind(address).map(this);
    }

    @Override
    public Future<Void> close() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> done) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        if (done != null) {
            promise.future().onComplete(done);
        }
    }

    @Override
    public synchronized void close(Promise<Void> completion) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            completion.future().onComplete(ar -> {
                if (wsEndHandler != null) {
                    wsEndHandler.handle(null);
                }
                if (requestEndHandler != null) {
                    requestEndHandler.handle(null);
                }
            });
        }
        super.close(completion);
    }

    public boolean isClosed() {
        return !this.isListening();
    }

    boolean requestAccept() {
        return this.requestStream.accept();
    }

    boolean wsAccept() {
        return this.wsStream.accept();
    }

    class HttpStreamHandler<C extends ReadStream<Buffer>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private long demand = Long.MAX_VALUE;
        private Handler<Void> endHandler;

        HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accept() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                boolean accept;
                boolean bl = accept = this.demand > 0L;
                if (accept && this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                return accept;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.isListening()) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = 0L;
                return this;
            }
        }

        @Override
        public ReadStream fetch(long amount) {
            if (amount > 0L) {
                this.demand += amount;
                if (this.demand < 0L) {
                    this.demand = Long.MAX_VALUE;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = Long.MAX_VALUE;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public ReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

